/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.treetable;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.componenttree.api.BadgeItem;
import com.android.tools.componenttree.treetable.Cell;
import com.android.tools.componenttree.treetable.IntTableCellRendererKt;
import com.android.tools.componenttree.treetable.TreeTableImplKt;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J8\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0014\u0010\u0018\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0013H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/componenttree/treetable/BadgeRenderer;", "Ljavax/swing/table/TableCellRenderer;", "Lcom/intellij/ui/components/JBLabel;", "badge", "Lcom/android/tools/componenttree/api/BadgeItem;", "emptyIcon", "Ljavax/swing/Icon;", "(Lcom/android/tools/componenttree/api/BadgeItem;Ljavax/swing/Icon;)V", "getBadge", "()Lcom/android/tools/componenttree/api/BadgeItem;", "getEmptyIcon", "()Ljavax/swing/Icon;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "white", "focused", "intellij.android.layout-ui"})
public final class BadgeRenderer
extends JBLabel
implements TableCellRenderer {
    @NotNull
    private final BadgeItem badge;
    @NotNull
    private final Icon emptyIcon;

    public BadgeRenderer(@NotNull BadgeItem badge, @NotNull Icon emptyIcon) {
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        Intrinsics.checkNotNullParameter((Object)emptyIcon, (String)"emptyIcon");
        this.badge = badge;
        this.emptyIcon = emptyIcon;
        this.setHorizontalAlignment(0);
        this.setText(null);
        this.setBorder(IntTableCellRendererKt.createBorder(this.badge));
    }

    @NotNull
    public final BadgeItem getBadge() {
        return this.badge;
    }

    @NotNull
    public final Icon getEmptyIcon() {
        return this.emptyIcon;
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table2, @NotNull Object value2, boolean isSelected, boolean hasFocus, int row2, int column2) {
        Icon icon2;
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        boolean focused = isSelected && table2.hasFocus();
        Cell hoverCell = TreeTableImplKt.getHoverCell(table2);
        this.setBackground(UIUtil.getTreeBackground((boolean)isSelected, (boolean)focused));
        Cell cell = hoverCell;
        Icon hoverIcon = (cell != null ? cell.equalTo(row2, column2) : false) ? this.badge.getHoverIcon(value2) : null;
        Icon icon3 = hoverIcon;
        if (icon3 == null) {
            icon3 = icon2 = this.badge.getIcon(value2);
        }
        if (icon3 == null || (icon2 = this.white(icon2, focused)) == null) {
            icon2 = this.emptyIcon;
        }
        this.setIcon(icon2);
        this.setToolTipText(this.badge.getTooltipText(value2));
        return (Component)((Object)this);
    }

    private final Icon white(Icon $this$white, boolean focused) {
        return focused ? ColoredIconGenerator.generateWhiteIcon((Icon)$this$white) : $this$white;
    }
}

