/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.impl;

import com.android.tools.componenttree.impl.TreeImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.TreeExpandableItemsHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0006H\u0014J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/componenttree/impl/TreeImplExpandableItemsHandler;", "Lcom/intellij/ui/TreeExpandableItemsHandler;", "tree", "Lcom/android/tools/componenttree/impl/TreeImpl;", "(Lcom/android/tools/componenttree/impl/TreeImpl;)V", "value", "", "rowWithHiddenBadges", "setRowWithHiddenBadges", "(I)V", "getCellKeyForPoint", "point", "Ljava/awt/Point;", "(Ljava/awt/Point;)Ljava/lang/Integer;", "getCellRendererAndBounds", "Lcom/intellij/openapi/util/Pair;", "Ljava/awt/Component;", "Ljava/awt/Rectangle;", "row", "getExpandedItems", "", "intellij.android.layout-ui"})
public final class TreeImplExpandableItemsHandler
extends TreeExpandableItemsHandler {
    @NotNull
    private final TreeImpl tree;
    private int rowWithHiddenBadges;

    public TreeImplExpandableItemsHandler(@NotNull TreeImpl tree2) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        super((JTree)((Object)tree2));
        this.tree = tree2;
        this.rowWithHiddenBadges = -1;
    }

    private final void setRowWithHiddenBadges(int value2) {
        if (this.rowWithHiddenBadges != value2) {
            if (this.rowWithHiddenBadges != -1) {
                this.tree.repaintRow(this.rowWithHiddenBadges);
            }
            this.rowWithHiddenBadges = value2;
            this.tree.repaintRow(this.rowWithHiddenBadges);
        }
    }

    @Nullable
    protected Integer getCellKeyForPoint(@NotNull Point point) {
        int row2;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Integer n = point.x < this.tree.computeBadgePosition() ? super.getCellKeyForPoint(point) : null;
        int n2 = row2 = n != null ? n : -1;
        if (row2 < 0) {
            this.setRowWithHiddenBadges(-1);
        }
        return row2;
    }

    @Nullable
    protected Pair<Component, Rectangle> getCellRendererAndBounds(int row2) {
        Pair result2 = super.getCellRendererAndBounds(Integer.valueOf(row2));
        if (result2 == null) {
            this.setRowWithHiddenBadges(-1);
            return null;
        }
        Rectangle rect = (Rectangle)result2.second;
        rect.width -= this.tree.computeBadgesWidth();
        int badgePos = this.tree.computeBadgePosition();
        this.setRowWithHiddenBadges(rect.x + rect.width > badgePos ? row2 : -1);
        return result2;
    }

    @NotNull
    public Collection<Integer> getExpandedItems() {
        return this.rowWithHiddenBadges < 0 ? (Collection)CollectionsKt.emptyList() : (Collection)CollectionsKt.listOf((Object)this.rowWithHiddenBadges);
    }
}

