/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.impl;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.componenttree.api.BadgeItem;
import com.android.tools.componenttree.impl.TreeCellRendererImplKt;
import com.android.tools.componenttree.impl.TreeImpl;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/componenttree/impl/PanelRenderer;", "Ljavax/swing/JPanel;", "tree", "Lcom/android/tools/componenttree/impl/TreeImpl;", "badges", "", "Lcom/android/tools/componenttree/api/BadgeItem;", "(Lcom/android/tools/componenttree/impl/TreeImpl;Ljava/util/List;)V", "badgePanel", "currentDepth", "", "getCurrentDepth", "()I", "setCurrentDepth", "(I)V", "emptyIcon", "Ljavax/swing/Icon;", "kotlin.jvm.PlatformType", "updateBadges", "", "value", "", "row", "selected", "", "hasFocus", "PanelRendererLayout", "intellij.android.layout-ui"})
final class PanelRenderer
extends JPanel {
    @NotNull
    private final TreeImpl tree;
    @NotNull
    private final List<BadgeItem> badges;
    private final Icon emptyIcon;
    @NotNull
    private final JPanel badgePanel;
    private int currentDepth;

    public PanelRenderer(@NotNull TreeImpl tree2, @NotNull List<? extends BadgeItem> badges) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree2), (String)"tree");
        Intrinsics.checkNotNullParameter(badges, (String)"badges");
        this.tree = tree2;
        this.badges = badges;
        this.emptyIcon = EmptyIcon.ICON_16;
        this.badgePanel = new JPanel();
        this.currentDepth = 1;
        this.setLayout(new PanelRendererLayout());
        this.setBorder((Border)JBUI.Borders.empty());
        this.setBackground(UIUtil.TRANSPARENT_COLOR);
        if (!((Collection)this.badges).isEmpty()) {
            BoxLayout layout = new BoxLayout(this.badgePanel, 2);
            this.badgePanel.setLayout(layout);
            this.badgePanel.setBorder((Border)JBUI.Borders.empty());
            this.badgePanel.setBackground(UIUtil.TRANSPARENT_COLOR);
            Iterable $this$forEach$iv = this.badges;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BadgeItem it = (BadgeItem)element$iv;
                boolean bl = false;
                JBLabel label = new JBLabel();
                label.putClientProperty(TreeCellRendererImplKt.getBADGE_ITEM(), (Object)it);
                this.badgePanel.add((Component)label);
            }
            this.add((Component)this.badgePanel, "Center");
        }
    }

    public final int getCurrentDepth() {
        return this.currentDepth;
    }

    public final void setCurrentDepth(int n) {
        this.currentDepth = n;
    }

    public final void updateBadges(@Nullable Object value2, int row2, boolean selected, boolean hasFocus) {
        Iterator<BadgeItem> iterator2 = this.badges.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            String string;
            Icon badgeIcon;
            Icon icon2;
            Icon icon3;
            Icon icon4;
            Icon icon5;
            int i = n++;
            BadgeItem badge = iterator2.next();
            Component component2 = this.badgePanel.getComponent(i);
            Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBLabel");
            JBLabel label = (JBLabel)component2;
            if (value2 != null) {
                Object it;
                boolean bl = false;
                icon5 = badge.getIcon(it);
            } else {
                icon5 = icon4 = null;
            }
            if (icon4 != null) {
                Icon it;
                boolean bl = false;
                icon3 = selected && hasFocus ? ColoredIconGenerator.generateWhiteIcon((Icon)it) : it;
            } else {
                icon3 = null;
            }
            if ((icon2 = (badgeIcon = icon3)) == null) {
                icon2 = this.emptyIcon;
            }
            label.setIcon(icon2);
            JBLabel jBLabel = label;
            if (value2 != null) {
                Object it;
                JBLabel jBLabel2 = jBLabel;
                boolean bl = false;
                string = badge.getTooltipText(it);
                jBLabel = jBLabel2;
            } else {
                string = null;
            }
            jBLabel.setToolTipText(string);
        }
        this.badgePanel.setVisible(!this.tree.isRowCurrentlyExpanded(row2));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/componenttree/impl/PanelRenderer$PanelRendererLayout;", "Ljava/awt/BorderLayout;", "(Lcom/android/tools/componenttree/impl/PanelRenderer;)V", "layoutContainer", "", "target", "Ljava/awt/Container;", "intellij.android.layout-ui"})
    private final class PanelRendererLayout
    extends BorderLayout {
        @Override
        public void layoutContainer(@NotNull Container target2) {
            Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
            super.layoutContainer(target2);
            int width = ((PanelRenderer)PanelRenderer.this).badgePanel.getPreferredSize().width;
            PanelRenderer.this.badgePanel.setBounds(PanelRenderer.this.tree.computeMaxRenderWidth(PanelRenderer.this.getCurrentDepth()), PanelRenderer.this.badgePanel.getY(), width, PanelRenderer.this.badgePanel.getHeight());
        }
    }
}

