/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.componenttree.common;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.ColoredIconGenerator;
import com.android.tools.componenttree.api.ViewNodeType;
import com.android.tools.componenttree.common.ViewTreeCellRendererKt;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u0016*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0015\u0016B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/componenttree/common/ViewTreeCellRenderer;", "T", "Ljavax/swing/tree/TreeCellRenderer;", "type", "Lcom/android/tools/componenttree/api/ViewNodeType;", "(Lcom/android/tools/componenttree/api/ViewNodeType;)V", "renderer", "Lcom/android/tools/componenttree/common/ViewTreeCellRenderer$ColoredViewRenderer;", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "ColoredViewRenderer", "Companion", "intellij.android.layout-ui"})
public final class ViewTreeCellRenderer<T>
implements TreeCellRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewNodeType<T> type;
    @NotNull
    private final ColoredViewRenderer renderer;

    public ViewTreeCellRenderer(@NotNull ViewNodeType<T> type) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        this.type = type;
        this.renderer = new ColoredViewRenderer();
    }

    @Override
    @NotNull
    public Component getTreeCellRendererComponent(@NotNull JTree tree2, @NotNull Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.renderer.reset();
        Object t = this.type.getClazz().cast(value2);
        if (t == null) {
            return (Component)((Object)this.renderer);
        }
        Object node = t;
        this.renderer.setCurrentTree(tree2);
        this.renderer.setCurrentRow(row2);
        this.renderer.setCurrentDepth(ViewTreeCellRendererKt.computeDepth(tree2, value2));
        this.renderer.setSelectedValue(selected);
        this.renderer.setFocusedValue(hasFocus && selected);
        this.renderer.setId(ViewTreeCellRenderer.Companion.stripId(this.type.idOf(node)));
        this.renderer.setTagName(StringsKt.substringAfterLast$default((String)this.type.tagNameOf(node), (char)'.', null, (int)2, null));
        this.renderer.setTextValue(this.type.textValueOf(node));
        this.renderer.setTreeIcon(this.type.iconOf(node));
        this.renderer.setEnabledValue(this.type.isEnabled(node));
        this.renderer.setDeEmphasized(this.type.isDeEmphasized(node));
        this.renderer.generate();
        return (Component)((Object)this.renderer);
    }

    @VisibleForTesting
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010:\u001a\u00020;H\u0007J*\u0010<\u001a\u00020\u00192\b\u0010=\u001a\u0004\u0018\u00010%2\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u00042\u0006\u0010@\u001a\u00020\nH\u0002J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020B2\u0006\u0010>\u001a\u00020\bH\u0002J\u0006\u0010D\u001a\u00020;J\u0010\u0010D\u001a\u00020;2\u0006\u0010@\u001a\u00020\nH\u0002J\n\u0010E\u001a\u0004\u0018\u00010%H\u0002J\u0010\u0010F\u001a\u00020;2\u0006\u0010G\u001a\u00020HH\u0014J\u0006\u0010I\u001a\u00020;J\b\u0010J\u001a\u00020\u0019H\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u001c\u0010$\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001b\"\u0004\b,\u0010\u001dR\u0016\u0010-\u001a\n \u0005*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010'\"\u0004\b0\u0010)R\u001c\u00101\u001a\u0004\u0018\u00010%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010'\"\u0004\b3\u0010)R\u001c\u00104\u001a\u0004\u0018\u000105X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006K"}, d2={"Lcom/android/tools/componenttree/common/ViewTreeCellRenderer$ColoredViewRenderer;", "Lcom/intellij/ui/SimpleColoredRenderer;", "()V", "baseFontMetrics", "Ljava/awt/FontMetrics;", "kotlin.jvm.PlatformType", "boldFontMetrics", "boldStrikeout", "Lcom/intellij/ui/SimpleTextAttributes;", "currentDepth", "", "getCurrentDepth", "()I", "setCurrentDepth", "(I)V", "currentRow", "getCurrentRow", "setCurrentRow", "currentTree", "Ljavax/swing/JTree;", "getCurrentTree", "()Ljavax/swing/JTree;", "setCurrentTree", "(Ljavax/swing/JTree;)V", "deEmphasized", "", "getDeEmphasized", "()Z", "setDeEmphasized", "(Z)V", "enabledValue", "getEnabledValue", "setEnabledValue", "focusedValue", "getFocusedValue", "setFocusedValue", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "selectedValue", "getSelectedValue", "setSelectedValue", "strikeout", "tagName", "getTagName", "setTagName", "textValue", "getTextValue", "setTextValue", "treeIcon", "Ljavax/swing/Icon;", "getTreeIcon", "()Ljavax/swing/Icon;", "setTreeIcon", "(Ljavax/swing/Icon;)V", "adjustForPainting", "", "append", "text", "attributes", "metrics", "maxWidth", "deriveFont", "Ljava/awt/Font;", "font", "generate", "generateTooltip", "paintComponent", "g", "Ljava/awt/Graphics;", "reset", "shouldPaintBackground", "intellij.android.layout-ui"})
    public static final class ColoredViewRenderer
    extends SimpleColoredRenderer {
        @Nullable
        private JTree currentTree;
        private int currentDepth = 1;
        private int currentRow = -1;
        private boolean selectedValue;
        private boolean focusedValue;
        @Nullable
        private String id;
        @NotNull
        private String tagName = "";
        @Nullable
        private String textValue;
        @Nullable
        private Icon treeIcon;
        private boolean enabledValue = true;
        private boolean deEmphasized;
        private final FontMetrics baseFontMetrics = this.getFontMetrics(StartupUiUtil.getLabelFont());
        private final FontMetrics boldFontMetrics;
        private final SimpleTextAttributes strikeout;
        private final SimpleTextAttributes boldStrikeout;

        public ColoredViewRenderer() {
            Font font = StartupUiUtil.getLabelFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont()");
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_BOLD_ATTRIBUTES");
            this.boldFontMetrics = this.getFontMetrics(this.deriveFont(font, simpleTextAttributes));
            this.strikeout = SimpleTextAttributes.REGULAR_ATTRIBUTES.derive(4, null, null, null);
            this.boldStrikeout = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES.derive(4, null, null, null);
            this.setFont(StartupUiUtil.getLabelFont());
            this.setIpad((Insets)JBInsets.emptyInsets());
        }

        @Nullable
        public final JTree getCurrentTree() {
            return this.currentTree;
        }

        public final void setCurrentTree(@Nullable JTree jTree) {
            this.currentTree = jTree;
        }

        public final int getCurrentDepth() {
            return this.currentDepth;
        }

        public final void setCurrentDepth(int n) {
            this.currentDepth = n;
        }

        public final int getCurrentRow() {
            return this.currentRow;
        }

        public final void setCurrentRow(int n) {
            this.currentRow = n;
        }

        public final boolean getSelectedValue() {
            return this.selectedValue;
        }

        public final void setSelectedValue(boolean bl) {
            this.selectedValue = bl;
        }

        public final boolean getFocusedValue() {
            return this.focusedValue;
        }

        public final void setFocusedValue(boolean bl) {
            this.focusedValue = bl;
        }

        @Nullable
        public final String getId() {
            return this.id;
        }

        public final void setId(@Nullable String string) {
            this.id = string;
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        public final void setTagName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.tagName = string;
        }

        @Nullable
        public final String getTextValue() {
            return this.textValue;
        }

        public final void setTextValue(@Nullable String string) {
            this.textValue = string;
        }

        @Nullable
        public final Icon getTreeIcon() {
            return this.treeIcon;
        }

        public final void setTreeIcon(@Nullable Icon icon2) {
            this.treeIcon = icon2;
        }

        public final boolean getEnabledValue() {
            return this.enabledValue;
        }

        public final void setEnabledValue(boolean bl) {
            this.enabledValue = bl;
        }

        public final boolean getDeEmphasized() {
            return this.deEmphasized;
        }

        public final void setDeEmphasized(boolean bl) {
            this.deEmphasized = bl;
        }

        protected boolean shouldPaintBackground() {
            return false;
        }

        public final void reset() {
            this.clear();
            this.currentTree = null;
            this.currentRow = -1;
            this.id = null;
            this.tagName = "";
            this.textValue = null;
        }

        public final void generate() {
            this.generate(0);
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (this.currentTree != null) {
                this.adjustForPainting();
            }
            super.paintComponent(g);
        }

        private final void generate(int maxWidth) {
            block3: {
                CharSequence charSequence;
                this.clear();
                this.setIcon(this.treeIcon);
                this.setToolTipText(this.generateTooltip());
                SimpleTextAttributes attributes = null;
                SimpleTextAttributes simpleTextAttributes = attributes = !this.enabledValue ? this.boldStrikeout : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"attributes");
                FontMetrics fontMetrics = this.boldFontMetrics;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"boldFontMetrics");
                if (!this.append(this.id, simpleTextAttributes, fontMetrics, maxWidth)) {
                    return;
                }
                if (this.id == null || (charSequence = (CharSequence)this.textValue) == null || charSequence.length() == 0) {
                    Object tagText = this.id != null ? " - " + this.tagName : this.tagName;
                    SimpleTextAttributes simpleTextAttributes2 = attributes = !this.enabledValue ? this.strikeout : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"attributes");
                    FontMetrics fontMetrics2 = this.baseFontMetrics;
                    Intrinsics.checkNotNullExpressionValue((Object)fontMetrics2, (String)"baseFontMetrics");
                    if (!this.append((String)tagText, simpleTextAttributes2, fontMetrics2, maxWidth)) {
                        return;
                    }
                }
                SimpleTextAttributes simpleTextAttributes3 = attributes = !this.enabledValue ? this.strikeout : (this.selectedValue ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
                String string = this.textValue;
                if (string == null || (string = StringKt.nullize$default((String)string, (boolean)false, (int)1, null)) == null) break block3;
                String it = string;
                boolean bl = false;
                String string2 = " - \"" + it + "\"";
                SimpleTextAttributes simpleTextAttributes4 = attributes;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes4, (String)"attributes");
                FontMetrics fontMetrics3 = this.baseFontMetrics;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics3, (String)"baseFontMetrics");
                this.append(string2, simpleTextAttributes4, fontMetrics3, maxWidth);
            }
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        public final void adjustForPainting() {
            Icon icon2;
            int maxWidth;
            JTree jTree = this.currentTree;
            int n = maxWidth = jTree != null ? ViewTreeCellRendererKt.computeMaxRenderWidth(jTree, this.currentDepth) : 0;
            if (this.getPreferredSize().width > maxWidth) {
                JTree jTree2 = this.currentTree;
                if (!(jTree2 != null ? ViewTreeCellRendererKt.isRowCurrentlyExpanded(jTree2, this.currentRow) : false)) {
                    this.generate(maxWidth);
                }
            }
            this.setForeground(UIUtil.getTreeForeground((boolean)this.selectedValue, (boolean)this.focusedValue));
            this.setBackground(UIUtil.getTreeBackground((boolean)this.selectedValue, (boolean)this.focusedValue));
            ColoredViewRenderer coloredViewRenderer = this;
            Icon icon3 = this.treeIcon;
            if (icon3 != null) {
                void it;
                Icon icon4 = icon3;
                ColoredViewRenderer coloredViewRenderer2 = coloredViewRenderer;
                boolean bl = false;
                icon2 = this.focusedValue ? ColoredIconGenerator.generateWhiteIcon((Icon)it) : icon4;
                coloredViewRenderer = coloredViewRenderer2;
            } else {
                icon2 = null;
            }
            coloredViewRenderer.setIcon(icon2);
            if (this.deEmphasized || !this.enabledValue) {
                Color color = this.getForeground();
                Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground");
                this.setForeground(ColoredIconGenerator.INSTANCE.deEmphasize(color));
                Icon icon5 = this.getIcon();
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"icon");
                this.setIcon(ColoredIconGenerator.INSTANCE.generateDeEmphasizedIcon(icon5));
            }
            this.setTransparentIconBackground(true);
        }

        private final boolean append(String text2, SimpleTextAttributes attributes, FontMetrics metrics, int maxWidth) {
            String string = text2;
            if (string == null) {
                return true;
            }
            String actual = string;
            boolean unchanged = true;
            if (maxWidth > 0) {
                int availableSpace = maxWidth - this.getPreferredSize().width;
                if (metrics.stringWidth(actual) > availableSpace) {
                    actual = AdtUiUtils.shrinkToFit$default((String)text2, (FontMetrics)metrics, (float)availableSpace, null, (int)8, null);
                    unchanged = !Intrinsics.areEqual((Object)actual, (Object)text2);
                }
            }
            this.append(actual, attributes);
            return unchanged;
        }

        private final String generateTooltip() {
            CharSequence charSequence = this.id;
            return charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)this.textValue) == null || charSequence.length() == 0 || ((CharSequence)this.tagName).length() == 0 ? null : StringsKt.trimIndent((String)("\n        <html>\n          " + this.tagName + "<br/>\n          " + this.id + ": \"" + this.textValue + "\"\n        </html>\n        "));
        }

        private final Font deriveFont(Font font, SimpleTextAttributes attributes) {
            if (font.getStyle() == attributes.getFontStyle() && !attributes.isSmaller()) {
                return font;
            }
            float size = attributes.isSmaller() ? UIUtil.getFontSize((UIUtil.FontSize)UIUtil.FontSize.SMALL) : font.getSize2D();
            Font font2 = font.deriveFont(attributes.getFontStyle(), size);
            Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"font.deriveFont(attributes.fontStyle, size)");
            return font2;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J'\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0001\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u0002H\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\f"}, d2={"Lcom/android/tools/componenttree/common/ViewTreeCellRenderer$Companion;", "", "()V", "computeSearchString", "", "T", "type", "Lcom/android/tools/componenttree/api/ViewNodeType;", "node", "(Lcom/android/tools/componenttree/api/ViewNodeType;Ljava/lang/Object;)Ljava/lang/String;", "stripId", "id", "intellij.android.layout-ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> String computeSearchString(@NotNull ViewNodeType<T> type, T node) {
            Object str;
            block3: {
                Intrinsics.checkNotNullParameter(type, (String)"type");
                String id2 = type.idOf(node);
                String textValue = type.textValueOf(node);
                str = null;
                Object object = this.stripId(id2);
                if (object == null) {
                    object = str = "";
                }
                if (id2 == null || textValue == null) {
                    if (id2 != null) {
                        str = str + " - ";
                    }
                    str = str + StringsKt.substringAfterLast$default((String)type.tagNameOf(node), (char)'.', null, (int)2, null);
                }
                String string = textValue;
                if (string == null) break block3;
                String it = string;
                boolean bl = false;
                str = str + " - \"" + it + "\"";
            }
            return str;
        }

        private final String stripId(String id2) {
            String string = id2;
            return string != null ? StringsKt.substringAfter$default((String)string, (char)'/', null, (int)2, null) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

