/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.analytics;

import com.android.tools.analytics.HighlightingStats;
import com.android.tools.analytics.HistogramUtil;
import com.android.tools.analytics.UsageTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.EditorFileType;
import com.google.wireless.android.sdk.stats.EditorHighlightingStats;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/analytics/HighlightingStats;", "Lcom/intellij/openapi/Disposable;", "()V", "latencyRecorders", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/google/wireless/android/sdk/stats/EditorFileType;", "Lorg/HdrHistogram/Recorder;", "convertFileType", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "dispose", "", "recordHighlightingLatency", "document", "Lcom/intellij/openapi/editor/Document;", "latencyMs", "", "reportHighlightingStats", "Companion", "analytics"})
public final class HighlightingStats
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<EditorFileType, Recorder> latencyRecorders;
    private static final int MAX_LATENCY_MS = 600000;

    public HighlightingStats() {
        JobScheduler.getScheduler().scheduleWithFixedDelay(new Runnable(){

            @Override
            public final void run() {
                HighlightingStats.this.reportHighlightingStats();
            }
        }, 1L, 1L, TimeUnit.HOURS);
        this.latencyRecorders = new ConcurrentHashMap();
    }

    public void dispose() {
        this.reportHighlightingStats();
    }

    public final void recordHighlightingLatency(@NotNull Document document2, long latencyMs) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        if (latencyMs < 0L || latencyMs > 600000L) {
            return;
        }
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file2 = virtualFile;
        EditorFileType fileType = this.convertFileType(file2);
        Recorder recorder2 = this.latencyRecorders.computeIfAbsent(fileType, recordHighlightingLatency.recorder.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)recorder2, (String)"latencyRecorders.compute\u2026fileType) { Recorder(1) }");
        Recorder recorder3 = recorder2;
        recorder3.recordValue(latencyMs);
    }

    public final void reportHighlightingStats() {
        AndroidStudioEvent.Builder builder2;
        EditorHighlightingStats.Builder allStats = EditorHighlightingStats.newBuilder();
        for (Map.Entry builder22 : ((Map)this.latencyRecorders).entrySet()) {
            EditorHighlightingStats.Stats.Builder builder3;
            EditorFileType fileType = (EditorFileType)builder22.getKey();
            Recorder recorder2 = (Recorder)builder22.getValue();
            Histogram histogram2 = recorder2.getIntervalHistogram();
            if (histogram2.getTotalCount() == 0L) continue;
            EditorHighlightingStats.Stats.Builder it = builder3 = EditorHighlightingStats.Stats.newBuilder();
            boolean bl = false;
            it.setFileType(fileType);
            Intrinsics.checkNotNullExpressionValue((Object)histogram2, (String)"histogram");
            it.setHistogram(HistogramUtil.toProto(histogram2));
            EditorHighlightingStats.Stats.Builder record = builder3;
            allStats.addByFileType(record.build());
        }
        if (allStats.getByFileTypeCount() == 0) {
            return;
        }
        AndroidStudioEvent.Builder $this$reportHighlightingStats_u24lambda_u2d1 = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $this$reportHighlightingStats_u24lambda_u2d1.setKind(AndroidStudioEvent.EventKind.EDITOR_HIGHLIGHTING_STATS);
        $this$reportHighlightingStats_u24lambda_u2d1.setEditorHighlightingStats(allStats.build());
        AndroidStudioEvent.Builder builder4 = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"newBuilder().apply {\n   \u2026 allStats.build()\n      }");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    private final EditorFileType convertFileType(VirtualFile file2) {
        EditorFileType editorFileType;
        switch (file2.getFileType().getName()) {
            case "JAVA": {
                editorFileType = EditorFileType.JAVA;
                break;
            }
            case "Kotlin": {
                if (Intrinsics.areEqual((Object)file2.getExtension(), (Object)"kts")) {
                    editorFileType = EditorFileType.KOTLIN_SCRIPT;
                    break;
                }
                editorFileType = EditorFileType.KOTLIN;
                break;
            }
            case "XML": {
                editorFileType = EditorFileType.XML;
                break;
            }
            case "Groovy": {
                editorFileType = EditorFileType.GROOVY;
                break;
            }
            case "Properties": {
                editorFileType = EditorFileType.PROPERTIES;
                break;
            }
            case "JSON": {
                editorFileType = EditorFileType.JSON;
                break;
            }
            case "ObjectiveC": {
                editorFileType = EditorFileType.NATIVE;
                break;
            }
            default: {
                editorFileType = EditorFileType.UNKNOWN;
            }
        }
        return editorFileType;
    }

    @JvmStatic
    @NotNull
    public static final HighlightingStats getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/analytics/HighlightingStats$Companion;", "", "()V", "MAX_LATENCY_MS", "", "getInstance", "Lcom/android/tools/analytics/HighlightingStats;", "analytics"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final HighlightingStats getInstance() {
            Object object = ApplicationManager.getApplication().getService(HighlightingStats.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026ightingStats::class.java)");
            return (HighlightingStats)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

