/*
 * Decompiled with CFR 0.152.
 */
package com.android.flags;

import com.android.flags.FlagGroup;
import com.android.flags.Flags;
import java.util.Locale;

public final class Flag<T> {
    private static final ValueConverter<Boolean> BOOL_CONVERTER = new ValueConverter<Boolean>(){

        @Override
        public String serialize(Boolean value2) {
            return value2.toString();
        }

        @Override
        public Boolean deserialize(String strValue) {
            return Boolean.parseBoolean(strValue);
        }
    };
    private static final ValueConverter<Integer> INT_CONVERTER = new ValueConverter<Integer>(){

        @Override
        public String serialize(Integer value2) {
            return Integer.toString(value2);
        }

        @Override
        public Integer deserialize(String strValue) {
            return Integer.valueOf(strValue);
        }
    };
    private static final ValueConverter<String> PASSTHRU_CONVERTER = new ValueConverter<String>(){

        @Override
        public String serialize(String value2) {
            return value2;
        }

        @Override
        public String deserialize(String strValue) {
            return strValue;
        }
    };
    private final FlagGroup group;
    private final String id;
    private final String displayName;
    private final String description;
    private final ValueConverter<T> valueConverter;
    private final String defaultValue;
    private final T originalDefaultValue;

    private static <T extends Enum<T>> ValueConverter<T> enumConverter(final Class<T> enumClass) {
        return new ValueConverter<T>(){

            @Override
            public String serialize(T value2) {
                return ((Enum)value2).name();
            }

            @Override
            public T deserialize(String strValue) {
                return Enum.valueOf(enumClass, strValue.toUpperCase(Locale.US));
            }
        };
    }

    private Flag(FlagGroup group2, String name, String displayName2, String description2, T defaultValue, ValueConverter<T> valueConverter) {
        this.group = group2;
        this.id = group2.getName() + "." + name;
        this.displayName = displayName2;
        this.description = description2;
        this.valueConverter = valueConverter;
        this.defaultValue = valueConverter.serialize(defaultValue);
        this.originalDefaultValue = defaultValue;
        group2.getFlags().register(this);
    }

    public void validate() {
        this.group.validate();
        Flag.verifyDefaultValue(this.originalDefaultValue, this.defaultValue, this.valueConverter);
        Flag.verifyFlagIdFormat(this.getId());
        Flag.verifyDisplayTextFormat(this.displayName);
        Flag.verifyDisplayTextFormat(this.description);
    }

    public static void verifyFlagIdFormat(String id2) {
        if (!id2.matches("[a-z][a-z0-9]*(\\.[a-z0-9]+)*")) {
            throw new IllegalArgumentException("Invalid id: " + id2);
        }
    }

    public static void verifyDisplayTextFormat(String name) {
        if (name.isEmpty() || name.charAt(0) == ' ' || name.charAt(name.length() - 1) == ' ') {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }

    private static <T> void verifyDefaultValue(T defaultValue, String stringDefaultValue, ValueConverter<T> converter) {
        T deserialized;
        try {
            deserialized = converter.deserialize(stringDefaultValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Default value cannot be deserialized.");
        }
        if (!deserialized.equals(defaultValue)) {
            throw new IllegalArgumentException("Default value cannot be deserialized.");
        }
    }

    public String getId() {
        return this.id;
    }

    public static Flag<Boolean> create(FlagGroup group2, String name, String displayName2, String description2, boolean defaultValue) {
        return new Flag<Boolean>(group2, name, displayName2, description2, defaultValue, BOOL_CONVERTER);
    }

    public static Flag<Integer> create(FlagGroup group2, String name, String displayName2, String description2, int defaultValue) {
        return new Flag<Integer>(group2, name, displayName2, description2, defaultValue, INT_CONVERTER);
    }

    public static Flag<String> create(FlagGroup group2, String name, String displayName2, String description2, String defaultValue) {
        return new Flag<String>(group2, name, displayName2, description2, defaultValue, PASSTHRU_CONVERTER);
    }

    public static <T extends Enum<T>> Flag<T> create(FlagGroup group2, String name, String displayName2, String description2, T defaultValue) {
        return new Flag<T>(group2, name, displayName2, description2, defaultValue, Flag.enumConverter(defaultValue.getClass()));
    }

    public FlagGroup getGroup() {
        return this.group;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public T get() {
        Flags flags = this.getGroup().getFlags();
        String strValue = flags.getOverriddenValue(this);
        if (strValue == null) {
            strValue = this.defaultValue;
        }
        try {
            return this.valueConverter.deserialize(strValue);
        }
        catch (Exception e) {
            return this.valueConverter.deserialize(this.defaultValue);
        }
    }

    public void override(T overrideValue) {
        this.getGroup().getFlags().getOverrides().put(this, this.valueConverter.serialize(overrideValue));
    }

    public void clearOverride() {
        this.getGroup().getFlags().getOverrides().remove(this);
    }

    public boolean isOverridden() {
        return this.getGroup().getFlags().getOverrides().get(this) != null;
    }

    private static interface ValueConverter<T> {
        public String serialize(T var1);

        public T deserialize(String var1);
    }
}

