/*
 * Decompiled with CFR 0.152.
 */
package com.android.emulator;

import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.idea.protobuf.UnsafeByteOperations;
import com.android.tools.idea.util.StudioPathManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.system.CpuArch;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class ImageConverter {
    private static Field bytesField;
    private static Field offsetField;

    public static void unpackRgb888(@NotNull ByteString imageBytes, int @NotNull [] pixels) {
        int length = imageBytes.size();
        if (length == 0) {
            return;
        }
        if (bytesField != null) {
            try {
                byte[] bytes2 = (byte[])bytesField.get(imageBytes);
                int offset = offsetField.getInt(imageBytes);
                ImageConverter.unpackRgb888(bytes2, offset, length, pixels);
                return;
            }
            catch (IllegalAccessException e) {
                ImageConverter.logger().error("Unable to use reflection, will use slow path", (Throwable)e);
                bytesField = null;
                offsetField = null;
            }
        }
        ImageConverter.unpackRgb888Slow(imageBytes, pixels);
    }

    public static void unpackRgb888Slow(@NotNull ByteString imageBytes, int @NotNull [] pixels) {
        int length = imageBytes.size();
        if (length % 3 != 0) {
            throw new IllegalArgumentException("Number of bytes (" + length + ") is not a multiple of 3");
        }
        int i = 0;
        int j = 0;
        while (i < length) {
            int red = imageBytes.byteAt(i++) & 0xFF;
            int green = imageBytes.byteAt(i++) & 0xFF;
            int blue = imageBytes.byteAt(i++) & 0xFF;
            pixels[j++] = 0xFF000000 | red << 16 | green << 8 | blue;
        }
    }

    @VisibleForTesting
    static synchronized void loadNativeLibrary() {
        Path libFile = ImageConverter.getLibLocation();
        System.load(libFile.toString());
    }

    @NotNull
    private static Path getLibLocation() {
        String libName = ImageConverter.getLibName();
        Path homePath = Paths.get(PathManager.getHomePath(), new String[0]);
        Path libFile = homePath.resolve("plugins/android/resources/native").resolve(libName);
        if (Files.exists(libFile, new LinkOption[0])) {
            return libFile;
        }
        if (StudioPathManager.isRunningFromSources()) {
            libFile = StudioPathManager.resolvePathFromSourcesRoot((String)"tools/adt/idea/streaming/native").resolve(ImageConverter.getPlatformName()).resolve(libName);
            if (Files.exists(libFile, new LinkOption[0])) {
                return libFile;
            }
            throw new UnsatisfiedLinkError("Unable to find " + libFile);
        }
        throw new UnsatisfiedLinkError("Unable to find " + libName + ". Possibly corrupted Studio installation");
    }

    @NotNull
    private static String getLibName() {
        return System.mapLibraryName("image_converter");
    }

    @NotNull
    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return CpuArch.isArm64() ? "mac_arm" : "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        return "";
    }

    private static void initByteStringFields() {
        Class<?> byteStringClass = UnsafeByteOperations.unsafeWrap((byte[])new byte[4], (int)1, (int)2).getClass();
        try {
            bytesField = byteStringClass.getSuperclass().getDeclaredField("bytes");
            bytesField.setAccessible(true);
            offsetField = byteStringClass.getDeclaredField("bytesOffset");
            offsetField.setAccessible(true);
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            bytesField = null;
            offsetField = null;
            throw new RuntimeException("Unable to access fields of " + byteStringClass.getName(), e);
        }
    }

    @NotNull
    private static Logger logger() {
        return Logger.getInstance(ImageConverter.class);
    }

    private static native void initNative();

    private static native void unpackRgb888(byte @NotNull [] var0, int var1, int var2, int @NotNull [] var3);

    private ImageConverter() {
    }

    static {
        try {
            ImageConverter.loadNativeLibrary();
            ImageConverter.initNative();
            ImageConverter.initByteStringFields();
        }
        catch (Throwable e) {
            ImageConverter.logger().error("Native image converter library is not available", e);
        }
    }
}

