/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view.details;

import com.android.build.attribution.analyzers.AnalyzerNotRun;
import com.android.build.attribution.analyzers.JetifierCanBeRemoved;
import com.android.build.attribution.analyzers.JetifierNotUsed;
import com.android.build.attribution.analyzers.JetifierRequiredForLibraries;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.JetifierUsageProjectStatus;
import com.android.build.attribution.analyzers.JetifierUsedCheckRequired;
import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.build.attribution.ui.view.details.JetifierWarningDetailsKt;
import com.android.buildanalyzer.common.FullDependencyPath;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.PlatformIcons;
import com.intellij.util.text.JBDateFormat;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004%&'(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\b\u0010 \u001a\u00020\u001eH\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\f\u0010#\u001a\u00020$*\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView;", "", "data", "Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;Lcom/android/build/attribution/ui/view/ViewActionHandlers;Lcom/intellij/openapi/Disposable;)V", "declaredDependenciesList", "Lcom/intellij/ui/components/JBList;", "Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor;", "kotlin.jvm.PlatformType", "dependencyStructureTree", "Lcom/intellij/ui/treeStructure/Tree;", "headerTextArea", "Ljavax/swing/JEditorPane;", "outdatedResultsBanner", "Ljavax/swing/JPanel;", "pagePanel", "getPagePanel", "()Ljavax/swing/JPanel;", "removeJetifierButton", "Ljavax/swing/JButton;", "resultPanel", "runCheckButton", "tableHeader", "Lcom/intellij/ui/SimpleColoredComponent;", "treeHeader", "installResultsTableActions", "", "resultsTable", "onDeclaredDependencySelection", "refreshUi", "setupRefresh", "isPreviouslySavedResultReused", "", "DependenciesStructureTreeRenderer", "DependencyDescriptor", "DependencyTreeNode", "DirectDependencyDescriptor", "intellij.android.build-attribution"})
public final class JetifierWarningDetailsView {
    @NotNull
    private final JetifierUsageAnalyzerResult data;
    @NotNull
    private final ViewActionHandlers actionHandlers;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final JPanel pagePanel;
    @NotNull
    private final JEditorPane headerTextArea;
    @NotNull
    private final JButton runCheckButton;
    @NotNull
    private final JButton removeJetifierButton;
    @NotNull
    private final JBList<DirectDependencyDescriptor> declaredDependenciesList;
    @NotNull
    private final SimpleColoredComponent tableHeader;
    @NotNull
    private final JPanel outdatedResultsBanner;
    @NotNull
    private final SimpleColoredComponent treeHeader;
    @NotNull
    private final Tree dependencyStructureTree;
    @NotNull
    private final JPanel resultPanel;

    public JetifierWarningDetailsView(@NotNull JetifierUsageAnalyzerResult data2, @NotNull ViewActionHandlers actionHandlers, @NotNull Disposable disposable2) {
        Serializable serializable;
        JPanel $this$resultPanel_u24lambda_u2d10;
        JComponent $this$dependencyStructureTree_u24lambda_u2d7;
        JComponent $this$treeHeader_u24lambda_u2d6;
        JComponent $this$outdatedResultsBanner_u24lambda_u2d5;
        JComponent $this$tableHeader_u24lambda_u2d4;
        JButton $this$declaredDependenciesList_u24lambda_u2d3;
        JButton $this$removeJetifierButton_u24lambda_u2d2;
        JButton $this$runCheckButton_u24lambda_u2d1;
        JComponent jComponent;
        String string;
        String string2;
        JButton $this$headerTextArea_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        this.data = data2;
        this.actionHandlers = actionHandlers;
        this.disposable = disposable2;
        this.pagePanel = new JPanel();
        JetifierWarningDetailsView jetifierWarningDetailsView = this;
        Object object = this;
        boolean bl = false;
        Object linksHandler = new HtmlLinksHandler(((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u2d0)).actionHandlers);
        String learnMoreLink = ((HtmlLinksHandler)linksHandler).externalLink("Learn more", BuildAnalyzerBrowserLinks.JETIIFER_MIGRATE);
        JetifierUsageProjectStatus jetifierUsageProjectStatus = ((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u2d0)).data.getProjectStatus();
        if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierUsedCheckRequired.INSTANCE)) {
            string2 = "Check if you need Jetifier in your project";
        } else if (jetifierUsageProjectStatus instanceof JetifierRequiredForLibraries) {
            string2 = "Some project dependencies require Jetifier";
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierCanBeRemoved.INSTANCE)) {
            string2 = "Jetifier flag can be removed";
        } else {
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)JetifierNotUsed.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus, (Object)AnalyzerNotRun.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        String headerStatus = string2;
        JetifierUsageProjectStatus jetifierUsageProjectStatus2 = ((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u2d0)).data.getProjectStatus();
        if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)JetifierUsedCheckRequired.INSTANCE)) {
            string = "Removing Jetifier could reduce project build time.\nTo disable Jetifier your project should have no dependencies on legacy support libraries.\nRun check to see if you have any of such dependencies in your project.";
        } else if (jetifierUsageProjectStatus2 instanceof JetifierRequiredForLibraries) {
            int size = ((JetifierRequiredForLibraries)((JetifierWarningDetailsView)((Object)$this$headerTextArea_u24lambda_u2d0)).data.getProjectStatus()).getCheckJetifierResult().getDependenciesDependingOnSupportLibs().size();
            string = size == 1 ? "This check found <b>1 declared dependency</b> that requires legacy support libraries.\nRemoving Jetifier could reduce project build time.\nTo disable Jetifier you need to upgrade it to a version that does not require legacy support libraries or find an alternative.\nRun this check again to include recent changes to project files." : StringsKt.trimIndent((String)("\n            This check found <b>" + size + " declared dependencies</b> that require legacy support libraries.\n            Removing Jetifier could reduce project build time.\n            To disable Jetifier you need to upgrade them to versions that do not require legacy support libraries or find alternatives.\n            Run this check again to include recent changes to project files.\n            "));
        } else if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)JetifierCanBeRemoved.INSTANCE)) {
            string = "This check found <b>0 declared dependencies</b> that require Jetifier in your project.\nYou can safely remove the 'android.enableJetifier' flag.";
        } else {
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)JetifierNotUsed.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            if (Intrinsics.areEqual((Object)jetifierUsageProjectStatus2, (Object)AnalyzerNotRun.INSTANCE)) {
                throw new IllegalStateException("Warning should not be shown in this state.".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        String callToActionLine = string;
        String contentHtml = StringsKt.trimIndent((String)("\n          <b>" + headerStatus + "</b><br/>\n          <br/>\n          Your project\u2019s gradle.properties file includes 'android.enableJetifier=true'.\n          This flag is needed to enable AndroidX for libraries that don\u2019t support it natively.\n          " + learnMoreLink + ".<br/>\n          <br/>\n          " + callToActionLine + "<br/>\n        "));
        ((JetifierWarningDetailsView)object).headerTextArea = BuildAttributionUIUtilKt.htmlTextLabelWithLinesWrap(contentHtml, (HtmlLinksHandler)linksHandler);
        $this$headerTextArea_u24lambda_u2d0 = jComponent = new JButton("Run Jetifier check");
        object = this;
        boolean bl2 = false;
        $this$runCheckButton_u24lambda_u2d1.setName("run-check-button");
        $this$runCheckButton_u24lambda_u2d1.addActionListener(new ActionListener(this){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void actionPerformed(ActionEvent it) {
                JetifierWarningDetailsView.access$getActionHandlers$p(this.this$0).runCheckJetifierTask();
            }
        });
        $this$runCheckButton_u24lambda_u2d1.putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, !(this.data.getProjectStatus() instanceof JetifierCanBeRemoved));
        ((JetifierWarningDetailsView)object).runCheckButton = jComponent;
        $this$runCheckButton_u24lambda_u2d1 = jComponent = new JButton("Disable Jetifier");
        object = this;
        boolean bl3 = false;
        $this$removeJetifierButton_u24lambda_u2d2.setName("disable-jetifier-button");
        $this$removeJetifierButton_u24lambda_u2d2.setToolTipText("Remove the 'android.enableJetifier' flag from gradle.properties");
        $this$removeJetifierButton_u24lambda_u2d2.addActionListener(new ActionListener(this, $this$removeJetifierButton_u24lambda_u2d2){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            final /* synthetic */ JButton $this_apply;
            {
                this.this$0 = $receiver;
                this.$this_apply = $receiver2;
            }

            public final void actionPerformed(ActionEvent it) {
                JetifierWarningDetailsView.access$getActionHandlers$p(this.this$0).turnJetifierOffInProperties(new Supplier(this.$this_apply){
                    final /* synthetic */ JButton $this_apply;
                    {
                        this.$this_apply = $receiver;
                    }

                    @NotNull
                    public final RelativePoint get() {
                        return RelativePoint.getSouthOf((JComponent)this.$this_apply);
                    }
                });
            }
        });
        $this$removeJetifierButton_u24lambda_u2d2.putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, this.data.getProjectStatus() instanceof JetifierCanBeRemoved);
        $this$removeJetifierButton_u24lambda_u2d2.setVisible(this.data.getProjectStatus() instanceof JetifierCanBeRemoved);
        $this$removeJetifierButton_u24lambda_u2d2.setPreferredSize(this.runCheckButton.getPreferredSize());
        $this$removeJetifierButton_u24lambda_u2d2.setMaximumSize(this.runCheckButton.getMaximumSize());
        $this$removeJetifierButton_u24lambda_u2d2.setMinimumSize(this.runCheckButton.getMinimumSize());
        ((JetifierWarningDetailsView)object).removeJetifierButton = jComponent;
        $this$removeJetifierButton_u24lambda_u2d2 = jComponent = new JBList((Collection)JetifierWarningDetailsKt.access$createDeclaredDependenciesList(this.data));
        object = this;
        boolean bl4 = false;
        $this$declaredDependenciesList_u24lambda_u2d3.setName("declared-dependencies-list");
        $this$declaredDependenciesList_u24lambda_u2d3.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<DirectDependencyDescriptor>(this){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            protected void customizeCellRenderer(@NotNull JList<? extends DirectDependencyDescriptor> list2, @Nullable DirectDependencyDescriptor value2, int index2, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                if (value2 == null) {
                    return;
                }
                this.setIcon(PlatformIcons.LIBRARY_ICON);
                this.setIconOpaque(true);
                this.setFocusBorderAroundIcon(true);
                this.setBackground(UIUtil.getListBackground((boolean)selected, (boolean)hasFocus));
                this.mySelectionForeground = UIUtil.getListForeground((boolean)selected, (boolean)hasFocus);
                if (JetifierWarningDetailsView.access$getData$p(this.this$0).getProjectStatus() instanceof JetifierRequiredForLibraries) {
                    this.setToolTipText(JetifierWarningDetailsKt.access$treeToolTip(value2.isSupportLibrary(), true));
                }
                this.append(value2.getFullName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        });
        $this$declaredDependenciesList_u24lambda_u2d3.setBorder((Border)JBUI.Borders.empty());
        $this$declaredDependenciesList_u24lambda_u2d3.setSelectionMode(0);
        $this$declaredDependenciesList_u24lambda_u2d3.getSelectionModel().addListSelectionListener(new ListSelectionListener(this){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void valueChanged(ListSelectionEvent it) {
                JetifierWarningDetailsView.access$onDeclaredDependencySelection(this.this$0);
            }
        });
        $this$declaredDependenciesList_u24lambda_u2d3.getEmptyText().clear();
        linksHandler = this.data.getProjectStatus();
        if (linksHandler instanceof JetifierUsedCheckRequired) {
            $this$declaredDependenciesList_u24lambda_u2d3.getEmptyText().appendText("Run check", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(this){
                final /* synthetic */ JetifierWarningDetailsView this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void actionPerformed(ActionEvent it) {
                    JetifierWarningDetailsView.access$getActionHandlers$p(this.this$0).runCheckJetifierTask();
                }
            });
            $this$declaredDependenciesList_u24lambda_u2d3.getEmptyText().appendText(" to see if you need Jetifier in your project.");
        } else if (linksHandler instanceof JetifierCanBeRemoved) {
            $this$declaredDependenciesList_u24lambda_u2d3.getEmptyText().appendText("No dependencies require jetifier, ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            $this$declaredDependenciesList_u24lambda_u2d3.getEmptyText().appendText("remove 'android.enableJetifier' flag.", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener((JBList<DirectDependencyDescriptor>)$this$declaredDependenciesList_u24lambda_u2d3, this){
                final /* synthetic */ JBList<DirectDependencyDescriptor> $this_apply;
                final /* synthetic */ JetifierWarningDetailsView this$0;
                {
                    this.$this_apply = $receiver;
                    this.this$0 = $receiver2;
                }

                public final void actionPerformed(ActionEvent it) {
                    Point point = this.$this_apply.getEmptyText().getPointBelow();
                    JBList<DirectDependencyDescriptor> jBList = this.$this_apply;
                    Point $this$actionPerformed_u24lambda_u2d0 = point;
                    boolean bl = false;
                    $this$actionPerformed_u24lambda_u2d0.translate(jBList.getEmptyText().getPreferredSize().width / 2, 0);
                    Point pointBelowCenter = point;
                    JetifierWarningDetailsView.access$getActionHandlers$p(this.this$0).turnJetifierOffInProperties(new Supplier(this.$this_apply, pointBelowCenter){
                        final /* synthetic */ JBList<DirectDependencyDescriptor> $this_apply;
                        final /* synthetic */ Point $pointBelowCenter;
                        {
                            this.$this_apply = $receiver;
                            this.$pointBelowCenter = $pointBelowCenter;
                        }

                        @NotNull
                        public final RelativePoint get() {
                            return new RelativePoint((Component)this.$this_apply, this.$pointBelowCenter);
                        }
                    });
                }
            });
        }
        this.installResultsTableActions((JBList<DirectDependencyDescriptor>)$this$declaredDependenciesList_u24lambda_u2d3);
        new ListSpeedSearch((JList)((Object)$this$declaredDependenciesList_u24lambda_u2d3));
        ((JetifierWarningDetailsView)object).declaredDependenciesList = jComponent;
        $this$declaredDependenciesList_u24lambda_u2d3 = jComponent = new SimpleColoredComponent();
        object = this;
        boolean bl5 = false;
        $this$tableHeader_u24lambda_u2d4.setName("declared-dependencies-header");
        $this$tableHeader_u24lambda_u2d4.setIpad((Insets)JBUI.insetsLeft((int)8));
        $this$tableHeader_u24lambda_u2d4.setBorder(JBUI.Borders.customLineBottom((Color)JBUI.CurrentTheme.ToolWindow.headerBorderBackground()));
        $this$tableHeader_u24lambda_u2d4.setBackground(UIUtil.getTreeBackground());
        ((JetifierWarningDetailsView)object).tableHeader = jComponent;
        $this$tableHeader_u24lambda_u2d4 = jComponent = new JPanel();
        object = this;
        boolean bl6 = false;
        $this$outdatedResultsBanner_u24lambda_u2d5.setName("outdated-results-banner");
        $this$outdatedResultsBanner_u24lambda_u2d5.setVisible(this.isPreviouslySavedResultReused(this.data));
        ((Container)$this$outdatedResultsBanner_u24lambda_u2d5).setLayout((LayoutManager)new HorizontalLayout(10));
        $this$outdatedResultsBanner_u24lambda_u2d5.setBorder((Border)JBUI.Borders.empty((int)4, (int)8));
        $this$outdatedResultsBanner_u24lambda_u2d5.add((Component)new JLabel("Showing previously saved results."), "LEFT");
        $this$outdatedResultsBanner_u24lambda_u2d5.add((Component)new ActionLink("Re-run check.", (Function1)new Function1<ActionEvent, Unit>(this){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                JetifierWarningDetailsView.access$getActionHandlers$p(this.this$0).runCheckJetifierTask();
            }
        }), "RIGHT");
        $this$outdatedResultsBanner_u24lambda_u2d5.setBackground(JBUI.CurrentTheme.NotificationWarning.backgroundColor());
        $this$outdatedResultsBanner_u24lambda_u2d5.setForeground(JBUI.CurrentTheme.NotificationWarning.foregroundColor());
        ((JetifierWarningDetailsView)object).outdatedResultsBanner = jComponent;
        $this$outdatedResultsBanner_u24lambda_u2d5 = jComponent = new SimpleColoredComponent();
        object = this;
        boolean bl7 = false;
        $this$treeHeader_u24lambda_u2d6.setName("dependency-structure-header");
        $this$treeHeader_u24lambda_u2d6.setIpad((Insets)JBUI.insetsLeft((int)8));
        $this$treeHeader_u24lambda_u2d6.append("Dependency Structure");
        $this$treeHeader_u24lambda_u2d6.setBorder(JBUI.Borders.customLineBottom((Color)JBUI.CurrentTheme.ToolWindow.headerBorderBackground()));
        $this$treeHeader_u24lambda_u2d6.setBackground(UIUtil.getTreeBackground());
        ((JetifierWarningDetailsView)object).treeHeader = jComponent;
        $this$treeHeader_u24lambda_u2d6 = jComponent = new Tree();
        object = this;
        boolean bl8 = false;
        $this$dependencyStructureTree_u24lambda_u2d7.setRootVisible(false);
        $this$dependencyStructureTree_u24lambda_u2d7.setCellRenderer((TreeCellRenderer)((Object)new DependenciesStructureTreeRenderer()));
        $this$dependencyStructureTree_u24lambda_u2d7.setModel(new DefaultTreeModel(null));
        ((JetifierWarningDetailsView)object).dependencyStructureTree = jComponent;
        $this$dependencyStructureTree_u24lambda_u2d7 = jComponent = new JPanel();
        object = this;
        boolean bl9 = false;
        $this$resultPanel_u24lambda_u2d10.setName("jetifier-libraries-list");
        $this$resultPanel_u24lambda_u2d10.setLayout(new BorderLayout());
        Object $this$resultPanel_u24lambda_u2d10_u24lambda_u2d8 = linksHandler = ScrollPaneFactory.createScrollPane();
        boolean bl10 = false;
        ((JScrollPane)$this$resultPanel_u24lambda_u2d10_u24lambda_u2d8).setColumnHeaderView((Component)this.tableHeader);
        BorderLayoutPanel listWithBanner = new BorderLayoutPanel();
        ((JScrollPane)$this$resultPanel_u24lambda_u2d10_u24lambda_u2d8).setViewportView((Component)listWithBanner.addToTop((Component)this.outdatedResultsBanner).addToCenter((Component)this.declaredDependenciesList));
        Object object2 = linksHandler;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"createScrollPane().apply\u2026dDependenciesList))\n    }");
        Object declaredDependenciesListPanel = object2;
        Object $this$resultPanel_u24lambda_u2d10_u24lambda_u2d9 = $this$resultPanel_u24lambda_u2d10_u24lambda_u2d8 = ScrollPaneFactory.createScrollPane();
        boolean bl11 = false;
        ((JScrollPane)$this$resultPanel_u24lambda_u2d10_u24lambda_u2d9).setColumnHeaderView((Component)this.treeHeader);
        ((JScrollPane)$this$resultPanel_u24lambda_u2d10_u24lambda_u2d9).setViewportView((Component)this.dependencyStructureTree);
        Object object3 = $this$resultPanel_u24lambda_u2d10_u24lambda_u2d8;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"createScrollPane().apply\u2026encyStructureTree)\n\n    }");
        Object librariesStructurePanel = object3;
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.5f);
        splitter.setFirstComponent((JComponent)declaredDependenciesListPanel);
        splitter.setSecondComponent((JComponent)librariesStructurePanel);
        $this$resultPanel_u24lambda_u2d10.add((Component)splitter, "Center");
        ((JetifierWarningDetailsView)object).resultPanel = jComponent;
        JPanel $this$_init__u24lambda_u2d11 = $this$resultPanel_u24lambda_u2d10 = new JPanel();
        boolean bl12 = false;
        $this$_init__u24lambda_u2d11.setLayout(new BoxLayout($this$_init__u24lambda_u2d11, 1));
        $this$_init__u24lambda_u2d11.add(this.removeJetifierButton);
        $this$_init__u24lambda_u2d11.add(this.runCheckButton);
        JPanel buttonsPanel = $this$resultPanel_u24lambda_u2d10;
        JPanel $this$_init__u24lambda_u2d12 = serializable = new JPanel();
        boolean bl13 = false;
        $this$_init__u24lambda_u2d12.setLayout(new BoxLayout($this$_init__u24lambda_u2d12, 0));
        this.headerTextArea.setMaximumSize((Dimension)JBUI.size((int)800, (int)Integer.MAX_VALUE));
        buttonsPanel.setAlignmentY(1.0f);
        this.headerTextArea.setAlignmentY(1.0f);
        $this$_init__u24lambda_u2d12.add(this.headerTextArea);
        $this$_init__u24lambda_u2d12.add(buttonsPanel);
        JPanel headerPanel = serializable;
        this.pagePanel.setLayout(new GridBagLayout());
        $this$_init__u24lambda_u2d12 = serializable = new GridBagConstraints();
        Component component2 = headerPanel;
        object = this.pagePanel;
        boolean bl14 = false;
        ((GridBagConstraints)$this$_init__u24lambda_u2d13).gridx = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2d13).gridy = 0;
        ((GridBagConstraints)$this$_init__u24lambda_u2d13).weightx = 1.0;
        ((GridBagConstraints)$this$_init__u24lambda_u2d13).fill = 2;
        Unit unit = Unit.INSTANCE;
        ((Container)object).add(component2, serializable);
        Serializable $this$_init__u24lambda_u2d13 = serializable = new GridBagConstraints();
        component2 = this.resultPanel;
        object = this.pagePanel;
        boolean bl15 = false;
        $this$_init__u24lambda_u2d14.gridx = 0;
        $this$_init__u24lambda_u2d14.gridy = 1;
        $this$_init__u24lambda_u2d14.gridwidth = 0;
        $this$_init__u24lambda_u2d14.weightx = 1.0;
        $this$_init__u24lambda_u2d14.weighty = 1.0;
        $this$_init__u24lambda_u2d14.insets = (Insets)JBUI.insetsTop((int)10);
        $this$_init__u24lambda_u2d14.fill = 1;
        unit = Unit.INSTANCE;
        ((Container)object).add(component2, serializable);
        this.setupRefresh();
    }

    @NotNull
    public final JPanel getPagePanel() {
        return this.pagePanel;
    }

    private final void setupRefresh() {
        Alarm refreshAlarm = new Alarm((JComponent)this.pagePanel, this.disposable);
        new Runnable(this, refreshAlarm){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            final /* synthetic */ Alarm $refreshAlarm;
            {
                this.this$0 = $receiver;
                this.$refreshAlarm = $refreshAlarm;
            }

            public void run() {
                JetifierWarningDetailsView.access$refreshUi(this.this$0);
                this.$refreshAlarm.addRequest((Runnable)this, 30000);
            }
        }.run();
        new UiNotifyConnector((Component)this.pagePanel, new Activatable(this){
            final /* synthetic */ JetifierWarningDetailsView this$0;
            {
                this.this$0 = $receiver;
            }

            public void showNotify() {
                JetifierWarningDetailsView.access$refreshUi(this.this$0);
            }
        });
    }

    private final void refreshUi() {
        Object object;
        SimpleColoredComponent it;
        block3: {
            block2: {
                it = this.tableHeader;
                boolean bl = false;
                it.clear();
                object = this.data.getLastCheckJetifierBuildTimestamp();
                if (object == null) break block2;
                long it2 = ((Number)object).longValue();
                boolean bl2 = false;
                String string = StringUtil.decapitalize((String)JBDateFormat.getFormatter().formatPrettyDateTime(it2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decapitalize(JBDateForma\u2026formatPrettyDateTime(it))");
                String lastUpdatedTime = string;
                String string2 = " (updated " + lastUpdatedTime + ")";
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        Object lastUpdatedSuffix = object;
        it.append("Declared Dependencies Requiring Jetifier" + (String)lastUpdatedSuffix);
    }

    /*
     * WARNING - void declaration
     */
    private final void onDeclaredDependencySelection() {
        if (this.data.getProjectStatus() instanceof JetifierRequiredForLibraries) {
            TreeModel treeModel;
            DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode();
            DirectDependencyDescriptor selectedDependency = (DirectDependencyDescriptor)this.declaredDependenciesList.getSelectedValue();
            if (selectedDependency != null) {
                Object object;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = selectedDependency.getPathToSupportLibrary();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    object = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(new DependencyDescriptor((String)it));
                }
                List descriptors = (List)destination$iv$iv;
                ((DependencyDescriptor)CollectionsKt.last((List)descriptors)).setSupportLibrary(true);
                ((DependencyDescriptor)CollectionsKt.first((List)descriptors)).setDeclaredDependency(true);
                List $this$foldRight$iv = descriptors;
                boolean $i$f$foldRight = false;
                DefaultMutableTreeNode accumulator$iv = newRoot;
                if (!$this$foldRight$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$foldRight$iv.listIterator($this$foldRight$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        void parentNode;
                        DefaultMutableTreeNode $i$f$mapTo2 = accumulator$iv;
                        DependencyDescriptor descriptor2 = (DependencyDescriptor)iterator$iv.previous();
                        boolean bl = false;
                        Object it = object = new DependencyTreeNode(descriptor2);
                        boolean bl2 = false;
                        parentNode.add((MutableTreeNode)it);
                        accumulator$iv = (DefaultMutableTreeNode)object;
                    }
                }
            }
            DefaultTreeModel defaultTreeModel = (treeModel = this.dependencyStructureTree.getModel()) instanceof DefaultTreeModel ? (DefaultTreeModel)treeModel : null;
            if (defaultTreeModel != null) {
                defaultTreeModel.setRoot(newRoot);
            }
            TreeUtil.expandAll((JTree)((JTree)this.dependencyStructureTree));
        }
    }

    private final void installResultsTableActions(JBList<DirectDependencyDescriptor> resultsTable2) {
        AnAction findSelectedLibVersionDeclarationAction2 = this.actionHandlers.createFindSelectedLibVersionDeclarationAction(new Supplier(resultsTable2){
            final /* synthetic */ JBList<DirectDependencyDescriptor> $resultsTable;
            {
                this.$resultsTable = $resultsTable;
            }

            @Nullable
            public final DirectDependencyDescriptor get() {
                return (DirectDependencyDescriptor)this.$resultsTable.getSelectedValue();
            }
        });
        DefaultActionGroup group2 = new DefaultActionGroup();
        boolean bl = false;
        group2.add(findSelectedLibVersionDeclarationAction2);
        PopupHandler.installPopupMenu((JComponent)((JComponent)resultsTable2), (ActionGroup)((ActionGroup)group2), (String)"popup");
        new DoubleClickListener(findSelectedLibVersionDeclarationAction2, resultsTable2){
            final /* synthetic */ AnAction $findSelectedLibVersionDeclarationAction;
            final /* synthetic */ JBList<DirectDependencyDescriptor> $resultsTable;
            {
                this.$findSelectedLibVersionDeclarationAction = $findSelectedLibVersionDeclarationAction;
                this.$resultsTable = $resultsTable;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ActionManager.getInstance().tryToExecute(this.$findSelectedLibVersionDeclarationAction, (InputEvent)e, (Component)this.$resultsTable, null, true);
                return true;
            }
        }.installOn((Component)resultsTable2);
        Serializable serializable = resultsTable2.getInputMap(1);
        InputMap $this$installResultsTableActions_u24lambda_u2d21 = serializable;
        boolean bl2 = false;
        $this$installResultsTableActions_u24lambda_u2d21.put(KeyStroke.getKeyStroke(10, 0), "enter");
        $this$installResultsTableActions_u24lambda_u2d21.put(KeyStroke.getKeyStroke(32, 0), "enter");
        Serializable $this$installResultsTableActions_u24lambda_u2d22 = serializable = resultsTable2.getActionMap();
        boolean bl3 = false;
        ((ActionMap)$this$installResultsTableActions_u24lambda_u2d22).put("enter", new AbstractAction(findSelectedLibVersionDeclarationAction2, resultsTable2){
            final /* synthetic */ AnAction $findSelectedLibVersionDeclarationAction;
            final /* synthetic */ JBList<DirectDependencyDescriptor> $resultsTable;
            {
                this.$findSelectedLibVersionDeclarationAction = $findSelectedLibVersionDeclarationAction;
                this.$resultsTable = $resultsTable;
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ActionManager.getInstance().tryToExecute(this.$findSelectedLibVersionDeclarationAction, null, (Component)this.$resultsTable, null, true);
            }
        });
    }

    private final boolean isPreviouslySavedResultReused(JetifierUsageAnalyzerResult $this$isPreviouslySavedResultReused) {
        return !$this$isPreviouslySavedResultReused.getCheckJetifierBuild() && ($this$isPreviouslySavedResultReused.getProjectStatus() instanceof JetifierCanBeRemoved || $this$isPreviouslySavedResultReused.getProjectStatus() instanceof JetifierRequiredForLibraries);
    }

    public static final /* synthetic */ void access$refreshUi(JetifierWarningDetailsView $this) {
        $this.refreshUi();
    }

    public static final /* synthetic */ ViewActionHandlers access$getActionHandlers$p(JetifierWarningDetailsView $this) {
        return $this.actionHandlers;
    }

    public static final /* synthetic */ JetifierUsageAnalyzerResult access$getData$p(JetifierWarningDetailsView $this) {
        return $this.data;
    }

    public static final /* synthetic */ void access$onDeclaredDependencySelection(JetifierWarningDetailsView $this) {
        $this.onDeclaredDependencySelection();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyTreeNode;", "Ljavax/swing/tree/DefaultMutableTreeNode;", "descriptor", "Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;", "(Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;)V", "getDescriptor", "()Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;", "toString", "", "intellij.android.build-attribution"})
    private static final class DependencyTreeNode
    extends DefaultMutableTreeNode {
        @NotNull
        private final DependencyDescriptor descriptor;

        public DependencyTreeNode(@NotNull DependencyDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            super(descriptor2);
            this.descriptor = descriptor2;
        }

        @NotNull
        public final DependencyDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        @NotNull
        public String toString() {
            return this.descriptor.getFullName();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u001a\u0010\u000f\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\b\"\u0004\b\u0011\u0010\nR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependencyDescriptor;", "", "fullName", "", "(Ljava/lang/String;)V", "declaredDependency", "", "getDeclaredDependency", "()Z", "setDeclaredDependency", "(Z)V", "getFullName", "()Ljava/lang/String;", "prefix", "getPrefix", "supportLibrary", "getSupportLibrary", "setSupportLibrary", "tooltip", "getTooltip", "intellij.android.build-attribution"})
    public static final class DependencyDescriptor {
        @NotNull
        private final String fullName;
        private boolean declaredDependency;
        private boolean supportLibrary;

        public DependencyDescriptor(@NotNull String fullName) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            this.fullName = fullName;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        public final boolean getDeclaredDependency() {
            return this.declaredDependency;
        }

        public final void setDeclaredDependency(boolean bl) {
            this.declaredDependency = bl;
        }

        public final boolean getSupportLibrary() {
            return this.supportLibrary;
        }

        public final void setSupportLibrary(boolean bl) {
            this.supportLibrary = bl;
        }

        @NotNull
        public final String getPrefix() {
            return this.declaredDependency ? "" : (this.supportLibrary ? "depends on " : "via ");
        }

        @Nullable
        public final String getTooltip() {
            return JetifierWarningDetailsKt.access$treeToolTip(this.supportLibrary, this.declaredDependency);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\b\u0016\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007B)\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0004H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005H\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\b\u001a\u00020\u00042\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DirectDependencyDescriptor;", "", "resultEntry", "", "", "", "Lcom/android/buildanalyzer/common/FullDependencyPath;", "(Ljava/util/Map$Entry;)V", "fullName", "projects", "pathToSupportLibrary", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getFullName", "()Ljava/lang/String;", "isSupportLibrary", "", "()Z", "getPathToSupportLibrary", "()Ljava/util/List;", "getProjects", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class DirectDependencyDescriptor {
        @NotNull
        private final String fullName;
        @NotNull
        private final List<String> projects;
        @NotNull
        private final List<String> pathToSupportLibrary;

        public DirectDependencyDescriptor(@NotNull String fullName, @NotNull List<String> projects2, @NotNull List<String> pathToSupportLibrary) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            Intrinsics.checkNotNullParameter(projects2, (String)"projects");
            Intrinsics.checkNotNullParameter(pathToSupportLibrary, (String)"pathToSupportLibrary");
            this.fullName = fullName;
            this.projects = projects2;
            this.pathToSupportLibrary = pathToSupportLibrary;
        }

        @NotNull
        public final String getFullName() {
            return this.fullName;
        }

        @NotNull
        public final List<String> getProjects() {
            return this.projects;
        }

        @NotNull
        public final List<String> getPathToSupportLibrary() {
            return this.pathToSupportLibrary;
        }

        public final boolean isSupportLibrary() {
            return this.pathToSupportLibrary.size() == 1;
        }

        /*
         * WARNING - void declaration
         */
        public DirectDependencyDescriptor(@NotNull Map.Entry<String, ? extends List<FullDependencyPath>> resultEntry) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(resultEntry, (String)"resultEntry");
            Iterable iterable = resultEntry.getValue();
            String string = resultEntry.getKey();
            DirectDependencyDescriptor directDependencyDescriptor = this;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FullDependencyPath fullDependencyPath = (FullDependencyPath)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(it.getProjectPath());
            }
            collection2 = (List)destination$iv$iv;
            directDependencyDescriptor(string, (List<String>)collection2, ((FullDependencyPath)CollectionsKt.first(resultEntry.getValue())).getDependencyPath().getElements());
        }

        @NotNull
        public final String component1() {
            return this.fullName;
        }

        @NotNull
        public final List<String> component2() {
            return this.projects;
        }

        @NotNull
        public final List<String> component3() {
            return this.pathToSupportLibrary;
        }

        @NotNull
        public final DirectDependencyDescriptor copy(@NotNull String fullName, @NotNull List<String> projects2, @NotNull List<String> pathToSupportLibrary) {
            Intrinsics.checkNotNullParameter((Object)fullName, (String)"fullName");
            Intrinsics.checkNotNullParameter(projects2, (String)"projects");
            Intrinsics.checkNotNullParameter(pathToSupportLibrary, (String)"pathToSupportLibrary");
            return new DirectDependencyDescriptor(fullName, projects2, pathToSupportLibrary);
        }

        public static /* synthetic */ DirectDependencyDescriptor copy$default(DirectDependencyDescriptor directDependencyDescriptor, String string, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                string = directDependencyDescriptor.fullName;
            }
            if ((n & 2) != 0) {
                list2 = directDependencyDescriptor.projects;
            }
            if ((n & 4) != 0) {
                list3 = directDependencyDescriptor.pathToSupportLibrary;
            }
            return directDependencyDescriptor.copy(string, list2, list3);
        }

        @NotNull
        public String toString() {
            return "DirectDependencyDescriptor(fullName=" + this.fullName + ", projects=" + this.projects + ", pathToSupportLibrary=" + this.pathToSupportLibrary + ")";
        }

        public int hashCode() {
            int result2 = this.fullName.hashCode();
            result2 = result2 * 31 + ((Object)this.projects).hashCode();
            result2 = result2 * 31 + ((Object)this.pathToSupportLibrary).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DirectDependencyDescriptor)) {
                return false;
            }
            DirectDependencyDescriptor directDependencyDescriptor = (DirectDependencyDescriptor)other;
            if (!Intrinsics.areEqual((Object)this.fullName, (Object)directDependencyDescriptor.fullName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.projects, directDependencyDescriptor.projects)) {
                return false;
            }
            return Intrinsics.areEqual(this.pathToSupportLibrary, directDependencyDescriptor.pathToSupportLibrary);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/build/attribution/ui/view/details/JetifierWarningDetailsView$DependenciesStructureTreeRenderer;", "Lcom/intellij/ide/util/treeView/NodeRenderer;", "()V", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.android.build-attribution"})
    private static final class DependenciesStructureTreeRenderer
    extends NodeRenderer {
        public void customizeCellRenderer(@NotNull JTree tree2, @Nullable Object value2, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            DependencyDescriptor userObj;
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            Object object = node.getUserObject();
            DependencyDescriptor dependencyDescriptor = userObj = object instanceof DependencyDescriptor ? (DependencyDescriptor)object : null;
            if (userObj == null) {
                super.customizeCellRenderer(tree2, value2, selected, expanded, leaf, row2, hasFocus);
            } else {
                this.setIcon(PlatformIcons.LIBRARY_ICON);
                this.append(userObj.getPrefix(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
                this.append(userObj.getFullName());
                this.setToolTipText(userObj.getTooltip());
            }
        }
    }
}

