/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view.chart;

import com.android.build.attribution.ui.view.chart.TimeDistributionTreeChart;
import com.android.build.attribution.ui.view.chart.TimeDistributionTreeChartCalculationModel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.PairConsumer;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000W\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0005\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0003\b\r\u0012\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001eH\u0002J\u0011\u0010\"\u001a\u00070#\u00a2\u0006\u0002\b\u0016*\u00020\u001aH\u0002R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart;", "Ljavax/swing/JComponent;", "model", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "(Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;Lcom/intellij/ui/treeStructure/Tree;)V", "focusListener", "com/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$focusListener$1", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$focusListener$1;", "getModel", "()Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChartCalculationModel;", "mouseListener", "com/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$mouseListener$1", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$mouseListener$1;", "getTree", "()Lcom/intellij/ui/treeStructure/Tree;", "treeExpansionListener", "com/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$treeExpansionListener$1", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$treeExpansionListener$1;", "treeModelListener", "Ljavax/swing/event/TreeModelListener;", "Lorg/jetbrains/annotations/NotNull;", "treeSelectionListener", "Ljavax/swing/event/TreeSelectionListener;", "getMaximumSize", "Ljava/awt/Dimension;", "getMinimumSize", "getPreferredSize", "paintComponent", "", "g", "Ljava/awt/Graphics;", "refreshSelectionArea", "makeFullWidth", "Lcom/intellij/util/ui/JBDimension;", "Companion", "MyScrollPane", "intellij.android.build-attribution"})
public final class TimeDistributionTreeChart
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimeDistributionTreeChartCalculationModel model;
    @NotNull
    private final Tree tree;
    @NotNull
    private final TreeModelListener treeModelListener;
    @NotNull
    private final treeExpansionListener.1 treeExpansionListener;
    @NotNull
    private final focusListener.1 focusListener;
    @NotNull
    private final TreeSelectionListener treeSelectionListener;
    @NotNull
    private final mouseListener.1 mouseListener;

    public TimeDistributionTreeChart(@NotNull TimeDistributionTreeChartCalculationModel model2, @NotNull Tree tree2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        this.model = model2;
        this.tree = tree2;
        TreeModelListener treeModelListener2 = TreeModelAdapter.create((PairConsumer)new PairConsumer(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public final void consume(TreeModelEvent treeModelEvent, TreeModelAdapter.EventType eventType) {
                this.this$0.getModel().refreshModel();
                this.this$0.repaint();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)treeModelListener2, (String)"create { _, _ ->\n    mod\u2026Model()\n    repaint()\n  }");
        this.treeModelListener = treeModelListener2;
        this.treeExpansionListener = new TreeExpansionListener(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public void treeExpanded(@Nullable TreeExpansionEvent event) {
                this.this$0.repaint();
            }

            public void treeCollapsed(@Nullable TreeExpansionEvent event) {
                this.this$0.repaint();
            }
        };
        this.focusListener = new FocusListener(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusLost(@Nullable FocusEvent e) {
                TimeDistributionTreeChart.access$refreshSelectionArea(this.this$0);
            }

            public void focusGained(@Nullable FocusEvent e) {
                TimeDistributionTreeChart.access$refreshSelectionArea(this.this$0);
            }
        };
        this.treeSelectionListener = new TreeSelectionListener(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public final void valueChanged(TreeSelectionEvent it) {
                TimeDistributionTreeChart.access$refreshSelectionArea(this.this$0);
            }
        };
        this.mouseListener = new MouseAdapter(this){
            final /* synthetic */ TimeDistributionTreeChart this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel = this.this$0.getModel();
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                    TimeDistributionTreeChartCalculationModel.ChartRowItem chartRowItem = timeDistributionTreeChartCalculationModel.itemByCoordinates(point);
                    if (chartRowItem == null) break block0;
                    TimeDistributionTreeChartCalculationModel.ChartRowItem chartRowItem2 = chartRowItem;
                    TimeDistributionTreeChart timeDistributionTreeChart = this.this$0;
                    TimeDistributionTreeChartCalculationModel.ChartRowItem it = chartRowItem2;
                    boolean bl = false;
                    timeDistributionTreeChart.getTree().getSelectionModel().setSelectionPath(it.getTreePath());
                    timeDistributionTreeChart.getTree().requestFocusInWindow();
                }
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TimeDistributionTreeChartCalculationModel.ChartRowItem chartRowItem = this.this$0.getModel().getHoveredItem();
                if (chartRowItem != null) {
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                    bl = chartRowItem.contains(point);
                } else {
                    bl = false;
                }
                if (bl) {
                    return;
                }
                TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel = this.this$0.getModel();
                TimeDistributionTreeChartCalculationModel timeDistributionTreeChartCalculationModel2 = this.this$0.getModel();
                Point point = e.getPoint();
                Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                timeDistributionTreeChartCalculationModel.setHoveredItem(timeDistributionTreeChartCalculationModel2.itemByCoordinates(point));
                this.this$0.repaint();
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getModel().setHoveredItem(null);
                this.this$0.repaint();
            }
        };
        this.setBackground(UIUtil.getTreeBackground());
        this.tree.getModel().addTreeModelListener(this.treeModelListener);
        this.tree.addTreeExpansionListener((TreeExpansionListener)this.treeExpansionListener);
        this.tree.addFocusListener((FocusListener)this.focusListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.addMouseListener(this.mouseListener);
        this.addMouseMotionListener(this.mouseListener);
    }

    @NotNull
    public final TimeDistributionTreeChartCalculationModel getModel() {
        return this.model;
    }

    @NotNull
    public final Tree getTree() {
        return this.tree;
    }

    private final void refreshSelectionArea() {
        this.model.refreshSelectionArea(this.tree.getSelectionPath(), this.tree.isFocusOwner());
        this.repaint();
    }

    private final JBDimension makeFullWidth(Dimension $this$makeFullWidth) {
        JBDimension jBDimension = JBDimension.size((Dimension)$this$makeFullWidth).withWidth(203);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(this)\n    .withWidth(FULL_WIDTH_PX)");
        return jBDimension;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension2 = this.tree.getPreferredSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"tree.getPreferredSize()");
        return (Dimension)this.makeFullWidth(dimension2);
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension2 = this.tree.getMinimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"tree.getMinimumSize()");
        return (Dimension)this.makeFullWidth(dimension2);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        Dimension dimension2 = this.tree.getMaximumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"tree.getMaximumSize()");
        return (Dimension)this.makeFullWidth(dimension2);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        Rectangle rectangle = this.getVisibleRect();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"visibleRect");
        this.model.recalculateCoordinates(rectangle);
        GraphicsUtil.setupAntialiasing((Graphics)g);
        GraphicsUtil.setupAAPainting((Graphics)g);
        this.model.getSelectionArea().draw(g);
        Iterable $this$forEach$iv = this.model.getChartItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimeDistributionTreeChartCalculationModel.ChartRowItem it = (TimeDistributionTreeChartCalculationModel.ChartRowItem)element$iv;
            boolean bl = false;
            it.draw(g);
        }
        this.model.getMergedItemsBar().draw(g);
    }

    public static final /* synthetic */ void access$refreshSelectionArea(TimeDistributionTreeChart $this) {
        $this.refreshSelectionArea();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$Companion;", "", "()V", "wrap", "Ljavax/swing/JComponent;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "intellij.android.build-attribution"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JComponent wrap(@NotNull Tree tree2) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            TreeModel treeModel = tree2.getModel();
            Intrinsics.checkNotNullExpressionValue((Object)treeModel, (String)"tree.model");
            TimeDistributionTreeChartCalculationModel model2 = new TimeDistributionTreeChartCalculationModel(treeModel, (Function1<? super TreePath, ? extends Rectangle>)((Function1)new Function1<TreePath, Rectangle>(tree2){
                final /* synthetic */ Tree $tree;
                {
                    this.$tree = $tree;
                    super(1);
                }

                @Nullable
                public final Rectangle invoke(@NotNull TreePath treePath) {
                    Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
                    return this.$tree.getPathBounds(treePath);
                }
            }));
            return (JComponent)((Object)new MyScrollPane(tree2, new TimeDistributionTreeChart(model2, tree2)));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart$MyScrollPane;", "Lcom/intellij/ui/components/JBScrollPane;", "tree", "Lcom/intellij/ui/treeStructure/Tree;", "chart", "Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart;", "(Lcom/intellij/ui/treeStructure/Tree;Lcom/android/build/attribution/ui/view/chart/TimeDistributionTreeChart;)V", "intellij.android.build-attribution"})
    private static final class MyScrollPane
    extends JBScrollPane {
        @NotNull
        private final Tree tree;

        public MyScrollPane(@NotNull Tree tree2, @NotNull TimeDistributionTreeChart chart) {
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
            super((Component)tree2, 20, 30);
            this.tree = tree2;
            this.setRowHeaderView(chart);
            this.rowHeader.setScrollMode(0);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setLayout((LayoutManager)new JBScrollPane.Layout(){

                public void layoutContainer(@Nullable Container parent2) {
                    block2: {
                        Object $this$layoutContainer_u24lambda_u2d0;
                        JComponent jComponent;
                        super.layoutContainer(parent2);
                        JViewport jViewport = this.viewport;
                        if (jViewport != null) {
                            jComponent = jViewport;
                            $this$layoutContainer_u24lambda_u2d0 = jComponent;
                            boolean bl = false;
                            $this$layoutContainer_u24lambda_u2d0.setLocation(0, $this$layoutContainer_u24lambda_u2d0.getY());
                        }
                        JViewport jViewport2 = this.rowHead;
                        if (jViewport2 != null) {
                            jComponent = jViewport2;
                            $this$layoutContainer_u24lambda_u2d0 = this;
                            JViewport $this$layoutContainer_u24lambda_u2d1 = jComponent;
                            boolean bl = false;
                            $this$layoutContainer_u24lambda_u2d1.setLocation(this.viewport.getWidth() - ((MyScrollPane)((Object)$this$layoutContainer_u24lambda_u2d0)).tree.getInsets().right, $this$layoutContainer_u24lambda_u2d1.getY());
                        }
                        JScrollBar jScrollBar = this.getHorizontalScrollBar();
                        if (jScrollBar == null) break block2;
                        JComponent $this$layoutContainer_u24lambda_u2d2 = jComponent = jScrollBar;
                        boolean bl = false;
                        $this$layoutContainer_u24lambda_u2d2.setLocation(0, $this$layoutContainer_u24lambda_u2d2.getY());
                    }
                }
            });
        }
    }
}

