/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.view;

import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.data.BuildSummary;
import com.android.build.attribution.ui.data.DownloadsSummaryUIData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.model.BuildOverviewPageModel;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.WarningsDataPageModelKt;
import com.android.build.attribution.ui.view.BuildAnalyzerDataPageView;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.tools.adtui.TabularLayout;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0018\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/android/build/attribution/ui/view/BuildOverviewPageView;", "Lcom/android/build/attribution/ui/view/BuildAnalyzerDataPageView;", "model", "Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "(Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;Lcom/android/build/attribution/ui/view/ViewActionHandlers;)V", "getActionHandlers", "()Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "additionalControls", "Ljavax/swing/JPanel;", "getAdditionalControls", "()Ljavax/swing/JPanel;", "buildInformationPanel", "component", "getComponent", "garbageCollectionIssuePanel", "linksHandler", "Lcom/android/build/attribution/ui/HtmlLinksHandler;", "getLinksHandler", "()Lcom/android/build/attribution/ui/HtmlLinksHandler;", "linksPanel", "getModel", "()Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "generateInfoPanelHtml", "", "optionalDownloadsOverviewSection", "downloadsData", "Lcom/android/build/attribution/ui/data/DownloadsSummaryUIData;", "intellij.android.build-attribution"})
public final class BuildOverviewPageView
implements BuildAnalyzerDataPageView {
    @NotNull
    private final BuildOverviewPageModel model;
    @NotNull
    private final ViewActionHandlers actionHandlers;
    @NotNull
    private final HtmlLinksHandler linksHandler;
    @NotNull
    private final JPanel buildInformationPanel;
    @NotNull
    private final JPanel linksPanel;
    @NotNull
    private final JPanel garbageCollectionIssuePanel;
    @NotNull
    private final JPanel component;
    @NotNull
    private final JPanel additionalControls;

    /*
     * WARNING - void declaration
     */
    public BuildOverviewPageView(@NotNull BuildOverviewPageModel model2, @NotNull ViewActionHandlers actionHandlers) {
        void $this$additionalControls_u24lambda_u2d15;
        JPanel $this$component_u24lambda_u2d14;
        void $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9;
        JLabel jLabel;
        void $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d10;
        JPanel jPanel;
        Icon icon2;
        JPanel $this$garbageCollectionIssuePanel_u24lambda_u2d11;
        void $this$linksPanel_u24lambda_u2d6_u24lambda_u2d5;
        Object $this$linksPanel_u24lambda_u2d6_u24lambda_u2d4;
        Object $this$linksPanel_u24lambda_u2d6_u24lambda_u2d3;
        Object $this$linksPanel_u24lambda_u2d6_u24lambda_u2d2;
        JPanel $this$linksPanel_u24lambda_u2d6;
        JPanel $this$buildInformationPanel_u24lambda_u2d0;
        JPanel jPanel2;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        this.model = model2;
        this.actionHandlers = actionHandlers;
        this.linksHandler = new HtmlLinksHandler(this.actionHandlers);
        JPanel jPanel3 = jPanel2 = new JPanel();
        BuildOverviewPageView buildOverviewPageView = this;
        boolean bl = false;
        $this$buildInformationPanel_u24lambda_u2d0.setName("info");
        $this$buildInformationPanel_u24lambda_u2d0.setLayout((LayoutManager)new VerticalLayout(0, 2));
        Object infoPanelHtml = this.generateInfoPanelHtml();
        $this$buildInformationPanel_u24lambda_u2d0.add(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines((String)infoPanelHtml, this.linksHandler));
        buildOverviewPageView.buildInformationPanel = jPanel2;
        $this$buildInformationPanel_u24lambda_u2d0 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl2 = false;
        $this$linksPanel_u24lambda_u2d6.setName("links");
        $this$linksPanel_u24lambda_u2d6.setLayout((LayoutManager)new VerticalLayout(10, 2));
        Object object = infoPanelHtml = BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default("<b>Common views into this build</b>", null, 2, null);
        StringBuilder stringBuilder = $this$linksPanel_u24lambda_u2d6;
        boolean bl3 = false;
        ((JComponent)$this$linksPanel_u24lambda_u2d6_u24lambda_u2d2).setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        $this$linksPanel_u24lambda_u2d6_u24lambda_u2d2 = infoPanelHtml = new HyperlinkLabel("Tasks impacting build duration");
        stringBuilder = $this$linksPanel_u24lambda_u2d6;
        boolean bl4 = false;
        $this$linksPanel_u24lambda_u2d6_u24lambda_u2d3.addHyperlinkListener(new HyperlinkListener(this){
            final /* synthetic */ BuildOverviewPageView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void hyperlinkUpdate(HyperlinkEvent it) {
                this.this$0.getActionHandlers().changeViewToTasksLinkClicked(null);
            }
        });
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        $this$linksPanel_u24lambda_u2d6_u24lambda_u2d3 = infoPanelHtml = new HyperlinkLabel("Plugins with tasks impacting build duration");
        stringBuilder = $this$linksPanel_u24lambda_u2d6;
        boolean bl5 = false;
        $this$linksPanel_u24lambda_u2d6_u24lambda_u2d4.addHyperlinkListener(new HyperlinkListener(this){
            final /* synthetic */ BuildOverviewPageView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void hyperlinkUpdate(HyperlinkEvent it) {
                this.this$0.getActionHandlers().changeViewToTasksLinkClicked(TasksDataPageModel.Grouping.BY_PLUGIN);
            }
        });
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        $this$linksPanel_u24lambda_u2d6_u24lambda_u2d4 = infoPanelHtml = new HyperlinkLabel("All warnings");
        stringBuilder = $this$linksPanel_u24lambda_u2d6;
        boolean bl6 = false;
        $this$linksPanel_u24lambda_u2d6_u24lambda_u2d5.addHyperlinkListener(new HyperlinkListener(this){
            final /* synthetic */ BuildOverviewPageView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void hyperlinkUpdate(HyperlinkEvent it) {
                this.this$0.getActionHandlers().changeViewToWarningsLinkClicked();
            }
        });
        ((Container)((Object)stringBuilder)).add((Component)infoPanelHtml);
        buildOverviewPageView.linksPanel = jPanel2;
        $this$linksPanel_u24lambda_u2d6 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl7 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u2d11.setName("memory");
        $this$garbageCollectionIssuePanel_u24lambda_u2d11.setLayout((LayoutManager)new VerticalLayout(5));
        Object gcTime = this.model.getReportUiData().getBuildSummary().getGarbageCollectionTime();
        String panelHeader = "<b>Gradle Daemon Memory Utilization</b>";
        StringBuilder $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d7 = stringBuilder = new StringBuilder();
        boolean bl8 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d7.append(BuildAttributionUIUtilKt.percentageStringHtml((TimeWithPercentage)gcTime) + " (" + BuildAttributionUIUtilKt.durationStringHtml((TimeWithPercentage)gcTime) + ") of your build\u2019s time was dedicated to garbage collection during this build.<br/>");
        if (this.model.getShouldWarnAboutGC()) {
            $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d7.append("To reduce the amount of time spent on garbage collection, please consider increasing the Gradle daemon heap size.<br/>");
        }
        $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d7.append("You can change the Gradle daemon heap size on the memory settings page.");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        String descriptionText = string;
        AbstractAction action2 = new AbstractAction(this){
            final /* synthetic */ BuildOverviewPageView this$0;
            {
                this.this$0 = $receiver;
                super("Edit memory settings");
            }

            public void actionPerformed(@Nullable ActionEvent e) {
                this.this$0.getActionHandlers().openMemorySettings();
            }
        };
        JPanel $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d8 = bl8 = new JPanel();
        boolean bl9 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d8.setLayout((LayoutManager)new HorizontalLayout(10));
        $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d8.add((Component)new JButton(action2), "LEFT");
        JPanel controlsPanel = bl8;
        if (this.model.getShouldWarnAboutGC()) {
            icon2 = BuildAttributionUIUtilKt.warningIcon();
        } else {
            Icon icon3 = AllIcons.General.Information;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Information");
        }
        Icon icon4 = icon2;
        JEditorPane defaultGCUsageWarning = BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines("", this.linksHandler);
        String fineTuneYourJvmLink = this.linksHandler.externalLink("Fine tune your JVM", BuildAnalyzerBrowserLinks.CONFIGURE_GC);
        String dontShowThisAgainLink2 = this.linksHandler.actionLink("Don't show this again", "suppress", new Runnable(this, defaultGCUsageWarning){
            final /* synthetic */ BuildOverviewPageView this$0;
            final /* synthetic */ JEditorPane $defaultGCUsageWarning;
            {
                this.this$0 = $receiver;
                this.$defaultGCUsageWarning = $defaultGCUsageWarning;
            }

            public final void run() {
                int confirmationResult = Messages.showOkCancelDialog((String)"Click OK to hide this warning in future builds.", (String)"Confirm Warning Suppression", (String)Messages.getOkButton(), (String)Messages.getCancelButton(), (Icon)Messages.getInformationIcon());
                if (confirmationResult == 0) {
                    this.this$0.getActionHandlers().dontShowAgainNoGCSettingWarningClicked();
                    this.$defaultGCUsageWarning.setVisible(false);
                }
            }
        });
        String htmlContent = StringsKt.trimMargin$default((String)("\n      |The default garbage collector was used in this build running with JDK " + this.model.getReportUiData().getBuildSummary().getJavaVersionUsed() + ".<br/>\n      |Note that the default GC was changed starting with JDK 9. This could impact your build performance by as much as 10%.<br/>\n      |<b>Recommendation:</b> " + fineTuneYourJvmLink + ".<br/>\n      |" + dontShowThisAgainLink2 + ".\n    "), null, (int)1, null);
        SwingHelper.setHtml((JEditorPane)defaultGCUsageWarning, (String)htmlContent, null);
        defaultGCUsageWarning.setName("no-gc-setting-warning");
        $this$garbageCollectionIssuePanel_u24lambda_u2d11.add(BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default(panelHeader, null, 2, null));
        JPanel jPanel4 = jPanel = new JPanel();
        void var18_25 = $this$garbageCollectionIssuePanel_u24lambda_u2d11;
        boolean bl10 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d10.setLayout(new BorderLayout(5, 5));
        JLabel jLabel2 = jLabel = new JLabel(icon4);
        void var22_29 = $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d10;
        boolean bl11 = false;
        $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9.setVerticalAlignment(1);
        var22_29.add((Component)jLabel, "West");
        $this$garbageCollectionIssuePanel_u24lambda_u2d11_u24lambda_u2d10.add((Component)BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines$default(descriptionText, null, 2, null), "Center");
        var18_25.add(jPanel);
        $this$garbageCollectionIssuePanel_u24lambda_u2d11.add(controlsPanel);
        if (this.model.getShouldWarnAboutNoGCSetting()) {
            $this$garbageCollectionIssuePanel_u24lambda_u2d11.add(defaultGCUsageWarning);
        }
        buildOverviewPageView.garbageCollectionIssuePanel = jPanel2;
        $this$garbageCollectionIssuePanel_u24lambda_u2d11 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl12 = false;
        $this$component_u24lambda_u2d14.setName("build-overview");
        $this$component_u24lambda_u2d14.setLayout(new BorderLayout());
        Object $this$component_u24lambda_u2d14_u24lambda_u2d12 = gcTime = new JPanel();
        boolean bl13 = false;
        ((JComponent)$this$component_u24lambda_u2d14_u24lambda_u2d12).setBorder(JBUI.Borders.empty((int)20));
        ((Container)$this$component_u24lambda_u2d14_u24lambda_u2d12).setLayout((LayoutManager)new TabularLayout("Fit,50px,Fit,50px,Fit"));
        ((Container)$this$component_u24lambda_u2d14_u24lambda_u2d12).add((Component)this.buildInformationPanel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        ((Container)$this$component_u24lambda_u2d14_u24lambda_u2d12).add((Component)this.linksPanel, new TabularLayout.Constraint(0, 2, 0, 4, null));
        ((Container)$this$component_u24lambda_u2d14_u24lambda_u2d12).add((Component)this.garbageCollectionIssuePanel, new TabularLayout.Constraint(0, 4, 0, 4, null));
        Object content2 = gcTime;
        Object $this$component_u24lambda_u2d14_u24lambda_u2d13 = object = new JBScrollPane();
        boolean bl14 = false;
        $this$component_u24lambda_u2d14_u24lambda_u2d13.setBorder((Border)JBUI.Borders.empty());
        $this$component_u24lambda_u2d14_u24lambda_u2d13.setViewportView((Component)content2);
        Object scrollPane = object;
        $this$component_u24lambda_u2d14.add((Component)scrollPane, "Center");
        buildOverviewPageView.component = jPanel2;
        $this$component_u24lambda_u2d14 = jPanel2 = new JPanel();
        buildOverviewPageView = this;
        boolean bl15 = false;
        $this$additionalControls_u24lambda_u2d15.setName("build-overview-additional-controls");
        buildOverviewPageView.additionalControls = jPanel2;
    }

    @NotNull
    public final BuildOverviewPageModel getModel() {
        return this.model;
    }

    @NotNull
    public final ViewActionHandlers getActionHandlers() {
        return this.actionHandlers;
    }

    @NotNull
    public final HtmlLinksHandler getLinksHandler() {
        return this.linksHandler;
    }

    @NotNull
    public final String generateInfoPanelHtml() {
        Object object;
        BuildSummary buildSummary = this.model.getReportUiData().getBuildSummary();
        String string = DateFormatUtil.formatDateTime((long)buildSummary.getBuildFinishedTimestamp());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDateTime(buildSumm\u2026y.buildFinishedTimestamp)");
        String buildFinishedTime = string;
        if (WarningsDataPageModelKt.shouldShowWarning(this.model.getReportUiData().getConfCachingData())) {
            String it = this.linksHandler.actionLink("Optimize this", "configuration-cache", new Runnable(this){
                final /* synthetic */ BuildOverviewPageView this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void run() {
                    this.this$0.getActionHandlers().openConfigurationCacheWarnings();
                }
            });
            boolean bl = false;
            object = " - " + it;
        } else {
            object = "";
        }
        String optionalConfigurationCacheLink2 = object;
        return ((Object)StringsKt.trim((CharSequence)("\n<b>Build finished on " + buildFinishedTime + "</b><br/>\nTotal build duration was " + BuildAttributionUIUtilKt.durationStringHtml(buildSummary.getTotalBuildDuration()) + "<br/>\n<br/>\nIncludes:<br/>\nBuild configuration: " + BuildAttributionUIUtilKt.durationStringHtml(buildSummary.getConfigurationDuration()) + optionalConfigurationCacheLink2 + "<br/>\nCritical path tasks execution: " + BuildAttributionUIUtilKt.durationStringHtml(buildSummary.getCriticalPathDuration()) + "<br/>\n" + this.optionalDownloadsOverviewSection(this.model.getDownloadsSummaryUiData()) + "\n    "))).toString();
    }

    private final String optionalDownloadsOverviewSection(DownloadsSummaryUIData downloadsData) {
        if (downloadsData == null || downloadsData.isEmpty()) {
            return "";
        }
        String string = StringUtil.escapeXmlEntities((String)((Object)StringsKt.trim((CharSequence)("\n<html>\nThis build had " + downloadsData.getSumOfRequests() + " network " + StringUtil.pluralize((String)"request", (int)downloadsData.getSumOfRequests()) + ",<br/>\ndownloaded in total " + Formats.formatFileSize((long)downloadsData.getSumOfDataBytes()) + " in " + BuildAttributionUIUtilKt.durationStringHtml(downloadsData.getSumOfTimeMs()) + ".\n</html>\n    "))).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(\"\"\"\n<h\u2026.\n</html>\n    \"\"\".trim())");
        String tooltipDetails = string;
        String filesDownloadLink2 = this.linksHandler.actionLink("Files download", "downloads-view", new Runnable(this){
            final /* synthetic */ BuildOverviewPageView this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                this.this$0.getActionHandlers().changeViewToDownloadsLinkClicked();
            }
        });
        return filesDownloadLink2 + ": " + BuildAttributionUIUtilKt.durationStringHtml(downloadsData.getSumOfTimeMs()) + " " + BuildAttributionUIUtilKt.helpIcon(tooltipDetails) + "<br/>";
    }

    @Override
    @NotNull
    public JPanel getComponent() {
        return this.component;
    }

    @Override
    @NotNull
    public JPanel getAdditionalControls() {
        return this.additionalControls;
    }
}

