/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.panels;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.panels.BuildAttributionPanelsKt;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.tools.idea.flags.StudioFlags;
import com.android.utils.HtmlBuilder;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\t\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\f\u001a\u00020\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0010H\u0002\u001a$\u0010\u0011\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"NO_PLUGIN_INFO_HELP_TEXT", "", "pluginNameHtml", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "taskDetailsPage", "Ljavax/swing/JComponent;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "taskDetailsPanelHtml", "linksHandler", "Lcom/android/build/attribution/ui/HtmlLinksHandler;", "createReasonsSection", "", "Lcom/android/utils/HtmlBuilder;", "reasons", "", "createWarningsSection", "intellij.android.build-attribution"})
public final class BuildAttributionPanelsKt {
    @NotNull
    private static final String NO_PLUGIN_INFO_HELP_TEXT = "Gradle did not provide plugin information for this task due to Configuration cache being enabled and its entry being reused.";

    @NotNull
    public static final JComponent taskDetailsPage(@NotNull TaskUiData taskData, @NotNull ViewActionHandlers actionHandlers) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        JPanel $this$taskDetailsPage_u24lambda_u2d0 = jPanel = new JPanel();
        boolean bl = false;
        $this$taskDetailsPage_u24lambda_u2d0.setLayout(new BoxLayout($this$taskDetailsPage_u24lambda_u2d0, 1));
        HtmlLinksHandler linksHandler = new HtmlLinksHandler(actionHandlers);
        String detailsPanelHtml = BuildAttributionPanelsKt.taskDetailsPanelHtml(taskData, actionHandlers, linksHandler);
        JEditorPane htmlLabel = BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(detailsPanelHtml, linksHandler);
        htmlLabel.setAlignmentX(0.0f);
        $this$taskDetailsPage_u24lambda_u2d0.add(htmlLabel);
        return jPanel;
    }

    private static final String pluginNameHtml(TaskUiData taskData) {
        return taskData.getPluginUnknownBecauseOfCC() ? "N/A " + BuildAttributionUIUtilKt.helpIcon(NO_PLUGIN_INFO_HELP_TEXT) : taskData.getPluginName();
    }

    @NotNull
    public static final String taskDetailsPanelHtml(@NotNull TaskUiData taskData, @NotNull ViewActionHandlers actionHandlers, @NotNull HtmlLinksHandler linksHandler) {
        HtmlBuilder htmlBuilder;
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        Intrinsics.checkNotNullParameter((Object)linksHandler, (String)"linksHandler");
        HtmlBuilder $this$taskDetailsPanelHtml_u24lambda_u2d1 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        $this$taskDetailsPanelHtml_u24lambda_u2d1.addBold(taskData.getTaskPath()).newline();
        if (taskData.getOnLogicalCriticalPath()) {
            $this$taskDetailsPanelHtml_u24lambda_u2d1.add("This task frequently determines build duration because of dependencies").newline().add("between its inputs/outputs and other tasks.").newline();
        } else if (taskData.getOnExtendedCriticalPath()) {
            $this$taskDetailsPanelHtml_u24lambda_u2d1.add("This task occasionally determines build duration because of parallelism constraints").newline().add("introduced by number of cores or other tasks in the same module.").newline();
        }
        $this$taskDetailsPanelHtml_u24lambda_u2d1.newline();
        $this$taskDetailsPanelHtml_u24lambda_u2d1.addBold("Duration:").addHtml("  " + BuildAttributionUIUtilKt.durationStringHtml(taskData.getExecutionTime()) + " / " + BuildAttributionUIUtilKt.percentageStringHtml(taskData.getExecutionTime())).newline();
        $this$taskDetailsPanelHtml_u24lambda_u2d1.add("Sub-project: " + taskData.getModule()).newline();
        $this$taskDetailsPanelHtml_u24lambda_u2d1.addHtml("Plugin: " + BuildAttributionPanelsKt.pluginNameHtml(taskData)).newline();
        $this$taskDetailsPanelHtml_u24lambda_u2d1.add("Type: " + taskData.getTaskType()).newline();
        Object t = StudioFlags.BUILD_ANALYZER_CATEGORY_ANALYSIS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"BUILD_ANALYZER_CATEGORY_ANALYSIS.get()");
        if (((Boolean)t).booleanValue()) {
            List taskCategories = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)taskData.getPrimaryTaskCategory()), (Iterable)taskData.getSecondaryTaskCategories());
            $this$taskDetailsPanelHtml_u24lambda_u2d1.add("Task Execution Categories: " + CollectionsKt.joinToString$default((Iterable)taskCategories, null, null, null, (int)0, null, (Function1)taskDetailsPanelHtml.1.1.INSTANCE, (int)31, null)).newline();
        }
        $this$taskDetailsPanelHtml_u24lambda_u2d1.newline();
        BuildAttributionPanelsKt.createWarningsSection($this$taskDetailsPanelHtml_u24lambda_u2d1, taskData, actionHandlers, linksHandler);
        BuildAttributionPanelsKt.createReasonsSection($this$taskDetailsPanelHtml_u24lambda_u2d1, taskData.getReasonsToRun());
        String string = htmlBuilder.getHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder().apply {\n  \u2026ta.reasonsToRun)\n  }.html");
        return string;
    }

    private static final void createWarningsSection(HtmlBuilder $this$createWarningsSection, TaskUiData taskData, ViewActionHandlers actionHandlers, HtmlLinksHandler linksHandler) {
        $this$createWarningsSection.addBold("Warnings").newline();
        if (taskData.getIssues().isEmpty() && taskData.getRelatedTaskCategoryIssues().isEmpty()) {
            $this$createWarningsSection.add("No warnings found").newline();
            $this$createWarningsSection.newline();
        } else {
            if (taskData.getSourceType() != PluginSourceType.BUILD_SRC && !((Collection)taskData.getIssues()).isEmpty()) {
                String generateReportLink2 = linksHandler.actionLink("Generate report", "generateReport", new Runnable(actionHandlers, taskData){
                    final /* synthetic */ ViewActionHandlers $actionHandlers;
                    final /* synthetic */ TaskUiData $taskData;
                    {
                        this.$actionHandlers = $actionHandlers;
                        this.$taskData = $taskData;
                    }

                    public final void run() {
                        this.$actionHandlers.generateReportClicked(this.$taskData);
                    }
                });
                $this$createWarningsSection.addHtml("Consider filing a bug to report this issue to the plugin developer. " + generateReportLink2);
            }
            $this$createWarningsSection.beginTable();
            if (!((Collection)taskData.getRelatedTaskCategoryIssues()).isEmpty()) {
                String redirectLink2 = linksHandler.actionLink(BuildAttributionUIUtilKt.displayName(taskData.getPrimaryTaskCategory()), taskData.getPrimaryTaskCategory().name(), new Runnable(actionHandlers, taskData){
                    final /* synthetic */ ViewActionHandlers $actionHandlers;
                    final /* synthetic */ TaskUiData $taskData;
                    {
                        this.$actionHandlers = $actionHandlers;
                        this.$taskData = $taskData;
                    }

                    public final void run() {
                        this.$actionHandlers.redirectToTaskCategoryWarningsPage(this.$taskData.getPrimaryTaskCategory());
                    }
                });
                String[] stringArray = new String[]{"<icon alt='Warning' src='AllIcons.General.BalloonWarning'>", "This task is impacted by " + BuildAttributionUIUtilKt.withPluralization(taskData.getRelatedTaskCategoryIssues().size(), "issue") + " found in the " + redirectLink2 + " category."};
                $this$createWarningsSection.addTableRow(stringArray);
            }
            Iterable $this$forEach$iv = taskData.getIssues();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TaskIssueUiData issue2 = (TaskIssueUiData)element$iv;
                boolean bl = false;
                String description2 = issue2.getExplanation() + "\n" + linksHandler.externalLink("Learn more", issue2.getHelpLink());
                String[] stringArray = new String[]{"<icon alt='Warning' src='AllIcons.General.BalloonWarning'>", "<B>" + issue2.getType().getUiName() + "</B>"};
                $this$createWarningsSection.addTableRow(stringArray);
                stringArray = new String[]{"", StringsKt.replace$default((String)description2, (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null)};
                $this$createWarningsSection.addTableRow(stringArray);
                stringArray = new String[]{"", "<B>Recommendation:</B> " + StringsKt.replace$default((String)issue2.getBuildSrcRecommendation(), (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null)};
                $this$createWarningsSection.addTableRow(stringArray);
            }
            $this$createWarningsSection.endTable();
        }
    }

    private static final void createReasonsSection(HtmlBuilder $this$createReasonsSection, List<String> reasons) {
        $this$createReasonsSection.addBold("Reason task ran").newline();
        if (reasons.isEmpty()) {
            $this$createReasonsSection.add("No info");
        } else {
            Iterable $this$forEach$iv = reasons;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                $this$createReasonsSection.addHtml(StringsKt.replace$default((String)it, (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null)).newline();
            }
        }
    }
}

