/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskIssueType;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.model.WarningsFilter;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&BA\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\bH\u00c6\u0003JQ\u0010\u001e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\b2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u0006\u0010%\u001a\u00020$R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006'"}, d2={"Lcom/android/build/attribution/ui/model/WarningsFilter;", "", "showTaskSourceTypes", "", "Lcom/android/build/attribution/ui/data/PluginSourceType;", "showTaskWarningTypes", "Lcom/android/build/attribution/ui/data/TaskIssueType;", "showAnnotationProcessorWarnings", "", "showNonCriticalPathTasks", "showConfigurationCacheWarnings", "showJetifierWarnings", "(Ljava/util/Set;Ljava/util/Set;ZZZZ)V", "getShowAnnotationProcessorWarnings", "()Z", "getShowConfigurationCacheWarnings", "getShowJetifierWarnings", "getShowNonCriticalPathTasks", "getShowTaskSourceTypes", "()Ljava/util/Set;", "getShowTaskWarningTypes", "acceptTaskIssue", "issueData", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "toUiText", "Companion", "intellij.android.build-attribution"})
public final class WarningsFilter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<PluginSourceType> showTaskSourceTypes;
    @NotNull
    private final Set<TaskIssueType> showTaskWarningTypes;
    private final boolean showAnnotationProcessorWarnings;
    private final boolean showNonCriticalPathTasks;
    private final boolean showConfigurationCacheWarnings;
    private final boolean showJetifierWarnings;
    @NotNull
    private static final WarningsFilter DEFAULT;

    public WarningsFilter(@NotNull Set<? extends PluginSourceType> showTaskSourceTypes, @NotNull Set<? extends TaskIssueType> showTaskWarningTypes, boolean showAnnotationProcessorWarnings, boolean showNonCriticalPathTasks, boolean showConfigurationCacheWarnings, boolean showJetifierWarnings) {
        Intrinsics.checkNotNullParameter(showTaskSourceTypes, (String)"showTaskSourceTypes");
        Intrinsics.checkNotNullParameter(showTaskWarningTypes, (String)"showTaskWarningTypes");
        this.showTaskSourceTypes = showTaskSourceTypes;
        this.showTaskWarningTypes = showTaskWarningTypes;
        this.showAnnotationProcessorWarnings = showAnnotationProcessorWarnings;
        this.showNonCriticalPathTasks = showNonCriticalPathTasks;
        this.showConfigurationCacheWarnings = showConfigurationCacheWarnings;
        this.showJetifierWarnings = showJetifierWarnings;
    }

    @NotNull
    public final Set<PluginSourceType> getShowTaskSourceTypes() {
        return this.showTaskSourceTypes;
    }

    @NotNull
    public final Set<TaskIssueType> getShowTaskWarningTypes() {
        return this.showTaskWarningTypes;
    }

    public final boolean getShowAnnotationProcessorWarnings() {
        return this.showAnnotationProcessorWarnings;
    }

    public final boolean getShowNonCriticalPathTasks() {
        return this.showNonCriticalPathTasks;
    }

    public final boolean getShowConfigurationCacheWarnings() {
        return this.showConfigurationCacheWarnings;
    }

    public final boolean getShowJetifierWarnings() {
        return this.showJetifierWarnings;
    }

    public final boolean acceptTaskIssue(@NotNull TaskIssueUiData issueData) {
        Intrinsics.checkNotNullParameter((Object)issueData, (String)"issueData");
        return this.showTaskWarningTypes.contains((Object)issueData.getType()) && this.showTaskSourceTypes.contains((Object)issueData.getTask().getSourceType()) && (this.showNonCriticalPathTasks || issueData.getTask().getOnExtendedCriticalPath());
    }

    @NotNull
    public final String toUiText() {
        String taskWarningsPart = this.showTaskSourceTypes.isEmpty() || this.showTaskWarningTypes.isEmpty() ? "" : (this.showTaskSourceTypes.containsAll(ArraysKt.asList((Object[])PluginSourceType.values())) && this.showTaskWarningTypes.containsAll(ArraysKt.asList((Object[])TaskIssueType.values())) ? "All task warnings" : "Selected types of task warnings");
        String annotationProcessorsPart = this.showAnnotationProcessorWarnings ? "Annotation processors" : "";
        String configurationCachePart = this.showConfigurationCacheWarnings ? "Configuration cache" : "";
        String jetifierPart = this.showJetifierWarnings ? "Jetifier" : "";
        Object object = new String[]{taskWarningsPart, annotationProcessorsPart, configurationCachePart, jetifierPart};
        Object it = object = SequencesKt.joinToString$default((Sequence)SequencesKt.filter((Sequence)SequencesKt.sequenceOf((Object[])object), (Function1)toUiText.1.INSTANCE), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        boolean bl = false;
        Object object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object : null;
        if (object2 == null) {
            object2 = "Nothing selected";
        }
        return object2;
    }

    @NotNull
    public final Set<PluginSourceType> component1() {
        return this.showTaskSourceTypes;
    }

    @NotNull
    public final Set<TaskIssueType> component2() {
        return this.showTaskWarningTypes;
    }

    public final boolean component3() {
        return this.showAnnotationProcessorWarnings;
    }

    public final boolean component4() {
        return this.showNonCriticalPathTasks;
    }

    public final boolean component5() {
        return this.showConfigurationCacheWarnings;
    }

    public final boolean component6() {
        return this.showJetifierWarnings;
    }

    @NotNull
    public final WarningsFilter copy(@NotNull Set<? extends PluginSourceType> showTaskSourceTypes, @NotNull Set<? extends TaskIssueType> showTaskWarningTypes, boolean showAnnotationProcessorWarnings, boolean showNonCriticalPathTasks, boolean showConfigurationCacheWarnings, boolean showJetifierWarnings) {
        Intrinsics.checkNotNullParameter(showTaskSourceTypes, (String)"showTaskSourceTypes");
        Intrinsics.checkNotNullParameter(showTaskWarningTypes, (String)"showTaskWarningTypes");
        return new WarningsFilter(showTaskSourceTypes, showTaskWarningTypes, showAnnotationProcessorWarnings, showNonCriticalPathTasks, showConfigurationCacheWarnings, showJetifierWarnings);
    }

    public static /* synthetic */ WarningsFilter copy$default(WarningsFilter warningsFilter, Set set, Set set2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            set = warningsFilter.showTaskSourceTypes;
        }
        if ((n & 2) != 0) {
            set2 = warningsFilter.showTaskWarningTypes;
        }
        if ((n & 4) != 0) {
            bl = warningsFilter.showAnnotationProcessorWarnings;
        }
        if ((n & 8) != 0) {
            bl2 = warningsFilter.showNonCriticalPathTasks;
        }
        if ((n & 0x10) != 0) {
            bl3 = warningsFilter.showConfigurationCacheWarnings;
        }
        if ((n & 0x20) != 0) {
            bl4 = warningsFilter.showJetifierWarnings;
        }
        return warningsFilter.copy(set, set2, bl, bl2, bl3, bl4);
    }

    @NotNull
    public String toString() {
        return "WarningsFilter(showTaskSourceTypes=" + this.showTaskSourceTypes + ", showTaskWarningTypes=" + this.showTaskWarningTypes + ", showAnnotationProcessorWarnings=" + this.showAnnotationProcessorWarnings + ", showNonCriticalPathTasks=" + this.showNonCriticalPathTasks + ", showConfigurationCacheWarnings=" + this.showConfigurationCacheWarnings + ", showJetifierWarnings=" + this.showJetifierWarnings + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.showTaskSourceTypes).hashCode();
        result2 = result2 * 31 + ((Object)this.showTaskWarningTypes).hashCode();
        int n = this.showAnnotationProcessorWarnings ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        int n2 = this.showNonCriticalPathTasks ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        int n3 = this.showConfigurationCacheWarnings ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result2 = result2 * 31 + n3;
        int n4 = this.showJetifierWarnings ? 1 : 0;
        if (n4 != 0) {
            n4 = 1;
        }
        result2 = result2 * 31 + n4;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WarningsFilter)) {
            return false;
        }
        WarningsFilter warningsFilter = (WarningsFilter)other;
        if (!Intrinsics.areEqual(this.showTaskSourceTypes, warningsFilter.showTaskSourceTypes)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.showTaskWarningTypes, warningsFilter.showTaskWarningTypes)) {
            return false;
        }
        if (this.showAnnotationProcessorWarnings != warningsFilter.showAnnotationProcessorWarnings) {
            return false;
        }
        if (this.showNonCriticalPathTasks != warningsFilter.showNonCriticalPathTasks) {
            return false;
        }
        if (this.showConfigurationCacheWarnings != warningsFilter.showConfigurationCacheWarnings) {
            return false;
        }
        return this.showJetifierWarnings == warningsFilter.showJetifierWarnings;
    }

    static {
        Enum[] enumArray = new PluginSourceType[]{PluginSourceType.ANDROID_PLUGIN, PluginSourceType.THIRD_PARTY, PluginSourceType.BUILD_SRC};
        Set set = SetsKt.setOf((Object[])enumArray);
        enumArray = new TaskIssueType[]{TaskIssueType.ALWAYS_RUN_TASKS, TaskIssueType.TASK_SETUP_ISSUE};
        DEFAULT = new WarningsFilter(set, SetsKt.setOf((Object[])enumArray), true, false, true, true);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/build/attribution/ui/model/WarningsFilter$Companion;", "", "()V", "DEFAULT", "Lcom/android/build/attribution/ui/model/WarningsFilter;", "getDEFAULT", "()Lcom/android/build/attribution/ui/model/WarningsFilter;", "intellij.android.build-attribution"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WarningsFilter getDEFAULT() {
            return DEFAULT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

