/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.model.WarningsDataPageModelKt;
import com.android.build.attribution.ui.model.WarningsPageId;
import com.android.build.attribution.ui.model.WarningsTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.view.BuildAnalyzerTreeNodePresentation;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/android/build/attribution/ui/model/TaskUnderPluginDetailsNodeDescriptor;", "Lcom/android/build/attribution/ui/model/WarningsTreePresentableNodeDescriptor;", "taskData", "Lcom/android/build/attribution/ui/data/TaskUiData;", "filteredWarnings", "", "Lcom/android/build/attribution/ui/data/TaskIssueUiData;", "(Lcom/android/build/attribution/ui/data/TaskUiData;Ljava/util/List;)V", "analyticsPageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getAnalyticsPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "executionTimeMs", "", "getExecutionTimeMs", "()Ljava/lang/Long;", "getFilteredWarnings", "()Ljava/util/List;", "pageId", "Lcom/android/build/attribution/ui/model/WarningsPageId;", "getPageId", "()Lcom/android/build/attribution/ui/model/WarningsPageId;", "presentation", "Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getPresentation", "()Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getTaskData", "()Lcom/android/build/attribution/ui/data/TaskUiData;", "intellij.android.build-attribution"})
public final class TaskUnderPluginDetailsNodeDescriptor
extends WarningsTreePresentableNodeDescriptor {
    @NotNull
    private final TaskUiData taskData;
    @NotNull
    private final List<TaskIssueUiData> filteredWarnings;
    @NotNull
    private final WarningsPageId pageId;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType analyticsPageType;
    private final long executionTimeMs;

    public TaskUnderPluginDetailsNodeDescriptor(@NotNull TaskUiData taskData, @NotNull List<? extends TaskIssueUiData> filteredWarnings) {
        Intrinsics.checkNotNullParameter((Object)taskData, (String)"taskData");
        Intrinsics.checkNotNullParameter(filteredWarnings, (String)"filteredWarnings");
        super(null);
        this.taskData = taskData;
        this.filteredWarnings = filteredWarnings;
        this.pageId = WarningsPageId.Companion.task(this.taskData);
        this.analyticsPageType = BuildAttributionUiEvent.Page.PageType.PLUGIN_TASK_WARNINGS;
        this.executionTimeMs = this.taskData.getExecutionTime().getTimeMs();
    }

    @NotNull
    public final TaskUiData getTaskData() {
        return this.taskData;
    }

    @NotNull
    public final List<TaskIssueUiData> getFilteredWarnings() {
        return this.filteredWarnings;
    }

    @Override
    @NotNull
    public WarningsPageId getPageId() {
        return this.pageId;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getAnalyticsPageType() {
        return this.analyticsPageType;
    }

    @Override
    @NotNull
    public BuildAnalyzerTreeNodePresentation getPresentation() {
        String string = this.taskData.getTaskPath();
        BuildAnalyzerTreeNodePresentation.NodeIconState nodeIconState = BuildAnalyzerTreeNodePresentation.NodeIconState.WARNING_ICON;
        String string2 = BuildAttributionUIUtilKt.warningsCountString(this.filteredWarnings.size());
        String string3 = WarningsDataPageModelKt.access$rightAlignedNodeDurationTextFromMs(this.getExecutionTimeMs());
        return new BuildAnalyzerTreeNodePresentation(string, string2, string3, nodeIconState);
    }

    @Override
    @NotNull
    public Long getExecutionTimeMs() {
        return this.executionTimeMs;
    }
}

