/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.model.MyCellRenderer;
import com.android.build.attribution.ui.model.MyWarningIconCellRenderer;
import com.android.build.attribution.ui.model.RequestsListTableModel;
import com.intellij.openapi.util.text.Formats;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.Comparator;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/android/build/attribution/ui/model/RequestsListTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "()V", "intellij.android.build-attribution"})
public final class RequestsListTableModel
extends ListTableModel<DownloadsAnalyzer.DownloadResult> {
    public RequestsListTableModel() {
        super(new ColumnInfo[0]);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{(ColumnInfo)new ColumnInfo<DownloadsAnalyzer.DownloadResult, DownloadsAnalyzer.DownloadResult>(){
            @NotNull
            private final MyWarningIconCellRenderer cellRenderer = new MyWarningIconCellRenderer();

            @NotNull
            public final MyWarningIconCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public DownloadsAnalyzer.DownloadResult valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return item2;
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "Not Found";
            }

            @NotNull
            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            public int getAdditionalWidth() {
                return BuildAttributionUIUtilKt.warningIcon().getIconWidth();
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.status }");
                return comparator2;
            }
        }, (ColumnInfo)new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            @NotNull
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            @NotNull
            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public String valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return item2.getUrl();
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.url }");
                return comparator2;
            }
        }, (ColumnInfo)new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            @NotNull
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            @NotNull
            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public String valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return BuildAttributionUIUtilKt.durationString(item2.getDuration());
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "###.#s";
            }

            @NotNull
            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.duration }");
                return comparator2;
            }
        }, (ColumnInfo)new ColumnInfo<DownloadsAnalyzer.DownloadResult, String>(){
            @NotNull
            private final MyCellRenderer cellRenderer;
            {
                SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
                this.cellRenderer = new MyCellRenderer(simpleTextAttributes);
            }

            @NotNull
            public final MyCellRenderer getCellRenderer() {
                return this.cellRenderer;
            }

            @NotNull
            public String valueOf(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                String string = Formats.formatFileSize((long)item2.getBytes());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(item.bytes)");
                return string;
            }

            @NotNull
            public TableCellRenderer getRenderer(@NotNull DownloadsAnalyzer.DownloadResult item2) {
                Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
                return (TableCellRenderer)((Object)this.cellRenderer);
            }

            @NotNull
            public String getPreferredStringValue() {
                return "123.45MB";
            }

            @NotNull
            public String getMaxStringValue() {
                return this.getPreferredStringValue();
            }

            @NotNull
            public Comparator<DownloadsAnalyzer.DownloadResult> getComparator() {
                Comparator<DownloadsAnalyzer.DownloadResult> comparator2 = Comparator.comparing(getComparator.1.INSTANCE);
                Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing { it.bytes }");
                return comparator2;
            }
        }};
        this.setColumnInfos(columnInfoArray);
        this.setSortable(true);
    }
}

