/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.model.RepositoriesTableModel;
import com.intellij.openapi.util.text.Formats;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0002H\u0002J\f\u0010\b\u001a\u00020\t*\u00020\u0002H\u0002J\f\u0010\n\u001a\u00020\t*\u00020\u0002H\u0002J\f\u0010\u000b\u001a\u00020\t*\u00020\u0002H\u0002J\f\u0010\f\u001a\u00020\u0007*\u00020\u0002H\u0002\u00a8\u0006\r"}, d2={"Lcom/android/build/attribution/ui/model/RepositoriesTableModel;", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "result", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "(Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;)V", "numberOfFailed", "", "timeOfFailed", "", "totalAmountOfData", "totalAmountOfTime", "totalNumberOfRequests", "intellij.android.build-attribution"})
final class RepositoriesTableModel
extends ListTableModel<DownloadsAnalyzer.RepositoryResult> {
    public RepositoriesTableModel(@NotNull DownloadsAnalyzer.Result result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        super(new ColumnInfo[0]);
        column.1[] nullArray = new column.1[]{RepositoriesTableModel._init_$column$default("Repository", null, 1.INSTANCE, 2, null), RepositoriesTableModel._init_$column("Requests", "Total number of requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)new Function1<DownloadsAnalyzer.RepositoryResult, String>(){

            @NotNull
            public final String invoke(@NotNull DownloadsAnalyzer.RepositoryResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return String.valueOf(this.totalNumberOfRequests(it));
            }
        })), RepositoriesTableModel._init_$column("Data", "Total amount of data downloaded.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)new Function1<DownloadsAnalyzer.RepositoryResult, String>(){

            @NotNull
            public final String invoke(@NotNull DownloadsAnalyzer.RepositoryResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = Formats.formatFileSize((long)this.totalAmountOfData(it));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(it.totalAmountOfData())");
                return string;
            }
        })), RepositoriesTableModel._init_$column("Time", "Total amount of time taken to execute requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)new Function1<DownloadsAnalyzer.RepositoryResult, String>(){

            @NotNull
            public final String invoke(@NotNull DownloadsAnalyzer.RepositoryResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return BuildAttributionUIUtilKt.durationString(this.totalAmountOfTime(it));
            }
        })), RepositoriesTableModel._init_$column("Failed Requests", "Number of failed requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)new Function1<DownloadsAnalyzer.RepositoryResult, String>(){

            @NotNull
            public final String invoke(@NotNull DownloadsAnalyzer.RepositoryResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return String.valueOf(this.numberOfFailed(it));
            }
        })), RepositoriesTableModel._init_$column("Failed Requests Time", "Total amount of time taken to execute failed requests.", (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)((Function1)new Function1<DownloadsAnalyzer.RepositoryResult, String>(){

            @NotNull
            public final String invoke(@NotNull DownloadsAnalyzer.RepositoryResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return BuildAttributionUIUtilKt.durationString(this.timeOfFailed(it));
            }
        }))};
        this.setColumnInfos(nullArray);
        Object object = result2 instanceof DownloadsAnalyzer.ActiveResult ? (DownloadsAnalyzer.ActiveResult)result2 : null;
        if (object == null || (object = ((DownloadsAnalyzer.ActiveResult)object).getRepositoryResults()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.setItems((List)object);
    }

    private final int totalNumberOfRequests(DownloadsAnalyzer.RepositoryResult $this$totalNumberOfRequests) {
        return $this$totalNumberOfRequests.getSuccessRequestsCount() + $this$totalNumberOfRequests.getFailedRequestsCount() + $this$totalNumberOfRequests.getMissedRequestsCount();
    }

    private final long totalAmountOfData(DownloadsAnalyzer.RepositoryResult $this$totalAmountOfData) {
        return $this$totalAmountOfData.getSuccessRequestsBytesDownloaded() + $this$totalAmountOfData.getFailedRequestsBytesDownloaded();
    }

    private final long totalAmountOfTime(DownloadsAnalyzer.RepositoryResult $this$totalAmountOfTime) {
        return $this$totalAmountOfTime.getSuccessRequestsTimeMs() + $this$totalAmountOfTime.getFailedRequestsTimeMs() + $this$totalAmountOfTime.getMissedRequestsTimeMs();
    }

    private final int numberOfFailed(DownloadsAnalyzer.RepositoryResult $this$numberOfFailed) {
        return $this$numberOfFailed.getFailedRequestsCount() + $this$numberOfFailed.getMissedRequestsCount();
    }

    private final long timeOfFailed(DownloadsAnalyzer.RepositoryResult $this$timeOfFailed) {
        return $this$timeOfFailed.getFailedRequestsTimeMs() + $this$timeOfFailed.getMissedRequestsTimeMs();
    }

    private static final column.1 _init_$column(String title, String tooltip2, Function1<? super DownloadsAnalyzer.RepositoryResult, String> valueOf) {
        return new ColumnInfo<DownloadsAnalyzer.RepositoryResult, String>(title, valueOf, tooltip2){
            final /* synthetic */ String $title;
            final /* synthetic */ Function1<DownloadsAnalyzer.RepositoryResult, String> $valueOf;
            final /* synthetic */ String $tooltip;
            {
                this.$title = $title;
                this.$valueOf = $valueOf;
                this.$tooltip = $tooltip;
                super($title);
            }

            @NotNull
            public String valueOf(@NotNull DownloadsAnalyzer.RepositoryResult found) {
                Intrinsics.checkNotNullParameter((Object)found, (String)"found");
                return (String)this.$valueOf.invoke((Object)found);
            }

            @NotNull
            public String getPreferredStringValue() {
                return this.$title;
            }

            @Nullable
            public String getTooltipText() {
                return this.$tooltip;
            }
        };
    }

    static /* synthetic */ column.1 _init_$column$default(String string, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return RepositoriesTableModel._init_$column(string, string2, (Function1<? super DownloadsAnalyzer.RepositoryResult, String>)function1);
    }
}

