/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.analyzers.AGPUpdateRequired;
import com.android.build.attribution.analyzers.ConfigurationCacheCompatibilityTestFlow;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOff;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOn;
import com.android.build.attribution.analyzers.IncompatiblePluginsDetected;
import com.android.build.attribution.analyzers.NoDataFromSavedResult;
import com.android.build.attribution.analyzers.NoIncompatiblePlugins;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.model.WarningsDataPageModelKt;
import com.android.build.attribution.ui.model.WarningsPageId;
import com.android.build.attribution.ui.model.WarningsTreePresentableNodeDescriptor;
import com.android.build.attribution.ui.view.BuildAnalyzerTreeNodePresentation;
import com.google.wireless.android.sdk.stats.BuildAttributionUiEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/android/build/attribution/ui/model/ConfigurationCachingRootNodeDescriptor;", "Lcom/android/build/attribution/ui/model/WarningsTreePresentableNodeDescriptor;", "data", "Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;", "projectConfigurationTime", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "(Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;Lcom/android/build/attribution/ui/data/TimeWithPercentage;)V", "analyticsPageType", "Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getAnalyticsPageType", "()Lcom/google/wireless/android/sdk/stats/BuildAttributionUiEvent$Page$PageType;", "getData", "()Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;", "executionTimeMs", "", "getExecutionTimeMs", "()Ljava/lang/Long;", "pageId", "Lcom/android/build/attribution/ui/model/WarningsPageId;", "getPageId", "()Lcom/android/build/attribution/ui/model/WarningsPageId;", "presentation", "Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getPresentation", "()Lcom/android/build/attribution/ui/view/BuildAnalyzerTreeNodePresentation;", "getProjectConfigurationTime", "()Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "intellij.android.build-attribution"})
public final class ConfigurationCachingRootNodeDescriptor
extends WarningsTreePresentableNodeDescriptor {
    @NotNull
    private final ConfigurationCachingCompatibilityProjectResult data;
    @NotNull
    private final TimeWithPercentage projectConfigurationTime;
    @NotNull
    private final WarningsPageId pageId;
    @NotNull
    private final BuildAttributionUiEvent.Page.PageType analyticsPageType;
    private final long executionTimeMs;

    public ConfigurationCachingRootNodeDescriptor(@NotNull ConfigurationCachingCompatibilityProjectResult data2, @NotNull TimeWithPercentage projectConfigurationTime) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)projectConfigurationTime, (String)"projectConfigurationTime");
        super(null);
        this.data = data2;
        this.projectConfigurationTime = projectConfigurationTime;
        this.pageId = WarningsPageId.Companion.getConfigurationCachingRoot();
        this.analyticsPageType = BuildAttributionUiEvent.Page.PageType.CONFIGURATION_CACHE_ROOT;
        this.executionTimeMs = this.projectConfigurationTime.getTimeMs();
    }

    @NotNull
    public final ConfigurationCachingCompatibilityProjectResult getData() {
        return this.data;
    }

    @NotNull
    public final TimeWithPercentage getProjectConfigurationTime() {
        return this.projectConfigurationTime;
    }

    @Override
    @NotNull
    public WarningsPageId getPageId() {
        return this.pageId;
    }

    @Override
    @NotNull
    public BuildAttributionUiEvent.Page.PageType getAnalyticsPageType() {
        return this.analyticsPageType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BuildAnalyzerTreeNodePresentation getPresentation() {
        Object object;
        String string = "Configuration cache";
        ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityProjectResult = this.data;
        if (configurationCachingCompatibilityProjectResult instanceof AGPUpdateRequired) {
            object = "Android Gradle plugin update required";
        } else if (configurationCachingCompatibilityProjectResult instanceof IncompatiblePluginsDetected) {
            Object object2;
            void it;
            int n = ((IncompatiblePluginsDetected)this.data).getUpgradePluginWarnings().size();
            String string2 = string;
            boolean bl = false;
            switch (it) {
                case 0: {
                    object2 = "";
                    break;
                }
                case 1: {
                    object2 = "1 plugin requires update";
                    break;
                }
                default: {
                    object2 = (int)it + " plugins require update";
                }
            }
            object = object2;
            string = string2;
        } else if (configurationCachingCompatibilityProjectResult instanceof NoIncompatiblePlugins) {
            object = "";
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)ConfigurationCachingTurnedOn.INSTANCE)) {
            object = "";
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)ConfigurationCacheCompatibilityTestFlow.INSTANCE)) {
            object = "";
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)ConfigurationCachingTurnedOff.INSTANCE)) {
            object = "";
        } else if (Intrinsics.areEqual((Object)configurationCachingCompatibilityProjectResult, (Object)NoDataFromSavedResult.INSTANCE)) {
            object = "";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 8;
        BuildAnalyzerTreeNodePresentation.NodeIconState nodeIconState = null;
        String string3 = WarningsDataPageModelKt.access$rightAlignedNodeDurationTextFromMs(this.getExecutionTimeMs());
        String string4 = object;
        String string5 = string;
        return new BuildAnalyzerTreeNodePresentation(string5, string4, string3, nodeIconState, n, defaultConstructorMarker);
    }

    @Override
    @NotNull
    public Long getExecutionTimeMs() {
        return this.executionTimeMs;
    }
}

