/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.DownloadsSummaryUIData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "", "reportUiData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "warningSuppressions", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lcom/android/build/attribution/BuildAttributionWarningsFilter;)V", "downloadsSummaryUiData", "Lcom/android/build/attribution/ui/data/DownloadsSummaryUIData;", "getDownloadsSummaryUiData", "()Lcom/android/build/attribution/ui/data/DownloadsSummaryUIData;", "getReportUiData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "shouldWarnAboutGC", "", "getShouldWarnAboutGC", "()Z", "shouldWarnAboutNoGCSetting", "getShouldWarnAboutNoGCSetting", "getWarningSuppressions", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "intellij.android.build-attribution"})
public final class BuildOverviewPageModel {
    @NotNull
    private final BuildAttributionReportUiData reportUiData;
    @NotNull
    private final BuildAttributionWarningsFilter warningSuppressions;

    public BuildOverviewPageModel(@NotNull BuildAttributionReportUiData reportUiData, @NotNull BuildAttributionWarningsFilter warningSuppressions) {
        Intrinsics.checkNotNullParameter((Object)reportUiData, (String)"reportUiData");
        Intrinsics.checkNotNullParameter((Object)warningSuppressions, (String)"warningSuppressions");
        this.reportUiData = reportUiData;
        this.warningSuppressions = warningSuppressions;
    }

    @NotNull
    public final BuildAttributionReportUiData getReportUiData() {
        return this.reportUiData;
    }

    @NotNull
    public final BuildAttributionWarningsFilter getWarningSuppressions() {
        return this.warningSuppressions;
    }

    public final boolean getShouldWarnAboutGC() {
        return this.reportUiData.getBuildSummary().getGarbageCollectionTime().getPercentage() > 10.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean getShouldWarnAboutNoGCSetting() {
        if (this.warningSuppressions.getSuppressNoGCSettingWarning()) return false;
        if (!Intrinsics.areEqual((Object)this.reportUiData.getBuildSummary().isGarbageCollectorSettingSet(), (Object)false)) return false;
        Integer n = this.reportUiData.getBuildSummary().getJavaVersionUsed();
        if (n == null) return false;
        int it = ((Number)n).intValue();
        boolean bl = false;
        if (it < 9) return false;
        return true;
    }

    @Nullable
    public final DownloadsSummaryUIData getDownloadsSummaryUiData() {
        DownloadsSummaryUIData downloadsSummaryUIData;
        DownloadsAnalyzer.Result result2 = this.reportUiData.getDownloadsData();
        DownloadsAnalyzer.ActiveResult activeResult = result2 instanceof DownloadsAnalyzer.ActiveResult ? (DownloadsAnalyzer.ActiveResult)result2 : null;
        if (activeResult != null) {
            DownloadsAnalyzer.ActiveResult it = activeResult;
            boolean bl = false;
            downloadsSummaryUIData = new DownloadsSummaryUIData(it);
        } else {
            downloadsSummaryUIData = null;
        }
        return downloadsSummaryUIData;
    }
}

