/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.model;

import com.android.build.attribution.BuildAttributionWarningsFilter;
import com.android.build.attribution.analyzers.DownloadsAnalyzer;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.model.BuildOverviewPageModel;
import com.android.build.attribution.ui.model.DownloadsInfoPageModel;
import com.android.build.attribution.ui.model.TasksDataPageModel;
import com.android.build.attribution.ui.model.TasksDataPageModelImpl;
import com.android.build.attribution.ui.model.WarningsDataPageModel;
import com.android.build.attribution.ui.model.WarningsDataPageModelImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001-B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel;", "", "reportUiData", "Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "warningSuppressions", "Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "(Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;Lcom/android/build/attribution/BuildAttributionWarningsFilter;)V", "availableDataSets", "", "Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;", "getAvailableDataSets", "()Ljava/util/List;", "dataSetSelectionListener", "Lkotlin/Function0;", "", "getDataSetSelectionListener", "()Lkotlin/jvm/functions/Function0;", "setDataSetSelectionListener", "(Lkotlin/jvm/functions/Function0;)V", "downloadsInfoPageModel", "Lcom/android/build/attribution/ui/model/DownloadsInfoPageModel;", "getDownloadsInfoPageModel", "()Lcom/android/build/attribution/ui/model/DownloadsInfoPageModel;", "overviewPageModel", "Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "getOverviewPageModel", "()Lcom/android/build/attribution/ui/model/BuildOverviewPageModel;", "getReportUiData", "()Lcom/android/build/attribution/ui/data/BuildAttributionReportUiData;", "value", "selectedData", "getSelectedData", "()Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;", "setSelectedData", "(Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;)V", "tasksPageModel", "Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "getTasksPageModel", "()Lcom/android/build/attribution/ui/model/TasksDataPageModel;", "getWarningSuppressions", "()Lcom/android/build/attribution/BuildAttributionWarningsFilter;", "warningsPageModel", "Lcom/android/build/attribution/ui/model/WarningsDataPageModel;", "getWarningsPageModel", "()Lcom/android/build/attribution/ui/model/WarningsDataPageModel;", "DataSet", "intellij.android.build-attribution"})
public final class BuildAnalyzerViewModel {
    @NotNull
    private final BuildAttributionReportUiData reportUiData;
    @NotNull
    private final BuildAttributionWarningsFilter warningSuppressions;
    @Nullable
    private Function0<Unit> dataSetSelectionListener;
    @NotNull
    private DataSet selectedData;
    @NotNull
    private final BuildOverviewPageModel overviewPageModel;
    @NotNull
    private final TasksDataPageModel tasksPageModel;
    @NotNull
    private final WarningsDataPageModel warningsPageModel;
    @NotNull
    private final DownloadsInfoPageModel downloadsInfoPageModel;

    public BuildAnalyzerViewModel(@NotNull BuildAttributionReportUiData reportUiData, @NotNull BuildAttributionWarningsFilter warningSuppressions) {
        Intrinsics.checkNotNullParameter((Object)reportUiData, (String)"reportUiData");
        Intrinsics.checkNotNullParameter((Object)warningSuppressions, (String)"warningSuppressions");
        this.reportUiData = reportUiData;
        this.warningSuppressions = warningSuppressions;
        this.selectedData = this.reportUiData.getJetifierData().getCheckJetifierBuild() ? DataSet.WARNINGS : DataSet.OVERVIEW;
        this.overviewPageModel = new BuildOverviewPageModel(this.reportUiData, this.warningSuppressions);
        this.tasksPageModel = new TasksDataPageModelImpl(this.reportUiData);
        this.warningsPageModel = new WarningsDataPageModelImpl(this.reportUiData);
        this.downloadsInfoPageModel = new DownloadsInfoPageModel(this.reportUiData.getDownloadsData());
    }

    @NotNull
    public final BuildAttributionReportUiData getReportUiData() {
        return this.reportUiData;
    }

    @NotNull
    public final BuildAttributionWarningsFilter getWarningSuppressions() {
        return this.warningSuppressions;
    }

    @NotNull
    public final List<DataSet> getAvailableDataSets() {
        DataSet dataSet;
        DataSet[] dataSetArray = new DataSet[4];
        dataSetArray[0] = DataSet.OVERVIEW;
        dataSetArray[1] = DataSet.TASKS;
        dataSetArray[2] = DataSet.WARNINGS;
        DataSet[] dataSetArray2 = dataSetArray;
        int n = 3;
        boolean $this$ifTrue$iv = !Intrinsics.areEqual((Object)this.reportUiData.getDownloadsData(), (Object)DownloadsAnalyzer.AnalyzerIsDisabled.INSTANCE);
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            int n2 = n;
            DataSet[] dataSetArray3 = dataSetArray2;
            boolean bl = false;
            DataSet dataSet2 = DataSet.DOWNLOADS;
            dataSetArray2 = dataSetArray3;
            n = n2;
            dataSet = dataSet2;
        } else {
            dataSet = null;
        }
        dataSetArray2[n] = dataSet;
        return CollectionsKt.listOfNotNull((Object[])dataSetArray);
    }

    @Nullable
    public final Function0<Unit> getDataSetSelectionListener() {
        return this.dataSetSelectionListener;
    }

    public final void setDataSetSelectionListener(@Nullable Function0<Unit> function0) {
        this.dataSetSelectionListener = function0;
    }

    @NotNull
    public final DataSet getSelectedData() {
        return this.selectedData;
    }

    public final void setSelectedData(@NotNull DataSet value2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            if (value2 == this.selectedData) break block1;
            this.selectedData = value2;
            Function0<Unit> function0 = this.dataSetSelectionListener;
            if (function0 != null) {
                function0.invoke();
            }
        }
    }

    @NotNull
    public final BuildOverviewPageModel getOverviewPageModel() {
        return this.overviewPageModel;
    }

    @NotNull
    public final TasksDataPageModel getTasksPageModel() {
        return this.tasksPageModel;
    }

    @NotNull
    public final WarningsDataPageModel getWarningsPageModel() {
        return this.warningsPageModel;
    }

    @NotNull
    public final DownloadsInfoPageModel getDownloadsInfoPageModel() {
        return this.downloadsInfoPageModel;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/android/build/attribution/ui/model/BuildAnalyzerViewModel$DataSet;", "", "uiName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getUiName", "()Ljava/lang/String;", "OVERVIEW", "TASKS", "WARNINGS", "DOWNLOADS", "intellij.android.build-attribution"})
    public static final class DataSet
    extends Enum<DataSet> {
        @NotNull
        private final String uiName;
        public static final /* enum */ DataSet OVERVIEW = new DataSet("Overview");
        public static final /* enum */ DataSet TASKS = new DataSet("Tasks");
        public static final /* enum */ DataSet WARNINGS = new DataSet("Warnings");
        public static final /* enum */ DataSet DOWNLOADS = new DataSet("Downloads");
        private static final /* synthetic */ DataSet[] $VALUES;

        private DataSet(String uiName) {
            this.uiName = uiName;
        }

        @NotNull
        public final String getUiName() {
            return this.uiName;
        }

        public static DataSet[] values() {
            return (DataSet[])$VALUES.clone();
        }

        public static DataSet valueOf(String value2) {
            return Enum.valueOf(DataSet.class, value2);
        }

        static {
            $VALUES = dataSetArray = new DataSet[]{DataSet.OVERVIEW, DataSet.TASKS, DataSet.WARNINGS, DataSet.DOWNLOADS};
        }
    }
}

