/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui.data.builder;

import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.TaskData;
import com.android.build.attribution.ui.data.PluginSourceType;
import com.android.build.attribution.ui.data.TaskCategoryIssueUiData;
import com.android.build.attribution.ui.data.TaskIssueUiData;
import com.android.build.attribution.ui.data.TaskUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.data.builder.TaskCategoryIssueUiDataContainer;
import com.android.build.attribution.ui.data.builder.TaskIssueUiDataContainer;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/build/attribution/ui/data/builder/TaskUiDataContainer;", "", "buildAnalysisResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;", "issuesContainer", "Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "taskCategoryIssuesContainer", "Lcom/android/build/attribution/ui/data/builder/TaskCategoryIssueUiDataContainer;", "criticalPathDuration", "", "(Lcom/android/build/attribution/analyzers/BuildEventsAnalysisResult;Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;Lcom/android/build/attribution/ui/data/builder/TaskCategoryIssueUiDataContainer;J)V", "configurationCacheUsed", "", "getIssuesContainer", "()Lcom/android/build/attribution/ui/data/builder/TaskIssueUiDataContainer;", "getTaskCategoryIssuesContainer", "()Lcom/android/build/attribution/ui/data/builder/TaskCategoryIssueUiDataContainer;", "tasksCache", "", "Lcom/android/build/attribution/data/TaskData;", "Lcom/android/build/attribution/ui/data/TaskUiData;", "tasksDeterminingBuildDuration", "", "getByTaskData", "task", "intellij.android.build-attribution"})
public final class TaskUiDataContainer {
    @NotNull
    private final TaskIssueUiDataContainer issuesContainer;
    @NotNull
    private final TaskCategoryIssueUiDataContainer taskCategoryIssuesContainer;
    private final long criticalPathDuration;
    @NotNull
    private final Map<TaskData, TaskUiData> tasksCache;
    @NotNull
    private final Set<TaskData> tasksDeterminingBuildDuration;
    private final boolean configurationCacheUsed;

    public TaskUiDataContainer(@NotNull BuildEventsAnalysisResult buildAnalysisResult, @NotNull TaskIssueUiDataContainer issuesContainer, @NotNull TaskCategoryIssueUiDataContainer taskCategoryIssuesContainer, long criticalPathDuration) {
        Intrinsics.checkNotNullParameter((Object)buildAnalysisResult, (String)"buildAnalysisResult");
        Intrinsics.checkNotNullParameter((Object)issuesContainer, (String)"issuesContainer");
        Intrinsics.checkNotNullParameter((Object)taskCategoryIssuesContainer, (String)"taskCategoryIssuesContainer");
        this.issuesContainer = issuesContainer;
        this.taskCategoryIssuesContainer = taskCategoryIssuesContainer;
        this.criticalPathDuration = criticalPathDuration;
        this.tasksCache = new HashMap();
        this.tasksDeterminingBuildDuration = CollectionsKt.toHashSet((Iterable)buildAnalysisResult.getTasksDeterminingBuildDuration());
        this.configurationCacheUsed = buildAnalysisResult.buildUsesConfigurationCache();
    }

    @NotNull
    public final TaskIssueUiDataContainer getIssuesContainer() {
        return this.issuesContainer;
    }

    @NotNull
    public final TaskCategoryIssueUiDataContainer getTaskCategoryIssuesContainer() {
        return this.taskCategoryIssuesContainer;
    }

    @NotNull
    public final TaskUiData getByTaskData(@NotNull TaskData task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        TaskUiData taskUiData = this.tasksCache.computeIfAbsent(task2, new Function(task2, this){
            final /* synthetic */ TaskData $task;
            final /* synthetic */ TaskUiDataContainer this$0;
            {
                this.$task = $task;
                this.this$0 = $receiver;
            }

            @NotNull
            public final TaskUiData apply(@NotNull TaskData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return new TaskUiData(this.$task, this.this$0){
                    @NotNull
                    private final String pluginName;
                    @NotNull
                    private final PluginSourceType sourceType;
                    private final boolean pluginUnknownBecauseOfCC;
                    @NotNull
                    private final String module;
                    @NotNull
                    private final String name;
                    @NotNull
                    private final String taskPath;
                    @NotNull
                    private final String taskType;
                    @NotNull
                    private final TimeWithPercentage executionTime;
                    private final boolean executedIncrementally;
                    @NotNull
                    private final String executionMode;
                    private final boolean onLogicalCriticalPath;
                    private final boolean onExtendedCriticalPath;
                    @NotNull
                    private final List<String> reasonsToRun;
                    @NotNull
                    private final TaskCategory primaryTaskCategory;
                    @NotNull
                    private final List<TaskCategory> secondaryTaskCategories;
                    @NotNull
                    private final List<TaskCategoryIssueUiData> relatedTaskCategoryIssues;
                    final /* synthetic */ TaskData $task;
                    final /* synthetic */ TaskUiDataContainer this$0;
                    {
                        this.$task = $task;
                        this.this$0 = $receiver;
                        this.pluginName = $task.getOriginPlugin().displayNameInProject($task.getProjectPath());
                        this.sourceType = $task.getOriginPlugin().isAndroidPlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().isKotlinPlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().isGradlePlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().isJavaPlugin() ? PluginSourceType.ANDROID_PLUGIN : ($task.getOriginPlugin().getPluginType() == PluginData.PluginType.BUILDSRC_PLUGIN || $task.getOriginPlugin().getPluginType() == PluginData.PluginType.SCRIPT ? PluginSourceType.BUILD_SRC : PluginSourceType.THIRD_PARTY))));
                        this.pluginUnknownBecauseOfCC = $task.getOriginPlugin().getPluginType() == PluginData.PluginType.UNKNOWN && TaskUiDataContainer.access$getConfigurationCacheUsed$p($receiver);
                        this.module = $task.getProjectPath();
                        this.name = $task.getTaskName();
                        this.taskPath = $task.getTaskPath();
                        this.taskType = $task.getTaskType();
                        this.executionTime = new TimeWithPercentage($task.getExecutionTime(), TaskUiDataContainer.access$getCriticalPathDuration$p($receiver));
                        this.executedIncrementally = $task.getExecutionMode() == TaskData.TaskExecutionMode.INCREMENTAL;
                        this.executionMode = $task.getExecutionMode().name();
                        this.onLogicalCriticalPath = $task.isOnTheCriticalPath();
                        this.onExtendedCriticalPath = TaskUiDataContainer.access$getTasksDeterminingBuildDuration$p($receiver).contains($task);
                        this.reasonsToRun = $task.getExecutionReasons();
                        this.primaryTaskCategory = $task.getPrimaryTaskCategory();
                        this.secondaryTaskCategories = $task.getSecondaryTaskCategories();
                        this.relatedTaskCategoryIssues = $receiver.getTaskCategoryIssuesContainer().issuesForCategory($task.getPrimaryTaskCategory(), TaskCategoryIssue.Severity.WARNING);
                    }

                    @NotNull
                    public String getPluginName() {
                        return this.pluginName;
                    }

                    @NotNull
                    public PluginSourceType getSourceType() {
                        return this.sourceType;
                    }

                    public boolean getPluginUnknownBecauseOfCC() {
                        return this.pluginUnknownBecauseOfCC;
                    }

                    @NotNull
                    public String getModule() {
                        return this.module;
                    }

                    @NotNull
                    public String getName() {
                        return this.name;
                    }

                    @NotNull
                    public String getTaskPath() {
                        return this.taskPath;
                    }

                    @NotNull
                    public String getTaskType() {
                        return this.taskType;
                    }

                    @NotNull
                    public TimeWithPercentage getExecutionTime() {
                        return this.executionTime;
                    }

                    public boolean getExecutedIncrementally() {
                        return this.executedIncrementally;
                    }

                    @NotNull
                    public String getExecutionMode() {
                        return this.executionMode;
                    }

                    public boolean getOnLogicalCriticalPath() {
                        return this.onLogicalCriticalPath;
                    }

                    public boolean getOnExtendedCriticalPath() {
                        return this.onExtendedCriticalPath;
                    }

                    @NotNull
                    public List<String> getReasonsToRun() {
                        return this.reasonsToRun;
                    }

                    @NotNull
                    public List<TaskIssueUiData> getIssues() {
                        return this.this$0.getIssuesContainer().issuesForTask(this.$task);
                    }

                    @NotNull
                    public TaskCategory getPrimaryTaskCategory() {
                        return this.primaryTaskCategory;
                    }

                    @NotNull
                    public List<TaskCategory> getSecondaryTaskCategories() {
                        return this.secondaryTaskCategories;
                    }

                    @NotNull
                    public List<TaskCategoryIssueUiData> getRelatedTaskCategoryIssues() {
                        return this.relatedTaskCategoryIssues;
                    }
                };
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskUiData, (String)"fun getByTaskData(task: \u2026WARNING\n      )\n    }\n  }");
        return taskUiData;
    }

    public static final /* synthetic */ boolean access$getConfigurationCacheUsed$p(TaskUiDataContainer $this) {
        return $this.configurationCacheUsed;
    }

    public static final /* synthetic */ long access$getCriticalPathDuration$p(TaskUiDataContainer $this) {
        return $this.criticalPathDuration;
    }

    public static final /* synthetic */ Set access$getTasksDeterminingBuildDuration$p(TaskUiDataContainer $this) {
        return $this.tasksDeterminingBuildDuration;
    }
}

