/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.build.attribution.AbstractBuildAnalysisResult;
import com.android.build.attribution.BuildAnalysisResults;
import com.android.build.attribution.BuildAnalyzerNotificationManager;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.FailureResult;
import com.android.build.attribution.analyzers.BuildEventsAnalysisResult;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.build.attribution.ui.BuildAttributionUiManagerImpl;
import com.android.build.attribution.ui.BuildAttributionUiManagerKt;
import com.android.build.attribution.ui.BuildFailureViewComponentContainer;
import com.android.build.attribution.ui.BuildReportFile;
import com.android.build.attribution.ui.NewViewComponentContainer;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.TaskIssueReporterImpl;
import com.android.build.attribution.ui.data.BuildAttributionReportUiData;
import com.android.build.attribution.ui.data.builder.BuildAttributionReportBuilder;
import com.android.build.attribution.ui.model.BuildAnalyzerViewModel;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.build.BuildContentManager;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003*\u0001\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0016\u0010\u001f\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\u0016\u0010#\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0002J\b\u0010$\u001a\u00020\u001eH\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020'H\u0003J\u0010\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020*H\u0003J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00060!2\u0006\u0010)\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020\u001e2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001e0!H\u0002J\u0018\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J\b\u00103\u001a\u00020\u001eH\u0002J\u0010\u00104\u001a\u00020\u001e2\u0006\u00101\u001a\u000202H\u0016J\u001e\u00105\u001a\u00020\u001e2\u0006\u00100\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060!H\u0002J\b\u00106\u001a\u00020\u001eH\u0003J\u0010\u00107\u001a\u00020\u001e2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020\u001eH\u0016J\f\u0010;\u001a\u00020\u001e*\u00020\u000eH\u0002R&\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\b\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/android/build/attribution/ui/BuildAttributionUiManagerImpl;", "Lcom/android/build/attribution/ui/BuildAttributionUiManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "buildAttributionView", "Lcom/intellij/openapi/ui/ComponentContainer;", "getBuildAttributionView$annotations", "()V", "getBuildAttributionView", "()Lcom/intellij/openapi/ui/ComponentContainer;", "setBuildAttributionView", "(Lcom/intellij/openapi/ui/ComponentContainer;)V", "buildContent", "Lcom/intellij/ui/content/Content;", "getBuildContent$annotations", "getBuildContent", "()Lcom/intellij/ui/content/Content;", "setBuildContent", "(Lcom/intellij/ui/content/Content;)V", "contentManager", "Lcom/intellij/ui/content/ContentManager;", "contentManagerListener", "com/android/build/attribution/ui/BuildAttributionUiManagerImpl$contentManagerListener$1", "Lcom/android/build/attribution/ui/BuildAttributionUiManagerImpl$contentManagerListener$1;", "notificationManager", "Lcom/android/build/attribution/BuildAnalyzerNotificationManager;", "uiAnalytics", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics;", "cleanUp", "", "createAndRegisterNewView", "viewFactory", "Lkotlin/Function0;", "createNewTab", "createTabWithNewView", "dispose", "doShowNewFailureReport", "failureType", "Lcom/android/build/attribution/FailureResult$Type;", "doShowNewSuccessReport", "buildAnalysisResult", "Lcom/android/build/attribution/BuildAnalysisResults;", "getViewFactoryFromLatestResultStatus", "Lcom/android/build/attribution/AbstractBuildAnalysisResult;", "invokeLaterIfNotDisposed", "runnable", "makeExistingTabSelected", "content", "eventSource", "Lcom/android/build/attribution/ui/analytics/BuildAttributionUiAnalytics$TabOpenEventSource;", "onContentClosed", "openTab", "placeNewViewInExistingTab", "reInitReportUI", "showBuildAnalysisReportById", "buildID", "", "showNewReport", "replaceContentView", "intellij.android.build-attribution"})
public final class BuildAttributionUiManagerImpl
implements BuildAttributionUiManager {
    @NotNull
    private final Project project;
    @Nullable
    private ComponentContainer buildAttributionView;
    @Nullable
    private Content buildContent;
    @Nullable
    private ContentManager contentManager;
    @NotNull
    private final contentManagerListener.1 contentManagerListener;
    @NotNull
    private final BuildAttributionUiAnalytics uiAnalytics;
    @NotNull
    private final BuildAnalyzerNotificationManager notificationManager;

    public BuildAttributionUiManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.contentManagerListener = new ContentManagerListener(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getContent() != this.this$0.getBuildContent()) {
                    return;
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).tabOpened();
                } else if (event.getOperation() == ContentManagerEvent.ContentOperation.remove) {
                    BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).tabHidden();
                }
            }
        };
        this.uiAnalytics = new BuildAttributionUiAnalytics(this.project, (Function0<? extends Dimension>)((Function0)new Function0<Dimension>(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Dimension invoke() {
                Object object = this.this$0.getBuildAttributionView();
                return object != null && (object = object.getComponent()) != null ? ((Component)object).getSize() : null;
            }
        }));
        this.notificationManager = new BuildAnalyzerNotificationManager(this.project, this.uiAnalytics);
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)this);
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = LafManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new LafManagerListener(){

            public final void lookAndFeelChanged(@NotNull LafManager it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.reInitReportUI();
            }
        });
    }

    @Nullable
    public final ComponentContainer getBuildAttributionView() {
        return this.buildAttributionView;
    }

    public final void setBuildAttributionView(@Nullable ComponentContainer componentContainer) {
        this.buildAttributionView = componentContainer;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBuildAttributionView$annotations() {
    }

    @Nullable
    public final Content getBuildContent() {
        return this.buildContent;
    }

    public final void setBuildContent(@Nullable Content content2) {
        this.buildContent = content2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getBuildContent$annotations() {
    }

    @Override
    public void showBuildAnalysisReportById(@NotNull String buildID) {
        Intrinsics.checkNotNullParameter((Object)buildID, (String)"buildID");
        if (!((Boolean)StudioFlags.BUILD_ANALYZER_HISTORY.get()).booleanValue()) {
            return;
        }
        BuildAnalysisResults buildResults = BuildAnalyzerStorageManager.Companion.getInstance(this.project).getHistoricBuildResultByID(buildID).get();
        Intrinsics.checkNotNullExpressionValue((Object)buildResults, (String)"buildResults");
        BuildReportFile reportFile = new BuildReportFile(buildResults, this.project);
        OpenFileDescriptor fileDescriptor = new OpenFileDescriptor(this.project, (VirtualFile)reportFile);
        FileEditorManager.getInstance((Project)this.project).openEditor(fileDescriptor, true);
    }

    @Override
    public void showNewReport() {
        this.invokeLaterIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                AbstractBuildAnalysisResult buildAnalysisResult = BuildAnalyzerStorageManager.Companion.getInstance(BuildAttributionUiManagerImpl.access$getProject$p(this.this$0)).getLatestBuildAnalysisResults();
                BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0).newReportSessionId(buildAnalysisResult.getBuildSessionID());
                AbstractBuildAnalysisResult abstractBuildAnalysisResult = buildAnalysisResult;
                if (abstractBuildAnalysisResult instanceof FailureResult) {
                    BuildAttributionUiManagerImpl.access$doShowNewFailureReport(this.this$0, ((FailureResult)buildAnalysisResult).getFailureType());
                } else if (abstractBuildAnalysisResult instanceof BuildAnalysisResults) {
                    BuildAttributionUiManagerImpl.access$doShowNewSuccessReport(this.this$0, (BuildAnalysisResults)buildAnalysisResult);
                }
            }
        }));
    }

    @UiThread
    private final void doShowNewSuccessReport(BuildAnalysisResults buildAnalysisResult) {
        BuildAttributionReportUiData reportUiData = new BuildAttributionReportBuilder(buildAnalysisResult).build();
        Function0 viewFactory2 = (Function0)new Function0<NewViewComponentContainer>(reportUiData, this){
            final /* synthetic */ BuildAttributionReportUiData $reportUiData;
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            {
                this.$reportUiData = $reportUiData;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NewViewComponentContainer invoke() {
                TaskIssueReporterImpl issueReporter = new TaskIssueReporterImpl(this.$reportUiData, BuildAttributionUiManagerImpl.access$getProject$p(this.this$0), BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0));
                return new NewViewComponentContainer(this.$reportUiData, BuildAttributionUiManagerImpl.access$getProject$p(this.this$0), issueReporter, BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0));
            }
        };
        Content content2 = this.buildContent;
        if (content2 != null && content2.isValid()) {
            this.placeNewViewInExistingTab(content2, (Function0<? extends ComponentContainer>)viewFactory2);
        } else {
            this.createTabWithNewView((Function0<? extends ComponentContainer>)viewFactory2);
        }
        if (BuildAttributionUiManagerKt.access$shouldAutoOpenTab(reportUiData)) {
            Content content3 = this.buildContent;
            Intrinsics.checkNotNull((Object)content3);
            this.makeExistingTabSelected(content3, BuildAttributionUiAnalytics.TabOpenEventSource.AUTO_OPEN);
        }
        this.notificationManager.showToolWindowBalloonIfNeeded(reportUiData, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ BuildAttributionUiManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    this.this$0.openTab(BuildAttributionUiAnalytics.TabOpenEventSource.BALLOON_LINK);
                    ComponentContainer componentContainer = this.this$0.getBuildAttributionView();
                    NewViewComponentContainer newViewComponentContainer = componentContainer instanceof NewViewComponentContainer ? (NewViewComponentContainer)componentContainer : null;
                    if (newViewComponentContainer == null) break block0;
                    NewViewComponentContainer it = newViewComponentContainer;
                    boolean bl = false;
                    it.getModel().setSelectedData(BuildAnalyzerViewModel.DataSet.WARNINGS);
                }
            }
        }));
    }

    @UiThread
    private final void doShowNewFailureReport(FailureResult.Type failureType) {
        Content content2 = this.buildContent;
        if (content2 != null && content2.isValid()) {
            this.placeNewViewInExistingTab(content2, (Function0<? extends ComponentContainer>)((Function0)new Function0<ComponentContainer>(failureType){
                final /* synthetic */ FailureResult.Type $failureType;
                {
                    this.$failureType = $failureType;
                    super(0);
                }

                @NotNull
                public final ComponentContainer invoke() {
                    return new BuildFailureViewComponentContainer(this.$failureType);
                }
            }));
        }
    }

    @Override
    public void openTab(@NotNull BuildAttributionUiAnalytics.TabOpenEventSource eventSource) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventSource), (String)"eventSource");
        if (BuildAnalyzerStorageManager.Companion.getInstance(this.project).hasData()) {
            this.invokeLaterIfNotDisposed((Function0<Unit>)((Function0)new Function0<Unit>(this, eventSource){
                final /* synthetic */ BuildAttributionUiManagerImpl this$0;
                final /* synthetic */ BuildAttributionUiAnalytics.TabOpenEventSource $eventSource;
                {
                    this.this$0 = $receiver;
                    this.$eventSource = $eventSource;
                    super(0);
                }

                public final void invoke() {
                    Content content2 = this.this$0.getBuildContent();
                    if (!(content2 != null ? content2.isValid() : false)) {
                        Function0 viewFactory2 = BuildAttributionUiManagerImpl.access$getViewFactoryFromLatestResultStatus(this.this$0, BuildAnalyzerStorageManager.Companion.getInstance(BuildAttributionUiManagerImpl.access$getProject$p(this.this$0)).getLatestBuildAnalysisResults());
                        BuildAttributionUiManagerImpl.access$createTabWithNewView(this.this$0, viewFactory2);
                    }
                    Content content3 = this.this$0.getBuildContent();
                    Intrinsics.checkNotNull((Object)content3);
                    BuildAttributionUiManagerImpl.access$makeExistingTabSelected(this.this$0, content3, this.$eventSource);
                }
            }));
        }
    }

    private final Function0<ComponentContainer> getViewFactoryFromLatestResultStatus(AbstractBuildAnalysisResult buildAnalysisResult) {
        AbstractBuildAnalysisResult abstractBuildAnalysisResult = buildAnalysisResult;
        if (abstractBuildAnalysisResult instanceof BuildAnalysisResults) {
            BuildAttributionReportUiData reportUiData = new BuildAttributionReportBuilder((BuildEventsAnalysisResult)((Object)buildAnalysisResult)).build();
            return (Function0)new Function0<NewViewComponentContainer>(reportUiData, this){
                final /* synthetic */ BuildAttributionReportUiData $reportUiData;
                final /* synthetic */ BuildAttributionUiManagerImpl this$0;
                {
                    this.$reportUiData = $reportUiData;
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final NewViewComponentContainer invoke() {
                    TaskIssueReporterImpl issueReporter = new TaskIssueReporterImpl(this.$reportUiData, BuildAttributionUiManagerImpl.access$getProject$p(this.this$0), BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0));
                    return new NewViewComponentContainer(this.$reportUiData, BuildAttributionUiManagerImpl.access$getProject$p(this.this$0), issueReporter, BuildAttributionUiManagerImpl.access$getUiAnalytics$p(this.this$0));
                }
            };
        }
        if (abstractBuildAnalysisResult instanceof FailureResult) {
            return (Function0)new Function0<BuildFailureViewComponentContainer>(buildAnalysisResult){
                final /* synthetic */ AbstractBuildAnalysisResult $buildAnalysisResult;
                {
                    this.$buildAnalysisResult = $buildAnalysisResult;
                    super(0);
                }

                @NotNull
                public final BuildFailureViewComponentContainer invoke() {
                    return new BuildFailureViewComponentContainer(((FailureResult)this.$buildAnalysisResult).getFailureType());
                }
            };
        }
        throw new NoWhenBranchMatchedException();
    }

    private final void createTabWithNewView(Function0<? extends ComponentContainer> viewFactory2) {
        this.createAndRegisterNewView(viewFactory2);
        this.createNewTab();
    }

    private final void placeNewViewInExistingTab(Content content2, Function0<? extends ComponentContainer> viewFactory2) {
        this.createAndRegisterNewView(viewFactory2);
        this.replaceContentView(content2);
    }

    private final void makeExistingTabSelected(Content content2, BuildAttributionUiAnalytics.TabOpenEventSource eventSource) {
        this.uiAnalytics.registerOpenEventSource(eventSource);
        ContentManager contentManager = content2.getManager();
        if (contentManager != null) {
            contentManager.setSelectedContent(content2, true, true);
        }
        BuildContentManager.getInstance((Project)this.project).getOrCreateToolWindow().show((Runnable)makeExistingTabSelected.1.INSTANCE);
    }

    private final void createAndRegisterNewView(Function0<? extends ComponentContainer> viewFactory2) {
        ComponentContainer componentContainer = this.buildAttributionView;
        if (componentContainer != null) {
            ComponentContainer existingView = componentContainer;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)existingView));
        }
        this.buildAttributionView = (ComponentContainer)viewFactory2.invoke();
    }

    private final void replaceContentView(Content $this$replaceContentView) {
        block0: {
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer == null) break block0;
            ComponentContainer view = componentContainer;
            boolean bl = false;
            $this$replaceContentView.getComponent().removeAll();
            $this$replaceContentView.getComponent().add((Component)view.getComponent(), "Center");
            Disposer.register((Disposable)((Disposable)$this$replaceContentView), (Disposable)((Disposable)view));
            this.uiAnalytics.buildReportReplaced();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createNewTab() {
        block1: {
            void content2;
            ContentImpl contentImpl;
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer == null) break block1;
            ComponentContainer view = componentContainer;
            boolean bl = false;
            ContentImpl contentImpl2 = contentImpl = new ContentImpl((JComponent)new BorderLayoutPanel(), "Build Analyzer", true);
            BuildAttributionUiManagerImpl buildAttributionUiManagerImpl = this;
            boolean bl2 = false;
            content2.getComponent().add((Component)view.getComponent(), "Center");
            Disposer.register((Disposable)this, (Disposable)((Disposable)content2));
            Disposer.register((Disposable)((Disposable)content2), (Disposable)((Disposable)view));
            Disposer.register((Disposable)((Disposable)content2), (Disposable)new Disposable(this){
                final /* synthetic */ BuildAttributionUiManagerImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void dispose() {
                    BuildAttributionUiManagerImpl.access$onContentClosed(this.this$0);
                }
            });
            ((BuildContentManager)this.project.getService(BuildContentManager.class)).addContent((Content)content2);
            this.uiAnalytics.tabCreated();
            ContentManager contentManager = this.contentManager = content2.getManager();
            if (contentManager != null) {
                contentManager.addContentManagerListener((ContentManagerListener)this.contentManagerListener);
            }
            buildAttributionUiManagerImpl.buildContent = (Content)contentImpl;
        }
    }

    @UiThread
    private final void reInitReportUI() {
        block2: {
            Content content2 = this.buildContent;
            if (content2 == null || !content2.isValid()) break block2;
            ComponentContainer componentContainer = this.buildAttributionView;
            if (componentContainer != null) {
                ComponentContainer view = componentContainer;
                boolean bl = false;
                NewViewComponentContainer newViewComponentContainer = view instanceof NewViewComponentContainer ? (NewViewComponentContainer)view : null;
                if (newViewComponentContainer != null) {
                    newViewComponentContainer.reInitUi();
                }
                content2.getComponent().removeAll();
                content2.getComponent().add((Component)view.getComponent(), "Center");
            }
        }
    }

    private final void onContentClosed() {
        this.uiAnalytics.tabClosed();
        this.cleanUp();
    }

    private final void cleanUp() {
        ContentManager contentManager = this.contentManager;
        if (contentManager != null) {
            contentManager.removeContentManagerListener((ContentManagerListener)this.contentManagerListener);
        }
        this.contentManager = null;
        this.buildAttributionView = null;
        this.buildContent = null;
    }

    public void dispose() {
        this.cleanUp();
    }

    private final void invokeLaterIfNotDisposed(Function0<Unit> runnable2) {
        BuildAttributionUiManagerKt.invokeLaterIfNotDisposed(this.project, runnable2);
    }

    public static final /* synthetic */ Project access$getProject$p(BuildAttributionUiManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ BuildAttributionUiAnalytics access$getUiAnalytics$p(BuildAttributionUiManagerImpl $this) {
        return $this.uiAnalytics;
    }

    public static final /* synthetic */ void access$doShowNewFailureReport(BuildAttributionUiManagerImpl $this, FailureResult.Type failureType) {
        $this.doShowNewFailureReport(failureType);
    }

    public static final /* synthetic */ void access$doShowNewSuccessReport(BuildAttributionUiManagerImpl $this, BuildAnalysisResults buildAnalysisResult) {
        $this.doShowNewSuccessReport(buildAnalysisResult);
    }

    public static final /* synthetic */ Function0 access$getViewFactoryFromLatestResultStatus(BuildAttributionUiManagerImpl $this, AbstractBuildAnalysisResult buildAnalysisResult) {
        return $this.getViewFactoryFromLatestResultStatus(buildAnalysisResult);
    }

    public static final /* synthetic */ void access$createTabWithNewView(BuildAttributionUiManagerImpl $this, Function0 viewFactory2) {
        $this.createTabWithNewView((Function0<? extends ComponentContainer>)viewFactory2);
    }

    public static final /* synthetic */ void access$makeExistingTabSelected(BuildAttributionUiManagerImpl $this, Content content2, BuildAttributionUiAnalytics.TabOpenEventSource eventSource) {
        $this.makeExistingTabSelected(content2, eventSource);
    }

    public static final /* synthetic */ void access$onContentClosed(BuildAttributionUiManagerImpl $this) {
        $this.onContentClosed();
    }
}

