/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.ui;

import com.android.build.attribution.data.AnnotationProcessorData;
import com.android.build.attribution.ui.BuildAnalyzerBrowserLinks;
import com.android.build.attribution.ui.BuildAttributionUIUtilKt;
import com.android.build.attribution.ui.HtmlLinksHandler;
import com.android.build.attribution.ui.data.TaskCategoryIssueUiData;
import com.android.build.attribution.ui.data.TimeWithPercentage;
import com.android.build.attribution.ui.view.ViewActionHandlers;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.buildanalyzer.common.TaskCategoryIssue;
import com.android.utils.HtmlBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0013\u0010\u0006\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00072\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u001a\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u001a\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0014\u001a(\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u001e\u001a\n\u0010\u0003\u001a\u00020\u0001*\u00020\u001f\u001a\u000f\u0010\u0006\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007*\u00020\u001f\u001a\f\u0010 \u001a\u0004\u0018\u00010!*\u00020\"\u001a\u0018\u0010#\u001a\u00020\u0001*\u00020\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0019\u001a\n\u0010&\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010'\u001a\u00020\u0001*\u00020\u001f\u001a\u000f\u0010(\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0007*\u00020\u001f\u001a\u0012\u0010)\u001a\u00020\u0001*\u00020\u00142\u0006\u0010*\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"infoIconHtml", "", "warnIconHtml", "durationString", "timeMs", "", "durationStringHtml", "Lorg/jetbrains/annotations/NotNull;", "helpIcon", "text", "htmlTextLabelWithFixedLines", "Ljavax/swing/JEditorPane;", "htmlBodyContent", "linksHandler", "Lcom/android/build/attribution/ui/HtmlLinksHandler;", "htmlTextLabelWithLinesWrap", "warningIcon", "Ljavax/swing/Icon;", "warningsCountString", "warningsCount", "", "createTaskCategoryIssueMessage", "", "Lcom/android/utils/HtmlBuilder;", "taskCategoryIssues", "", "Lcom/android/build/attribution/ui/data/TaskCategoryIssueUiData;", "actionHandlers", "Lcom/android/build/attribution/ui/view/ViewActionHandlers;", "displayName", "Lcom/android/buildanalyzer/common/TaskCategory;", "Lcom/android/build/attribution/ui/data/TimeWithPercentage;", "getLink", "Lcom/android/build/attribution/ui/BuildAnalyzerBrowserLinks;", "Lcom/android/buildanalyzer/common/TaskCategoryIssue;", "getWarningMessage", "nonIncrementalAnnotationProcessors", "Lcom/android/build/attribution/data/AnnotationProcessorData;", "insertBRTags", "percentageString", "percentageStringHtml", "withPluralization", "base", "intellij.android.build-attribution"})
public final class BuildAttributionUIUtilKt {
    @NotNull
    public static final String warnIconHtml = "<icon alt='Warning' src='AllIcons.General.BalloonWarning'>";
    @NotNull
    public static final String infoIconHtml = "<icon alt='Information' src='AllIcons.General.BalloonInformation'>";

    @NotNull
    public static final String durationString(@NotNull TimeWithPercentage $this$durationString) {
        Intrinsics.checkNotNullParameter((Object)$this$durationString, (String)"<this>");
        return BuildAttributionUIUtilKt.durationString($this$durationString.getTimeMs());
    }

    @NotNull
    public static final String durationStringHtml(@NotNull TimeWithPercentage $this$durationStringHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$durationStringHtml, (String)"<this>");
        return BuildAttributionUIUtilKt.durationStringHtml($this$durationStringHtml.getTimeMs());
    }

    @NotNull
    public static final String percentageString(@NotNull TimeWithPercentage $this$percentageString) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$percentageString, (String)"<this>");
        if ($this$percentageString.getPercentage() < 0.1) {
            string = "<0.1%";
        } else if ($this$percentageString.getPercentage() > 99.9) {
            string = ">99.9%";
        } else {
            String string2 = "%.1f%%";
            Object[] objectArray = new Object[]{$this$percentageString.getPercentage()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        }
        return string;
    }

    @NotNull
    public static final String percentageStringHtml(@NotNull TimeWithPercentage $this$percentageStringHtml) {
        Intrinsics.checkNotNullParameter((Object)$this$percentageStringHtml, (String)"<this>");
        String string = StringUtil.escapeXmlEntities((String)BuildAttributionUIUtilKt.percentageString($this$percentageStringHtml));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(percentageString())");
        return string;
    }

    @NotNull
    public static final String withPluralization(int $this$withPluralization, @NotNull String base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        return $this$withPluralization + " " + StringUtil.pluralize((String)base, (int)$this$withPluralization);
    }

    @NotNull
    public static final String displayName(@NotNull TaskCategory $this$displayName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$displayName, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$displayName.ordinal()]) {
            case 1: {
                string = "AAR Packaging";
                break;
            }
            case 2: {
                string = "APK Packaging";
                break;
            }
            default: {
                String[] stringArray = new String[]{"_"};
                string = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)$this$displayName.toString(), (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)" ", null, null, (int)0, null, (Function1)displayName.1.INSTANCE, (int)30, null);
            }
        }
        return string;
    }

    @NotNull
    public static final String getWarningMessage(@NotNull TaskCategoryIssue $this$getWarningMessage, @NotNull List<AnnotationProcessorData> nonIncrementalAnnotationProcessors) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$getWarningMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter(nonIncrementalAnnotationProcessors, (String)"nonIncrementalAnnotationProcessors");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getWarningMessage.ordinal()]) {
            case 1: {
                string = "Non-final resource IDs are currently disabled.\nEnable non-final resource IDs for faster incremental compilation.\nTo enable, set android.nonFinalResIds=true in gradle.properties.";
                break;
            }
            case 2: {
                string = "Non-transitive R classes are currently disabled.\nEnable non-transitive R classes for faster incremental compilation.";
                break;
            }
            case 3: {
                string = "Resource validation is currently enabled.\nThis validates resources in your project on every debug build.\nTo speed up your debug build, set android.disableResourceValidation=true in gradle.properties.";
                break;
            }
            case 4: {
                string = StringsKt.trimIndent((String)("\n        The following annotation processor(s) are non-incremental, which causes the\n        JavaCompile task to always run non-incrementally:\n\n        " + CollectionsKt.joinToString$default((Iterable)nonIncrementalAnnotationProcessors, (CharSequence)"\n", null, null, (int)0, null, (Function1)getWarningMessage.1.INSTANCE, (int)30, null) + "\n\n        Consider switching to using an incremental annotation processor.\n      "));
                break;
            }
            case 5: {
                string = "Minification is enabled in debug variants.\nEnabling minification has an impact on build time for debug variants. Consider disabling minification for\nfaster development flow.";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Nullable
    public static final BuildAnalyzerBrowserLinks getLink(@NotNull TaskCategoryIssue $this$getLink) {
        BuildAnalyzerBrowserLinks buildAnalyzerBrowserLinks;
        Intrinsics.checkNotNullParameter((Object)$this$getLink, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$getLink.ordinal()]) {
            case 1: {
                buildAnalyzerBrowserLinks = null;
                break;
            }
            case 3: {
                buildAnalyzerBrowserLinks = null;
                break;
            }
            case 5: {
                buildAnalyzerBrowserLinks = null;
                break;
            }
            case 2: {
                buildAnalyzerBrowserLinks = BuildAnalyzerBrowserLinks.NON_TRANSITIVE_R_CLASS;
                break;
            }
            case 4: {
                buildAnalyzerBrowserLinks = BuildAnalyzerBrowserLinks.NON_INCREMENTAL_ANNOTATION_PROCESSORS;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return buildAnalyzerBrowserLinks;
    }

    @NotNull
    public static final String durationString(long timeMs) {
        String string;
        if (timeMs == 0L) {
            string = "0.0s";
        } else if (timeMs < 100L) {
            string = "<0.1s";
        } else {
            String string2 = "%.1fs";
            Object[] objectArray = new Object[]{(double)timeMs / (double)1000};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        }
        return string;
    }

    @NotNull
    public static final String durationStringHtml(long timeMs) {
        String string = StringUtil.escapeXmlEntities((String)BuildAttributionUIUtilKt.durationString(timeMs));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeXmlEntities(durationString(timeMs))");
        return string;
    }

    @NotNull
    public static final String warningsCountString(int warningsCount) {
        Object object;
        switch (warningsCount) {
            case 0: {
                object = "";
                break;
            }
            case 1: {
                object = "1 warning";
                break;
            }
            default: {
                object = warningsCount + " warnings";
            }
        }
        return object;
    }

    @NotNull
    public static final Icon warningIcon() {
        Icon icon2 = AllIcons.General.BalloonWarning;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"BalloonWarning");
        return icon2;
    }

    @NotNull
    public static final JEditorPane htmlTextLabelWithLinesWrap(@NotNull String htmlBodyContent, @Nullable HtmlLinksHandler linksHandler) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)htmlBodyContent, (String)"htmlBodyContent");
        JEditorPane jEditorPane2 = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane2, (String)"createHtmlViewer(true, null, null, null)");
        JEditorPane $this$htmlTextLabelWithLinesWrap_u24lambda_u2d0 = jEditorPane = jEditorPane2;
        boolean bl = false;
        $this$htmlTextLabelWithLinesWrap_u24lambda_u2d0.setBorder((Border)JBUI.Borders.empty());
        $this$htmlTextLabelWithLinesWrap_u24lambda_u2d0.setFocusable(true);
        SwingHelper.setHtml((JEditorPane)$this$htmlTextLabelWithLinesWrap_u24lambda_u2d0, (String)htmlBodyContent, null);
        if (linksHandler != null) {
            $this$htmlTextLabelWithLinesWrap_u24lambda_u2d0.addHyperlinkListener(linksHandler);
        }
        $this$htmlTextLabelWithLinesWrap_u24lambda_u2d0.setCaretPosition(0);
        return jEditorPane;
    }

    public static /* synthetic */ JEditorPane htmlTextLabelWithLinesWrap$default(String string, HtmlLinksHandler htmlLinksHandler, int n, Object object) {
        if ((n & 2) != 0) {
            htmlLinksHandler = null;
        }
        return BuildAttributionUIUtilKt.htmlTextLabelWithLinesWrap(string, htmlLinksHandler);
    }

    @NotNull
    public static final JEditorPane htmlTextLabelWithFixedLines(@NotNull String htmlBodyContent, @Nullable HtmlLinksHandler linksHandler) {
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)htmlBodyContent, (String)"htmlBodyContent");
        JEditorPane jEditorPane2 = SwingHelper.createHtmlViewer((boolean)false, null, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)jEditorPane2, (String)"createHtmlViewer(false, null, null, null)");
        JEditorPane $this$htmlTextLabelWithFixedLines_u24lambda_u2d1 = jEditorPane = jEditorPane2;
        boolean bl = false;
        $this$htmlTextLabelWithFixedLines_u24lambda_u2d1.setBorder((Border)JBUI.Borders.empty());
        $this$htmlTextLabelWithFixedLines_u24lambda_u2d1.setFocusable(true);
        SwingHelper.setHtml((JEditorPane)$this$htmlTextLabelWithFixedLines_u24lambda_u2d1, (String)htmlBodyContent, null);
        if (linksHandler != null) {
            $this$htmlTextLabelWithFixedLines_u24lambda_u2d1.addHyperlinkListener(linksHandler);
        }
        $this$htmlTextLabelWithFixedLines_u24lambda_u2d1.setCaretPosition(0);
        return jEditorPane;
    }

    public static /* synthetic */ JEditorPane htmlTextLabelWithFixedLines$default(String string, HtmlLinksHandler htmlLinksHandler, int n, Object object) {
        if ((n & 2) != 0) {
            htmlLinksHandler = null;
        }
        return BuildAttributionUIUtilKt.htmlTextLabelWithFixedLines(string, htmlLinksHandler);
    }

    public static final void createTaskCategoryIssueMessage(@NotNull HtmlBuilder $this$createTaskCategoryIssueMessage, @NotNull List<TaskCategoryIssueUiData> taskCategoryIssues, @NotNull HtmlLinksHandler linksHandler, @NotNull ViewActionHandlers actionHandlers) {
        Intrinsics.checkNotNullParameter((Object)$this$createTaskCategoryIssueMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter(taskCategoryIssues, (String)"taskCategoryIssues");
        Intrinsics.checkNotNullParameter((Object)linksHandler, (String)"linksHandler");
        Intrinsics.checkNotNullParameter((Object)actionHandlers, (String)"actionHandlers");
        String iconToUse = taskCategoryIssues.get(0).getIssue().getSeverity() == TaskCategoryIssue.Severity.INFO ? infoIconHtml : warnIconHtml;
        $this$createTaskCategoryIssueMessage.beginTable("VALIGN=TOP");
        Iterable $this$forEach$iv = taskCategoryIssues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TaskCategoryIssueUiData issueData = (TaskCategoryIssueUiData)element$iv;
            boolean bl = false;
            Object description2 = issueData.getMessage();
            if (issueData.getLink() != null) {
                description2 = (String)description2 + "\n";
                if (issueData.getIssue() == TaskCategoryIssue.NON_TRANSITIVE_R_CLASS_DISABLED) {
                    String migrateRClassLink2 = linksHandler.actionLink("Click here to migrate your project to use non-transitive R classes", "AndroidMigrateToNonTransitiveRClassesAction", new Runnable(actionHandlers){
                        final /* synthetic */ ViewActionHandlers $actionHandlers;
                        {
                            this.$actionHandlers = $actionHandlers;
                        }

                        public final void run() {
                            this.$actionHandlers.migrateToNonTransitiveRClass();
                        }
                    });
                    description2 = (String)description2 + migrateRClassLink2 + ", or ";
                }
                description2 = (String)description2 + linksHandler.externalLink("Learn more", issueData.getLink());
            }
            description2 = StringsKt.replace$default((String)description2, (String)"\n", (String)"<BR/>", (boolean)false, (int)4, null);
            String[] stringArray = new String[]{iconToUse, description2};
            $this$createTaskCategoryIssueMessage.addTableRow(stringArray);
        }
        $this$createTaskCategoryIssueMessage.endTable();
    }

    @NotNull
    public static final String insertBRTags(@NotNull String $this$insertBRTags) {
        Intrinsics.checkNotNullParameter((Object)$this$insertBRTags, (String)"<this>");
        return StringsKt.replace$default((String)$this$insertBRTags, (String)"\n", (String)"<br/>\n", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String helpIcon(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return "<icon alt='" + text2 + "' src='AllIcons.General.ContextHelp'>";
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TaskCategory.values().length];
            nArray[TaskCategory.AAR_PACKAGING.ordinal()] = 1;
            nArray[TaskCategory.APK_PACKAGING.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TaskCategoryIssue.values().length];
            nArray[TaskCategoryIssue.NON_FINAL_RES_IDS_DISABLED.ordinal()] = 1;
            nArray[TaskCategoryIssue.NON_TRANSITIVE_R_CLASS_DISABLED.ordinal()] = 2;
            nArray[TaskCategoryIssue.RESOURCE_VALIDATION_ENABLED.ordinal()] = 3;
            nArray[TaskCategoryIssue.JAVA_NON_INCREMENTAL_ANNOTATION_PROCESSOR.ordinal()] = 4;
            nArray[TaskCategoryIssue.MINIFICATION_ENABLED_IN_DEBUG_BUILD.ordinal()] = 5;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

