/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerNotRun;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.JetifierCanBeRemoved;
import com.android.build.attribution.analyzers.JetifierNotUsed;
import com.android.build.attribution.analyzers.JetifierRequiredForLibraries;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerKt;
import com.android.build.attribution.analyzers.JetifierUsageAnalyzerResult;
import com.android.build.attribution.analyzers.JetifierUsedCheckRequired;
import com.android.build.attribution.analyzers.PostBuildProcessAnalyzer;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.buildanalyzer.common.CheckJetifierResult;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0002H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/JetifierUsageAnalyzerResult;", "Lcom/android/build/attribution/analyzers/PostBuildProcessAnalyzer;", "()V", "checkJetifierResult", "Lcom/android/buildanalyzer/common/CheckJetifierResult;", "enableJetifierFlagState", "", "Ljava/lang/Boolean;", "isCheckJetifierBuild", "lastCheckJetifierBuildTimestamp", "", "Ljava/lang/Long;", "shouldAnalyzerRun", "useAndroidXFlagState", "calculateResult", "cleanupTempState", "", "runPostBuildAnalysis", "analyzersResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "studioProvidedInfo", "Lcom/android/build/attribution/data/StudioProvidedInfo;", "intellij.android.build-attribution"})
public final class JetifierUsageAnalyzer
extends BaseAnalyzer<JetifierUsageAnalyzerResult>
implements PostBuildProcessAnalyzer {
    @Nullable
    private Boolean enableJetifierFlagState;
    @Nullable
    private Boolean useAndroidXFlagState;
    private boolean shouldAnalyzerRun;
    @Nullable
    private CheckJetifierResult checkJetifierResult;
    private boolean isCheckJetifierBuild;
    @Nullable
    private Long lastCheckJetifierBuildTimestamp;

    @Override
    public void runPostBuildAnalysis(@NotNull BuildEventsAnalyzersProxy analyzersResult, @NotNull StudioProvidedInfo studioProvidedInfo) {
        Intrinsics.checkNotNullParameter((Object)analyzersResult, (String)"analyzersResult");
        Intrinsics.checkNotNullParameter((Object)studioProvidedInfo, (String)"studioProvidedInfo");
        this.shouldAnalyzerRun = JetifierUsageAnalyzerKt.access$shouldAnalyzerRun(studioProvidedInfo.getAgpVersion());
        if (!this.shouldAnalyzerRun) {
            return;
        }
        this.enableJetifierFlagState = studioProvidedInfo.getEnableJetifierPropertyState();
        this.useAndroidXFlagState = studioProvidedInfo.getUseAndroidXPropertyState();
        File it = JetifierUsageAnalyzerKt.checkJetifierResultFile(studioProvidedInfo.getBuildRequestHolder().getBuildRequest().getData());
        boolean bl = false;
        if (it.exists()) {
            this.checkJetifierResult = CheckJetifierResult.Companion.load(it);
            this.lastCheckJetifierBuildTimestamp = System.currentTimeMillis();
            this.isCheckJetifierBuild = true;
        }
    }

    @Override
    @NotNull
    protected JetifierUsageAnalyzerResult calculateResult() {
        if (!this.shouldAnalyzerRun) {
            return new JetifierUsageAnalyzerResult(AnalyzerNotRun.INSTANCE, this.lastCheckJetifierBuildTimestamp, false);
        }
        if (Intrinsics.areEqual((Object)this.enableJetifierFlagState, (Object)true) && Intrinsics.areEqual((Object)this.useAndroidXFlagState, (Object)true)) {
            JetifierUsageAnalyzerResult jetifierUsageAnalyzerResult;
            CheckJetifierResult checkJetifierResult = this.checkJetifierResult;
            if (checkJetifierResult != null) {
                CheckJetifierResult it = checkJetifierResult;
                boolean bl = false;
                jetifierUsageAnalyzerResult = it.isEmpty() ? new JetifierUsageAnalyzerResult(JetifierCanBeRemoved.INSTANCE, this.lastCheckJetifierBuildTimestamp, this.isCheckJetifierBuild) : new JetifierUsageAnalyzerResult(new JetifierRequiredForLibraries(it), this.lastCheckJetifierBuildTimestamp, this.isCheckJetifierBuild);
            } else {
                jetifierUsageAnalyzerResult = new JetifierUsageAnalyzerResult(JetifierUsedCheckRequired.INSTANCE, this.lastCheckJetifierBuildTimestamp, false);
            }
            return jetifierUsageAnalyzerResult;
        }
        return new JetifierUsageAnalyzerResult(JetifierNotUsed.INSTANCE, this.lastCheckJetifierBuildTimestamp, false);
    }

    @Override
    public void cleanupTempState() {
        this.enableJetifierFlagState = null;
        this.useAndroidXFlagState = null;
        this.shouldAnalyzerRun = false;
        this.isCheckJetifierBuild = false;
    }
}

