/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildAttributionReportAnalyzer;
import com.android.build.attribution.data.GarbageCollectionData;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.intellij.util.lang.JavaVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u0002H\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0014\u001a\u00020\t*\u00020\u0015H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/android/build/attribution/analyzers/GarbageCollectionAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/GarbageCollectionAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/BuildAttributionReportAnalyzer;", "()V", "garbageCollectionData", "", "Lcom/android/build/attribution/data/GarbageCollectionData;", "isSettingSet", "", "Ljava/lang/Boolean;", "javaVersion", "", "Ljava/lang/Integer;", "calculateResult", "cleanupTempState", "", "receiveBuildAttributionReport", "androidGradlePluginAttributionData", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData;", "isGcVmArgument", "", "Result", "intellij.android.build-attribution"})
public final class GarbageCollectionAnalyzer
extends BaseAnalyzer<Result>
implements BuildAttributionReportAnalyzer {
    @NotNull
    private List<GarbageCollectionData> garbageCollectionData = CollectionsKt.emptyList();
    @Nullable
    private Integer javaVersion;
    @Nullable
    private Boolean isSettingSet;

    @Override
    public void cleanupTempState() {
        this.garbageCollectionData = CollectionsKt.emptyList();
        this.javaVersion = null;
        this.isSettingSet = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveBuildAttributionReport(@NotNull AndroidGradlePluginAttributionData androidGradlePluginAttributionData) {
        boolean bl;
        block4: {
            void $this$any$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)androidGradlePluginAttributionData, (String)"androidGradlePluginAttributionData");
            Map map2 = androidGradlePluginAttributionData.getGarbageCollectionData();
            GarbageCollectionAnalyzer garbageCollectionAnalyzer = this;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator3.next();
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(new GarbageCollectionData((String)it.getKey(), ((Number)it.getValue()).longValue()));
            }
            garbageCollectionAnalyzer.garbageCollectionData = (List)destination$iv$iv;
            JavaVersion javaVersion = JavaVersion.tryParse((String)androidGradlePluginAttributionData.getJavaInfo().getVersion());
            this.javaVersion = javaVersion != null ? Integer.valueOf(javaVersion.feature) : null;
            $this$map$iv = androidGradlePluginAttributionData.getJavaInfo().getVmArguments();
            garbageCollectionAnalyzer = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!this.isGcVmArgument(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl4 = bl;
        garbageCollectionAnalyzer.isSettingSet = bl4;
        this.ensureResultCalculated();
    }

    private final boolean isGcVmArgument(String $this$isGcVmArgument) {
        return StringsKt.startsWith$default((String)$this$isGcVmArgument, (String)"-XX:+Use", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$isGcVmArgument, (String)"GC", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    protected Result calculateResult() {
        return new Result(this.garbageCollectionData, this.javaVersion, this.isSettingSet);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0017\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ6\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u0010\u0019J\u0013\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u0007\u0010\fR\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/android/build/attribution/analyzers/GarbageCollectionAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "garbageCollectionData", "", "Lcom/android/build/attribution/data/GarbageCollectionData;", "javaVersion", "", "isSettingSet", "", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Boolean;)V", "getGarbageCollectionData", "()Ljava/util/List;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getJavaVersion", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "totalGarbageCollectionTimeMs", "", "getTotalGarbageCollectionTimeMs", "()J", "component1", "component2", "component3", "copy", "(Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Boolean;)Lcom/android/build/attribution/analyzers/GarbageCollectionAnalyzer$Result;", "equals", "other", "", "hashCode", "toString", "", "intellij.android.build-attribution"})
    public static final class Result
    implements AnalyzerResult {
        @NotNull
        private final List<GarbageCollectionData> garbageCollectionData;
        @Nullable
        private final Integer javaVersion;
        @Nullable
        private final Boolean isSettingSet;

        public Result(@NotNull List<GarbageCollectionData> garbageCollectionData, @Nullable Integer javaVersion, @Nullable Boolean isSettingSet) {
            Intrinsics.checkNotNullParameter(garbageCollectionData, (String)"garbageCollectionData");
            this.garbageCollectionData = garbageCollectionData;
            this.javaVersion = javaVersion;
            this.isSettingSet = isSettingSet;
        }

        @NotNull
        public final List<GarbageCollectionData> getGarbageCollectionData() {
            return this.garbageCollectionData;
        }

        @Nullable
        public final Integer getJavaVersion() {
            return this.javaVersion;
        }

        @Nullable
        public final Boolean isSettingSet() {
            return this.isSettingSet;
        }

        /*
         * WARNING - void declaration
         */
        public final long getTotalGarbageCollectionTimeMs() {
            void var3_3;
            Iterable $this$sumByLong$iv = this.garbageCollectionData;
            boolean $i$f$sumByLong = false;
            long sum$iv = 0L;
            for (Object element$iv : $this$sumByLong$iv) {
                void it;
                GarbageCollectionData garbageCollectionData = (GarbageCollectionData)element$iv;
                long l = sum$iv;
                boolean bl = false;
                long l2 = it.getCollectionTimeMs();
                sum$iv = l + l2;
            }
            return (long)var3_3;
        }

        @NotNull
        public final List<GarbageCollectionData> component1() {
            return this.garbageCollectionData;
        }

        @Nullable
        public final Integer component2() {
            return this.javaVersion;
        }

        @Nullable
        public final Boolean component3() {
            return this.isSettingSet;
        }

        @NotNull
        public final Result copy(@NotNull List<GarbageCollectionData> garbageCollectionData, @Nullable Integer javaVersion, @Nullable Boolean isSettingSet) {
            Intrinsics.checkNotNullParameter(garbageCollectionData, (String)"garbageCollectionData");
            return new Result(garbageCollectionData, javaVersion, isSettingSet);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list2, Integer n, Boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list2 = result2.garbageCollectionData;
            }
            if ((n2 & 2) != 0) {
                n = result2.javaVersion;
            }
            if ((n2 & 4) != 0) {
                bl = result2.isSettingSet;
            }
            return result2.copy(list2, n, bl);
        }

        @NotNull
        public String toString() {
            return "Result(garbageCollectionData=" + this.garbageCollectionData + ", javaVersion=" + this.javaVersion + ", isSettingSet=" + this.isSettingSet + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.garbageCollectionData).hashCode();
            result2 = result2 * 31 + (this.javaVersion == null ? 0 : ((Object)this.javaVersion).hashCode());
            result2 = result2 * 31 + (this.isSettingSet == null ? 0 : ((Object)this.isSettingSet).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.garbageCollectionData, result2.garbageCollectionData)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.javaVersion, (Object)result2.javaVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isSettingSet, (Object)result2.isSettingSet);
        }
    }
}

