/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildAttributionReportAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.DownloadsAnalyzerKt;
import com.android.build.attribution.analyzers.PostBuildProcessAnalyzer;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.ide.common.repository.AgpVersion;
import com.google.wireless.android.sdk.stats.BuildDownloadsAnalysisData;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.download.FileDownloadFinishEvent;
import org.gradle.tooling.events.download.FileDownloadResult;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\n'()*+,-./0B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0002H\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u001e\u0010!\u001a\u00020\u0011*\u00060\"j\u0002`#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "Lcom/android/build/attribution/analyzers/BuildAttributionReportAnalyzer;", "Lcom/android/build/attribution/analyzers/PostBuildProcessAnalyzer;", "()V", "currentAgpVersionFromBuild", "Lcom/android/ide/common/repository/AgpVersion;", "gradleCanProvideDownloadEvents", "", "Ljava/lang/Boolean;", "processedEvents", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "calculateResult", "cleanupTempState", "", "detectRepository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "uri", "Ljava/net/URI;", "receiveBuildAttributionReport", "androidGradlePluginAttributionData", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData;", "receiveEvent", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "runPostBuildAnalysis", "analyzersResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "studioProvidedInfo", "Lcom/android/build/attribution/data/StudioProvidedInfo;", "appendMessagesRecursively", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "failures", "", "Lorg/gradle/tooling/Failure;", "ActiveResult", "AnalyzerIsDisabled", "DownloadResult", "DownloadStatus", "GradleDoesNotProvideEvents", "KnownRepository", "OtherRepository", "Repository", "RepositoryResult", "Result", "intellij.android.build-attribution"})
public final class DownloadsAnalyzer
extends BaseAnalyzer<Result>
implements BuildEventsAnalyzer,
BuildAttributionReportAnalyzer,
PostBuildProcessAnalyzer {
    @NotNull
    private final List<DownloadResult> processedEvents = new ArrayList();
    @Nullable
    private Boolean gradleCanProvideDownloadEvents;
    @Nullable
    private AgpVersion currentAgpVersionFromBuild;

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        void it;
        String string;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(event instanceof FileDownloadFinishEvent)) {
            return;
        }
        URI uRI = ((FileDownloadFinishEvent)event).getDescriptor().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"event.descriptor.uri");
        Repository repository2 = this.detectRepository(uRI);
        DownloadStatus status2 = ((FileDownloadFinishEvent)event).getResult() instanceof FailureResult ? DownloadStatus.FAILURE : (((FileDownloadFinishEvent)event).getResult().getBytesDownloaded() == 0L ? DownloadStatus.MISSED : DownloadStatus.SUCCESS);
        FileDownloadResult fileDownloadResult = ((FileDownloadFinishEvent)event).getResult();
        FailureResult failureResult = fileDownloadResult instanceof FailureResult ? (FailureResult)fileDownloadResult : null;
        if (failureResult != null) {
            StringBuilder stringBuilder;
            FailureResult it2 = failureResult;
            boolean bl = false;
            StringBuilder $this$receiveEvent_u24lambda_u2d1_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            List list2 = it2.getFailures();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"it.failures");
            this.appendMessagesRecursively($this$receiveEvent_u24lambda_u2d1_u24lambda_u2d0, list2);
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string = null;
        }
        String failureMessage = string;
        long l = ((FileDownloadFinishEvent)event).getEventTime();
        String string3 = ((FileDownloadFinishEvent)event).getDescriptor().getUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"event.descriptor.uri.toString()");
        fileDownloadResult = ((FileDownloadFinishEvent)event).getResult();
        DownloadStatus downloadStatus = status2;
        String string4 = string3;
        Repository repository3 = repository2;
        long l2 = l;
        List<DownloadResult> list3 = this.processedEvents;
        boolean bl = false;
        long l3 = it.getEndTime() - it.getStartTime();
        String string5 = failureMessage;
        long l4 = ((FileDownloadFinishEvent)event).getResult().getBytesDownloaded();
        long l5 = l3;
        DownloadStatus downloadStatus2 = downloadStatus;
        String string6 = string4;
        Repository repository4 = repository3;
        long l6 = l2;
        list3.add(new DownloadResult(l6, repository4, string6, downloadStatus2, l5, l4, string5));
    }

    private final void appendMessagesRecursively(StringBuilder $this$appendMessagesRecursively, List<? extends Failure> failures) {
        Iterable $this$forEach$iv = failures;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StringBuilder stringBuilder;
            Failure failure = (Failure)element$iv;
            boolean bl = false;
            if (failure.getMessage() != null) {
                String it;
                boolean bl2 = false;
                StringBuilder stringBuilder2 = $this$appendMessagesRecursively.append(it);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(it)");
                StringBuilder stringBuilder3 = stringBuilder2.append('\n');
                stringBuilder = stringBuilder3;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append('\\n')");
            } else {
                stringBuilder = null;
            }
            List list2 = failure.getCauses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"failure.causes");
            this.appendMessagesRecursively($this$appendMessagesRecursively, list2);
        }
    }

    @Override
    public void cleanupTempState() {
        this.processedEvents.clear();
        this.gradleCanProvideDownloadEvents = null;
        this.currentAgpVersionFromBuild = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveBuildAttributionReport(@NotNull AndroidGradlePluginAttributionData androidGradlePluginAttributionData) {
        AgpVersion agpVersion;
        Intrinsics.checkNotNullParameter((Object)androidGradlePluginAttributionData, (String)"androidGradlePluginAttributionData");
        DownloadsAnalyzer downloadsAnalyzer = this;
        Object object = androidGradlePluginAttributionData.getBuildInfo();
        if (object != null && (object = object.getAgpVersion()) != null) {
            void it;
            Object object2 = object;
            DownloadsAnalyzer downloadsAnalyzer2 = downloadsAnalyzer;
            boolean bl = false;
            agpVersion = AgpVersion.Companion.tryParse((String)it);
            downloadsAnalyzer = downloadsAnalyzer2;
        } else {
            agpVersion = null;
        }
        downloadsAnalyzer.currentAgpVersionFromBuild = agpVersion;
    }

    @Override
    public void runPostBuildAnalysis(@NotNull BuildEventsAnalyzersProxy analyzersResult, @NotNull StudioProvidedInfo studioProvidedInfo) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)analyzersResult, (String)"analyzersResult");
        Intrinsics.checkNotNullParameter((Object)studioProvidedInfo, (String)"studioProvidedInfo");
        AgpVersion agpVersion = this.currentAgpVersionFromBuild;
        if (agpVersion != null) {
            AgpVersion it = agpVersion;
            boolean bl3 = false;
            bl2 = it.compareTo(DownloadsAnalyzerKt.access$getMinAgpVersionGuaranteesGradle_7_3$p()) >= 0;
        } else {
            bl2 = false;
        }
        boolean doesCurrentAgpRequireGradleThatProvidesEvents = bl2;
        GradleVersion gradleVersion2 = studioProvidedInfo.getGradleVersion();
        if (gradleVersion2 != null) {
            GradleVersion it = gradleVersion2;
            boolean bl4 = false;
            bl = it.compareTo(DownloadsAnalyzerKt.getMinGradleVersionProvidingDownloadEvents()) >= 0;
        } else {
            bl = false;
        }
        boolean canGradleVersionFromSettingsProvideEvents = bl;
        this.gradleCanProvideDownloadEvents = doesCurrentAgpRequireGradleThatProvidesEvents || canGradleVersionFromSettingsProvideEvents;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Result calculateResult() {
        void $this$mapTo$iv$iv;
        Map $this$groupByTo$iv$iv;
        if (!Intrinsics.areEqual((Object)this.gradleCanProvideDownloadEvents, (Object)true)) {
            return GradleDoesNotProvideEvents.INSTANCE;
        }
        Iterable $this$groupBy$iv = this.processedEvents;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            DownloadResult it = (DownloadResult)element$iv$iv;
            boolean bl = false;
            Repository key$iv$iv = it.getRepository();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = (Map.Entry)iterator2.next();
            Object object = destination$iv$iv;
            boolean bl = false;
            Repository repo = (Repository)entry.getKey();
            List events = (List)entry.getValue();
            object.add(new RepositoryResult(repo, events));
        }
        List resultList = (List)destination$iv$iv;
        Object[] objectArray = new Object[]{resultList};
        DownloadsAnalyzerKt.access$getLOG$p().debug("Downloads stats for this build: ", objectArray);
        return new ActiveResult(resultList);
    }

    private final Repository detectRepository(URI uri) {
        Repository repository2;
        KnownRepository knownRepository;
        block3: {
            KnownRepository[] knownRepositoryArray = KnownRepository.values();
            int n = knownRepositoryArray.length;
            for (int i = 0; i < n; ++i) {
                KnownRepository knownRepository2;
                KnownRepository it = knownRepository2 = knownRepositoryArray[i];
                boolean bl = false;
                if (!it.matches(uri)) continue;
                knownRepository = knownRepository2;
                break block3;
            }
            knownRepository = null;
        }
        if (knownRepository != null) {
            repository2 = knownRepository;
        } else {
            String string = uri.getAuthority();
            Intrinsics.checkNotNull((Object)string);
            repository2 = new OtherRepository(string);
        }
        return repository2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0003\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "()V", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$ActiveResult;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$AnalyzerIsDisabled;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$GradleDoesNotProvideEvents;", "intellij.android.build-attribution"})
    public static abstract class Result
    implements AnalyzerResult {
        private Result() {
        }

        public /* synthetic */ Result(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$ActiveResult;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "repositoryResults", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "(Ljava/util/List;)V", "getRepositoryResults", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.build-attribution"})
    public static final class ActiveResult
    extends Result {
        @NotNull
        private final List<RepositoryResult> repositoryResults;

        public ActiveResult(@NotNull List<RepositoryResult> repositoryResults) {
            Intrinsics.checkNotNullParameter(repositoryResults, (String)"repositoryResults");
            super(null);
            this.repositoryResults = repositoryResults;
        }

        @NotNull
        public final List<RepositoryResult> getRepositoryResults() {
            return this.repositoryResults;
        }

        @NotNull
        public final List<RepositoryResult> component1() {
            return this.repositoryResults;
        }

        @NotNull
        public final ActiveResult copy(@NotNull List<RepositoryResult> repositoryResults) {
            Intrinsics.checkNotNullParameter(repositoryResults, (String)"repositoryResults");
            return new ActiveResult(repositoryResults);
        }

        public static /* synthetic */ ActiveResult copy$default(ActiveResult activeResult, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = activeResult.repositoryResults;
            }
            return activeResult.copy(list2);
        }

        @NotNull
        public String toString() {
            return "ActiveResult(repositoryResults=" + this.repositoryResults + ")";
        }

        public int hashCode() {
            return ((Object)this.repositoryResults).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ActiveResult)) {
                return false;
            }
            ActiveResult activeResult = (ActiveResult)other;
            return Intrinsics.areEqual(this.repositoryResults, activeResult.repositoryResults);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$AnalyzerIsDisabled;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "()V", "intellij.android.build-attribution"})
    public static final class AnalyzerIsDisabled
    extends Result {
        @NotNull
        public static final AnalyzerIsDisabled INSTANCE = new AnalyzerIsDisabled();

        private AnalyzerIsDisabled() {
            super(null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$GradleDoesNotProvideEvents;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Result;", "()V", "intellij.android.build-attribution"})
    public static final class GradleDoesNotProvideEvents
    extends Result {
        @NotNull
        public static final GradleDoesNotProvideEvents INSTANCE = new GradleDoesNotProvideEvents();

        private GradleDoesNotProvideEvents() {
            super(null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;", "", "(Ljava/lang/String;I)V", "SUCCESS", "MISSED", "FAILURE", "intellij.android.build-attribution"})
    public static final class DownloadStatus
    extends Enum<DownloadStatus> {
        public static final /* enum */ DownloadStatus SUCCESS = new DownloadStatus();
        public static final /* enum */ DownloadStatus MISSED = new DownloadStatus();
        public static final /* enum */ DownloadStatus FAILURE = new DownloadStatus();
        private static final /* synthetic */ DownloadStatus[] $VALUES;

        public static DownloadStatus[] values() {
            return (DownloadStatus[])$VALUES.clone();
        }

        public static DownloadStatus valueOf(String value2) {
            return Enum.valueOf(DownloadStatus.class, value2);
        }

        static {
            $VALUES = downloadStatusArray = new DownloadStatus[]{DownloadStatus.SUCCESS, DownloadStatus.MISSED, DownloadStatus.FAILURE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003JQ\u0010 \u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "", "timestamp", "", "repository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "url", "", "status", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;", "duration", "bytes", "failureMessage", "(JLcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;Ljava/lang/String;Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;JJLjava/lang/String;)V", "getBytes", "()J", "getDuration", "getFailureMessage", "()Ljava/lang/String;", "getRepository", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "getStatus", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadStatus;", "getTimestamp", "getUrl", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class DownloadResult {
        private final long timestamp;
        @NotNull
        private final Repository repository;
        @NotNull
        private final String url;
        @NotNull
        private final DownloadStatus status;
        private final long duration;
        private final long bytes;
        @Nullable
        private final String failureMessage;

        public DownloadResult(long timestamp, @NotNull Repository repository2, @NotNull String url, @NotNull DownloadStatus status2, long duration2, long bytes2, @Nullable String failureMessage) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            this.timestamp = timestamp;
            this.repository = repository2;
            this.url = url;
            this.status = status2;
            this.duration = duration2;
            this.bytes = bytes2;
            this.failureMessage = failureMessage;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final Repository getRepository() {
            return this.repository;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final DownloadStatus getStatus() {
            return this.status;
        }

        public final long getDuration() {
            return this.duration;
        }

        public final long getBytes() {
            return this.bytes;
        }

        @Nullable
        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final long component1() {
            return this.timestamp;
        }

        @NotNull
        public final Repository component2() {
            return this.repository;
        }

        @NotNull
        public final String component3() {
            return this.url;
        }

        @NotNull
        public final DownloadStatus component4() {
            return this.status;
        }

        public final long component5() {
            return this.duration;
        }

        public final long component6() {
            return this.bytes;
        }

        @Nullable
        public final String component7() {
            return this.failureMessage;
        }

        @NotNull
        public final DownloadResult copy(long timestamp, @NotNull Repository repository2, @NotNull String url, @NotNull DownloadStatus status2, long duration2, long bytes2, @Nullable String failureMessage) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            return new DownloadResult(timestamp, repository2, url, status2, duration2, bytes2, failureMessage);
        }

        public static /* synthetic */ DownloadResult copy$default(DownloadResult downloadResult, long l, Repository repository2, String string, DownloadStatus downloadStatus, long l2, long l3, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                l = downloadResult.timestamp;
            }
            if ((n & 2) != 0) {
                repository2 = downloadResult.repository;
            }
            if ((n & 4) != 0) {
                string = downloadResult.url;
            }
            if ((n & 8) != 0) {
                downloadStatus = downloadResult.status;
            }
            if ((n & 0x10) != 0) {
                l2 = downloadResult.duration;
            }
            if ((n & 0x20) != 0) {
                l3 = downloadResult.bytes;
            }
            if ((n & 0x40) != 0) {
                string2 = downloadResult.failureMessage;
            }
            return downloadResult.copy(l, repository2, string, downloadStatus, l2, l3, string2);
        }

        @NotNull
        public String toString() {
            return "DownloadResult(timestamp=" + this.timestamp + ", repository=" + this.repository + ", url=" + this.url + ", status=" + this.status + ", duration=" + this.duration + ", bytes=" + this.bytes + ", failureMessage=" + this.failureMessage + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.timestamp);
            result2 = result2 * 31 + this.repository.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + this.status.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.duration);
            result2 = result2 * 31 + Long.hashCode(this.bytes);
            result2 = result2 * 31 + (this.failureMessage == null ? 0 : this.failureMessage.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DownloadResult)) {
                return false;
            }
            DownloadResult downloadResult = (DownloadResult)other;
            if (this.timestamp != downloadResult.timestamp) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.repository, (Object)downloadResult.repository)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)downloadResult.url)) {
                return false;
            }
            if (this.status != downloadResult.status) {
                return false;
            }
            if (this.duration != downloadResult.duration) {
                return false;
            }
            if (this.bytes != downloadResult.bytes) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.failureMessage, (Object)downloadResult.failureMessage);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020\u000fH\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\rR\u0011\u0010\u001c\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010\u001e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\r\u00a8\u0006)"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$RepositoryResult;", "", "repository", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "downloads", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$DownloadResult;", "(Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;Ljava/util/List;)V", "getDownloads", "()Ljava/util/List;", "failedRequestsBytesDownloaded", "", "getFailedRequestsBytesDownloaded", "()J", "failedRequestsCount", "", "getFailedRequestsCount", "()I", "failedRequestsTimeMs", "getFailedRequestsTimeMs", "missedRequestsCount", "getMissedRequestsCount", "missedRequestsTimeMs", "getMissedRequestsTimeMs", "getRepository", "()Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "successRequestsBytesDownloaded", "getSuccessRequestsBytesDownloaded", "successRequestsCount", "getSuccessRequestsCount", "successRequestsTimeMs", "getSuccessRequestsTimeMs", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.android.build-attribution"})
    public static final class RepositoryResult {
        @NotNull
        private final Repository repository;
        @NotNull
        private final List<DownloadResult> downloads;
        private final int successRequestsCount;
        private final long successRequestsTimeMs;
        private final long successRequestsBytesDownloaded;
        private final int missedRequestsCount;
        private final long missedRequestsTimeMs;
        private final int failedRequestsCount;
        private final long failedRequestsTimeMs;
        private final long failedRequestsBytesDownloaded;

        /*
         * WARNING - void declaration
         */
        public RepositoryResult(@NotNull Repository repository2, @NotNull List<DownloadResult> downloads) {
            long l;
            long l2;
            void $this$groupByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter(downloads, (String)"downloads");
            this.repository = repository2;
            this.downloads = downloads;
            Iterable $this$groupBy$iv = this.downloads;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                DownloadResult it = (DownloadResult)element$iv$iv;
                boolean bl = false;
                DownloadStatus key$iv$iv = it.getStatus();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map groupedByStatus = destination$iv$iv;
            List successDownloads = groupedByStatus.getOrDefault((Object)DownloadStatus.SUCCESS, CollectionsKt.emptyList());
            List failedDownloads = groupedByStatus.getOrDefault((Object)DownloadStatus.FAILURE, CollectionsKt.emptyList());
            List missedDownloads = groupedByStatus.getOrDefault((Object)DownloadStatus.MISSED, CollectionsKt.emptyList());
            this.successRequestsCount = successDownloads.size();
            Iterable iterable2 = successDownloads;
            RepositoryResult repositoryResult = this;
            long l3 = 0L;
            for (Object t : iterable2) {
                void it;
                DownloadResult bl = (DownloadResult)t;
                l2 = l3;
                boolean bl3 = false;
                l = it.getDuration();
                l3 = l2 + l;
            }
            repositoryResult.successRequestsTimeMs = l2 = l3;
            iterable2 = successDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getBytes();
                l3 = l2 + l;
            }
            repositoryResult.successRequestsBytesDownloaded = l2 = l3;
            this.missedRequestsCount = missedDownloads.size();
            iterable2 = missedDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getDuration();
                l3 = l2 + l;
            }
            repositoryResult.missedRequestsTimeMs = l2 = l3;
            this.failedRequestsCount = failedDownloads.size();
            iterable2 = failedDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getDuration();
                l3 = l2 + l;
            }
            repositoryResult.failedRequestsTimeMs = l2 = l3;
            iterable2 = failedDownloads;
            repositoryResult = this;
            l3 = 0L;
            for (Object t : iterable2) {
                DownloadResult it = (DownloadResult)t;
                l2 = l3;
                boolean bl = false;
                l = it.getBytes();
                l3 = l2 + l;
            }
            repositoryResult.failedRequestsBytesDownloaded = l2 = l3;
        }

        @NotNull
        public final Repository getRepository() {
            return this.repository;
        }

        @NotNull
        public final List<DownloadResult> getDownloads() {
            return this.downloads;
        }

        public final int getSuccessRequestsCount() {
            return this.successRequestsCount;
        }

        public final long getSuccessRequestsTimeMs() {
            return this.successRequestsTimeMs;
        }

        public final long getSuccessRequestsBytesDownloaded() {
            return this.successRequestsBytesDownloaded;
        }

        public final int getMissedRequestsCount() {
            return this.missedRequestsCount;
        }

        public final long getMissedRequestsTimeMs() {
            return this.missedRequestsTimeMs;
        }

        public final int getFailedRequestsCount() {
            return this.failedRequestsCount;
        }

        public final long getFailedRequestsTimeMs() {
            return this.failedRequestsTimeMs;
        }

        public final long getFailedRequestsBytesDownloaded() {
            return this.failedRequestsBytesDownloaded;
        }

        @NotNull
        public final Repository component1() {
            return this.repository;
        }

        @NotNull
        public final List<DownloadResult> component2() {
            return this.downloads;
        }

        @NotNull
        public final RepositoryResult copy(@NotNull Repository repository2, @NotNull List<DownloadResult> downloads) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter(downloads, (String)"downloads");
            return new RepositoryResult(repository2, downloads);
        }

        public static /* synthetic */ RepositoryResult copy$default(RepositoryResult repositoryResult, Repository repository2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                repository2 = repositoryResult.repository;
            }
            if ((n & 2) != 0) {
                list2 = repositoryResult.downloads;
            }
            return repositoryResult.copy(repository2, list2);
        }

        @NotNull
        public String toString() {
            return "RepositoryResult(repository=" + this.repository + ", downloads=" + this.downloads + ")";
        }

        public int hashCode() {
            int result2 = this.repository.hashCode();
            result2 = result2 * 31 + ((Object)this.downloads).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepositoryResult)) {
                return false;
            }
            RepositoryResult repositoryResult = (RepositoryResult)other;
            if (!Intrinsics.areEqual((Object)this.repository, (Object)repositoryResult.repository)) {
                return false;
            }
            return Intrinsics.areEqual(this.downloads, repositoryResult.downloads);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b\u00c0\u0006\u0003"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "", "analyticsType", "Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "getAnalyticsType", "()Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$KnownRepository;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$OtherRepository;", "intellij.android.build-attribution"})
    public static interface Repository {
        @NotNull
        public BuildDownloadsAnalysisData.RepositoryStats.RepositoryType getAnalyticsType();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$OtherRepository;", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "host", "", "(Ljava/lang/String;)V", "analyticsType", "Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "getAnalyticsType", "()Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "getHost", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.android.build-attribution"})
    public static final class OtherRepository
    implements Repository {
        @NotNull
        private final String host;
        @NotNull
        private final BuildDownloadsAnalysisData.RepositoryStats.RepositoryType analyticsType;

        public OtherRepository(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            this.host = host;
            this.analyticsType = BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.OTHER_REPOSITORY;
        }

        @NotNull
        public final String getHost() {
            return this.host;
        }

        @Override
        @NotNull
        public BuildDownloadsAnalysisData.RepositoryStats.RepositoryType getAnalyticsType() {
            return this.analyticsType;
        }

        @NotNull
        public final String component1() {
            return this.host;
        }

        @NotNull
        public final OtherRepository copy(@NotNull String host) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            return new OtherRepository(host);
        }

        public static /* synthetic */ OtherRepository copy$default(OtherRepository otherRepository, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = otherRepository.host;
            }
            return otherRepository.copy(string);
        }

        @NotNull
        public String toString() {
            return "OtherRepository(host=" + this.host + ")";
        }

        public int hashCode() {
            return this.host.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OtherRepository)) {
                return false;
            }
            OtherRepository otherRepository = (OtherRepository)other;
            return Intrinsics.areEqual((Object)this.host, (Object)otherRepository.host);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u001f\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$KnownRepository;", "", "Lcom/android/build/attribution/analyzers/DownloadsAnalyzer$Repository;", "presentableName", "", "analyticsType", "Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "uri", "Ljava/net/URI;", "(Ljava/lang/String;ILjava/lang/String;Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;Ljava/net/URI;)V", "getAnalyticsType", "()Lcom/google/wireless/android/sdk/stats/BuildDownloadsAnalysisData$RepositoryStats$RepositoryType;", "getPresentableName", "()Ljava/lang/String;", "matches", "", "resourceURI", "GOOGLE", "MAVEN_CENTRAL", "JCENTER", "intellij.android.build-attribution"})
    public static final class KnownRepository
    extends Enum<KnownRepository>
    implements Repository {
        @NotNull
        private final String presentableName;
        @NotNull
        private final BuildDownloadsAnalysisData.RepositoryStats.RepositoryType analyticsType;
        @NotNull
        private final URI uri;
        public static final /* enum */ KnownRepository GOOGLE;
        public static final /* enum */ KnownRepository MAVEN_CENTRAL;
        public static final /* enum */ KnownRepository JCENTER;
        private static final /* synthetic */ KnownRepository[] $VALUES;

        private KnownRepository(String presentableName, BuildDownloadsAnalysisData.RepositoryStats.RepositoryType analyticsType, URI uri) {
            this.presentableName = presentableName;
            this.analyticsType = analyticsType;
            this.uri = uri;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }

        @Override
        @NotNull
        public BuildDownloadsAnalysisData.RepositoryStats.RepositoryType getAnalyticsType() {
            return this.analyticsType;
        }

        public final boolean matches(@NotNull URI resourceURI) {
            Intrinsics.checkNotNullParameter((Object)resourceURI, (String)"resourceURI");
            return Intrinsics.areEqual((Object)this.uri.getScheme(), (Object)resourceURI.getScheme()) && Intrinsics.areEqual((Object)this.uri.getAuthority(), (Object)resourceURI.getAuthority());
        }

        public static KnownRepository[] values() {
            return (KnownRepository[])$VALUES.clone();
        }

        public static KnownRepository valueOf(String value2) {
            return Enum.valueOf(KnownRepository.class, value2);
        }

        static {
            URI uRI = URI.create("https://dl.google.com/dl/android/maven2/");
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(\"https://dl.google.com/dl/android/maven2/\")");
            GOOGLE = new KnownRepository("Google", BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.GOOGLE, uRI);
            URI uRI2 = URI.create("https://repo.maven.apache.org/maven2/");
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"create(\"https://repo.maven.apache.org/maven2/\")");
            MAVEN_CENTRAL = new KnownRepository("Maven Central", BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.MAVEN_CENTRAL, uRI2);
            URI uRI3 = URI.create("https://jcenter.bintray.com/");
            Intrinsics.checkNotNullExpressionValue((Object)uRI3, (String)"create(\"https://jcenter.bintray.com/\")");
            JCENTER = new KnownRepository("JCenter", BuildDownloadsAnalysisData.RepositoryStats.RepositoryType.JCENTER, uRI3);
            $VALUES = knownRepositoryArray = new KnownRepository[]{KnownRepository.GOOGLE, KnownRepository.MAVEN_CENTRAL, KnownRepository.JCENTER};
        }
    }
}

