/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AGPUpdateRequired;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildAttributionReportAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.ConfigurationCacheCompatibilityTestFlow;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityAnalyzerKt;
import com.android.build.attribution.analyzers.ConfigurationCachingCompatibilityProjectResult;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOff;
import com.android.build.attribution.analyzers.ConfigurationCachingTurnedOn;
import com.android.build.attribution.analyzers.IncompatiblePluginWarning;
import com.android.build.attribution.analyzers.IncompatiblePluginsDetected;
import com.android.build.attribution.analyzers.KnownPluginsDataAnalyzer;
import com.android.build.attribution.analyzers.NoIncompatiblePlugins;
import com.android.build.attribution.analyzers.PostBuildProcessAnalyzer;
import com.android.build.attribution.analyzers.ProjectConfigurationAnalyzer;
import com.android.build.attribution.data.GradlePluginsData;
import com.android.build.attribution.data.PluginData;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0002H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\u00020\u00022\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0\n*\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010(\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010)\u001a\u00020*H\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006+"}, d2={"Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/ConfigurationCachingCompatibilityProjectResult;", "Lcom/android/build/attribution/analyzers/BuildAttributionReportAnalyzer;", "Lcom/android/build/attribution/analyzers/KnownPluginsDataAnalyzer;", "Lcom/android/build/attribution/analyzers/PostBuildProcessAnalyzer;", "()V", "appliedPlugins", "", "", "", "Lcom/android/build/attribution/data/PluginData;", "buildscriptClasspath", "", "Lcom/android/ide/common/repository/GradleCoordinate;", "configurationCacheInBuildState", "", "Ljava/lang/Boolean;", "configurationCachingGradlePropertiesFlagState", "currentAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "knownPlugins", "Lcom/android/build/attribution/data/GradlePluginsData$PluginInfo;", "runningConfigurationCacheTestFlow", "calculateResult", "cleanupTempState", "", "compute", "receiveBuildAttributionReport", "androidGradlePluginAttributionData", "Lcom/android/buildanalyzer/common/AndroidGradlePluginAttributionData;", "receiveKnownPluginsData", "data", "Lcom/android/build/attribution/data/GradlePluginsData;", "runPostBuildAnalysis", "analyzersResult", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "studioProvidedInfo", "Lcom/android/build/attribution/data/StudioProvidedInfo;", "filterOutInternalPlugins", "isSameCoordinate", "dependencyCoordinates", "Lcom/android/build/attribution/data/GradlePluginsData$DependencyCoordinates;", "intellij.android.build-attribution"})
public final class ConfigurationCachingCompatibilityAnalyzer
extends BaseAnalyzer<ConfigurationCachingCompatibilityProjectResult>
implements BuildAttributionReportAnalyzer,
KnownPluginsDataAnalyzer,
PostBuildProcessAnalyzer {
    @NotNull
    private final List<GradleCoordinate> buildscriptClasspath = new ArrayList();
    @NotNull
    private Map<String, ? extends List<PluginData>> appliedPlugins = MapsKt.emptyMap();
    @NotNull
    private List<GradlePluginsData.PluginInfo> knownPlugins = CollectionsKt.emptyList();
    @Nullable
    private AgpVersion currentAgpVersion;
    @Nullable
    private String configurationCachingGradlePropertiesFlagState;
    @Nullable
    private Boolean configurationCacheInBuildState;
    @Nullable
    private Boolean runningConfigurationCacheTestFlow;

    @Override
    public void cleanupTempState() {
        this.buildscriptClasspath.clear();
        this.appliedPlugins = MapsKt.emptyMap();
        this.knownPlugins = CollectionsKt.emptyList();
        this.currentAgpVersion = null;
        this.configurationCachingGradlePropertiesFlagState = null;
        this.configurationCacheInBuildState = null;
        this.runningConfigurationCacheTestFlow = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveBuildAttributionReport(@NotNull AndroidGradlePluginAttributionData androidGradlePluginAttributionData) {
        AgpVersion agpVersion;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)androidGradlePluginAttributionData, (String)"androidGradlePluginAttributionData");
        Iterable iterable = androidGradlePluginAttributionData.getBuildscriptDependenciesInfo();
        Object object = this.buildscriptClasspath;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            GradleCoordinate it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (GradleCoordinate.parseCoordinateString((String)it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        object.addAll((List)destination$iv$iv);
        AndroidGradlePluginAttributionData.BuildInfo buildInfo = androidGradlePluginAttributionData.getBuildInfo();
        this.configurationCacheInBuildState = buildInfo != null ? buildInfo.getConfigurationCacheIsOn() : null;
        Object object2 = this;
        Object object3 = androidGradlePluginAttributionData.getBuildInfo();
        if (object3 != null && (object3 = object3.getAgpVersion()) != null) {
            void it;
            destination$iv$iv = object3;
            object = object2;
            boolean bl = false;
            agpVersion = AgpVersion.Companion.tryParse((String)it);
            object2 = object;
        } else {
            agpVersion = null;
        }
        ((ConfigurationCachingCompatibilityAnalyzer)object2).currentAgpVersion = agpVersion;
    }

    @Override
    public void receiveKnownPluginsData(@NotNull GradlePluginsData data2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        this.knownPlugins = data2.getPluginsInfo();
    }

    @Override
    public void runPostBuildAnalysis(@NotNull BuildEventsAnalyzersProxy analyzersResult, @NotNull StudioProvidedInfo studioProvidedInfo) {
        Intrinsics.checkNotNullParameter((Object)analyzersResult, (String)"analyzersResult");
        Intrinsics.checkNotNullParameter((Object)studioProvidedInfo, (String)"studioProvidedInfo");
        this.appliedPlugins = (Map)ExtensionsKt.toImmutableMap(((ProjectConfigurationAnalyzer.Result)analyzersResult.getProjectConfigurationAnalyzer().getResult()).getAllAppliedPlugins());
        if (this.currentAgpVersion == null) {
            this.currentAgpVersion = studioProvidedInfo.getAgpVersion();
        }
        this.configurationCachingGradlePropertiesFlagState = studioProvidedInfo.getConfigurationCachingGradlePropertyState();
        this.runningConfigurationCacheTestFlow = studioProvidedInfo.isInConfigurationCacheTestFlow();
        this.ensureResultCalculated();
    }

    @Override
    @NotNull
    protected ConfigurationCachingCompatibilityProjectResult calculateResult() {
        return this.compute(CollectionsKt.flatten((Iterable)this.appliedPlugins.values()));
    }

    /*
     * WARNING - void declaration
     */
    private final ConfigurationCachingCompatibilityProjectResult compute(List<PluginData> appliedPlugins) {
        ConfigurationCachingCompatibilityProjectResult configurationCachingCompatibilityProjectResult;
        Object list$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        if (Intrinsics.areEqual((Object)this.runningConfigurationCacheTestFlow, (Object)true)) {
            return ConfigurationCacheCompatibilityTestFlow.INSTANCE;
        }
        if (Intrinsics.areEqual((Object)this.configurationCacheInBuildState, (Object)true)) {
            return ConfigurationCachingTurnedOn.INSTANCE;
        }
        if (this.configurationCachingGradlePropertiesFlagState != null) {
            return ConfigurationCachingTurnedOff.INSTANCE;
        }
        if (this.buildscriptClasspath.isEmpty()) {
            AgpVersion agpVersion = this.currentAgpVersion;
            if (agpVersion != null) {
                AgpVersion it = agpVersion;
                boolean bl = false;
                if (it.compareTo(ConfigurationCachingCompatibilityAnalyzerKt.access$getMinAGPVersion$p()) < 0) {
                    void $this$filterTo$iv$iv2;
                    void $this$filter$iv;
                    Iterable iterable = appliedPlugins;
                    AgpVersion agpVersion2 = it;
                    boolean $i$f$filter = false;
                    void var11_16 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo2 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        PluginData it2 = (PluginData)element$iv$iv;
                        boolean bl2 = false;
                        if (!it2.isAndroidPlugin()) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List list2 = (List)destination$iv$iv2;
                    AgpVersion agpVersion3 = agpVersion2;
                    return new AGPUpdateRequired(agpVersion3, list2);
                }
            }
        }
        Iterable $this$filter$iv = appliedPlugins;
        boolean $i$f$filter = false;
        Iterable bl = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginData it = (PluginData)element$iv$iv;
            boolean bl3 = false;
            if (!(it.getPluginType() == PluginData.PluginType.BINARY_PLUGIN)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$groupBy$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Object v1;
            block20: {
                PluginData appliedPlugin = (PluginData)element$iv$iv;
                boolean bl4 = false;
                Iterable destination$iv$iv2 = this.knownPlugins;
                for (Object object2 : destination$iv$iv2) {
                    GradlePluginsData.PluginInfo it3 = (GradlePluginsData.PluginInfo)object2;
                    boolean bl5 = false;
                    if (!it3.isThisPlugin(appliedPlugin)) continue;
                    v1 = object2;
                    break block20;
                }
                v1 = null;
            }
            GradlePluginsData.PluginInfo key$iv$iv = v1;
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object pluginsByPluginInfo = destination$iv$iv;
        List incompatiblePluginWarnings = new ArrayList();
        List upgradePluginWarnings = new ArrayList();
        Object $this$forEach$iv = pluginsByPluginInfo;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PluginData it;
            Collection collection2;
            Iterable $this$mapTo$iv$iv;
            Collection destination$iv$iv3;
            Iterable $this$map$iv;
            boolean $i$f$map;
            List list3;
            Object v4;
            Object $i$f$filterTo2;
            List plugins;
            GradlePluginsData.PluginInfo pluginInfo;
            block21: {
                Map.Entry element$iv;
                Object object2;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl7 = false;
                pluginInfo = (GradlePluginsData.PluginInfo)entry.getKey();
                plugins = (List)entry.getValue();
                GradlePluginsData.PluginInfo pluginInfo2 = pluginInfo;
                if ((pluginInfo2 != null ? pluginInfo2.getPluginArtifact() : null) == null) continue;
                $i$f$filterTo2 = this.buildscriptClasspath;
                object2 = $i$f$filterTo2.iterator();
                while (object2.hasNext()) {
                    Object it3 = object2.next();
                    GradleCoordinate it4 = (GradleCoordinate)it3;
                    boolean bl8 = false;
                    if (!this.isSameCoordinate(it4, pluginInfo.getPluginArtifact())) continue;
                    v4 = it3;
                    break block21;
                }
                v4 = null;
            }
            GradleCoordinate gradleCoordinate = v4;
            Object detectedVersion = gradleCoordinate != null ? gradleCoordinate.getVersion() : null;
            if (detectedVersion == null) continue;
            if (pluginInfo.getConfigurationCachingCompatibleFrom() == null) {
                Iterable $i$f$getOrPut = plugins;
                list3 = incompatiblePluginWarnings;
                $i$f$map = false;
                $i$f$filterTo2 = $this$map$iv;
                destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    list$iv$iv = (PluginData)item$iv$iv;
                    collection2 = destination$iv$iv3;
                    boolean bl9 = false;
                    collection2.add(new IncompatiblePluginWarning(it, (GradleVersion)detectedVersion, pluginInfo));
                }
                list3.addAll((List)destination$iv$iv3);
                continue;
            }
            if (detectedVersion.compareTo(pluginInfo.getConfigurationCachingCompatibleFrom()) >= 0) continue;
            $this$map$iv = plugins;
            list3 = upgradePluginWarnings;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (PluginData)item$iv$iv;
                collection2 = destination$iv$iv3;
                boolean bl10 = false;
                collection2.add(new IncompatiblePluginWarning(it, (GradleVersion)detectedVersion, pluginInfo));
            }
            list3.addAll((List)destination$iv$iv3);
        }
        if (incompatiblePluginWarnings.isEmpty() && upgradePluginWarnings.isEmpty()) {
            List<PluginData> list4 = (List<PluginData>)pluginsByPluginInfo.get(null);
            if (list4 == null || (list4 = this.filterOutInternalPlugins(list4)) == null) {
                list4 = CollectionsKt.emptyList();
            }
            configurationCachingCompatibilityProjectResult = new NoIncompatiblePlugins(list4);
        } else {
            configurationCachingCompatibilityProjectResult = new IncompatiblePluginsDetected(incompatiblePluginWarnings, upgradePluginWarnings);
        }
        return configurationCachingCompatibilityProjectResult;
    }

    private final boolean isSameCoordinate(GradleCoordinate $this$isSameCoordinate, GradlePluginsData.DependencyCoordinates dependencyCoordinates) {
        return Intrinsics.areEqual((Object)dependencyCoordinates.getGroup(), (Object)$this$isSameCoordinate.getGroupId()) && Intrinsics.areEqual((Object)dependencyCoordinates.getName(), (Object)$this$isSameCoordinate.getArtifactId());
    }

    /*
     * WARNING - void declaration
     */
    private final List<PluginData> filterOutInternalPlugins(List<PluginData> $this$filterOutInternalPlugins) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$filterOutInternalPlugins;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginData it = (PluginData)element$iv$iv;
            boolean bl = false;
            if (!(!it.isAndroidPlugin() && !it.isGradlePlugin() && !it.isKotlinPlugin() && it.getPluginType() != PluginData.PluginType.SCRIPT)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

