/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution.analyzers;

import com.android.build.attribution.analyzers.AnalyzerResult;
import com.android.build.attribution.analyzers.AnnotationProcessorsAnalyzer;
import com.android.build.attribution.analyzers.BaseAnalyzer;
import com.android.build.attribution.analyzers.BuildEventsAnalyzer;
import com.android.build.attribution.data.AnnotationProcessorData;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.data.TaskData;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.tooling.events.ProgressEvent;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.java.JavaCompileTaskOperationResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001aB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0002H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\fH\u0002R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/build/attribution/analyzers/AnnotationProcessorsAnalyzer;", "Lcom/android/build/attribution/analyzers/BaseAnalyzer;", "Lcom/android/build/attribution/analyzers/AnnotationProcessorsAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzer;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "(Lcom/android/build/attribution/data/TaskContainer;Lcom/android/build/attribution/data/PluginContainer;)V", "annotationProcessorsMap", "Ljava/util/HashMap;", "", "Ljava/time/Duration;", "Lkotlin/collections/HashMap;", "projectsNonIncrementalAnnotationProcessorsMap", "", "", "calculateResult", "cleanupTempState", "", "receiveEvent", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "updateAnnotationProcessorCompilationTime", "className", "compilationDuration", "Result", "intellij.android.build-attribution"})
public final class AnnotationProcessorsAnalyzer
extends BaseAnalyzer<Result>
implements BuildEventsAnalyzer {
    @NotNull
    private final TaskContainer taskContainer;
    @NotNull
    private final PluginContainer pluginContainer;
    @NotNull
    private final HashMap<String, Duration> annotationProcessorsMap;
    @NotNull
    private final Map<String, List<String>> projectsNonIncrementalAnnotationProcessorsMap;

    public AnnotationProcessorsAnalyzer(@NotNull TaskContainer taskContainer, @NotNull PluginContainer pluginContainer) {
        Intrinsics.checkNotNullParameter((Object)taskContainer, (String)"taskContainer");
        Intrinsics.checkNotNullParameter((Object)pluginContainer, (String)"pluginContainer");
        this.taskContainer = taskContainer;
        this.pluginContainer = pluginContainer;
        this.annotationProcessorsMap = new HashMap();
        this.projectsNonIncrementalAnnotationProcessorsMap = new LinkedHashMap();
    }

    private final void updateAnnotationProcessorCompilationTime(String className, Duration compilationDuration) {
        Duration duration2 = this.annotationProcessorsMap.getOrDefault(className, Duration.ZERO);
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"annotationProcessorsMap.\u2026className, Duration.ZERO)");
        Duration currentDuration = duration2;
        Map map2 = this.annotationProcessorsMap;
        Duration duration3 = currentDuration.plus(compilationDuration);
        Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"currentDuration + compilationDuration");
        Duration duration4 = duration3;
        map2.put(className, duration4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void receiveEvent(@NotNull ProgressEvent event) {
        block4: {
            TaskOperationResult result2;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!(event instanceof TaskFinishEvent) || !((result2 = ((TaskFinishEvent)event).getResult()) instanceof JavaCompileTaskOperationResult)) break block4;
            List list2 = ((JavaCompileTaskOperationResult)result2).getAnnotationProcessorResults();
            if (list2 != null) {
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    void $this$getOrPut$iv;
                    JavaCompileTaskOperationResult.AnnotationProcessorResult it = (JavaCompileTaskOperationResult.AnnotationProcessorResult)element$iv;
                    boolean bl = false;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                    Duration duration2 = it.getDuration();
                    Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"it.duration");
                    this.updateAnnotationProcessorCompilationTime(string, duration2);
                    if (it.getType() != JavaCompileTaskOperationResult.AnnotationProcessorResult.Type.UNKNOWN) continue;
                    Map<String, List<String>> map2 = this.projectsNonIncrementalAnnotationProcessorsMap;
                    String key$iv = this.taskContainer.getTask((TaskFinishEvent)event, this.pluginContainer).getProjectPath();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl2 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    List list3 = (List)object;
                    String string2 = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.className");
                    list3.add(string2);
                }
            }
        }
    }

    @Override
    public void cleanupTempState() {
        this.annotationProcessorsMap.clear();
        this.projectsNonIncrementalAnnotationProcessorsMap.clear();
    }

    @Override
    @NotNull
    protected Result calculateResult() {
        String it;
        Collection<AnnotationProcessorData> collection2;
        Map.Entry item$iv$iv;
        Object $this$mapTo$iv$iv;
        Object element$iv2;
        Iterable $this$forEach$iv = this.taskContainer.getTasks((Function1<? super TaskData, Boolean>)((Function1)calculateResult.1.INSTANCE));
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            TaskData it2 = (TaskData)element$iv2;
            boolean bl = false;
            this.projectsNonIncrementalAnnotationProcessorsMap.remove(it2.getProjectPath());
        }
        List finalNonIncrementalAnnotationProcessors = CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)this.projectsNonIncrementalAnnotationProcessorsMap.values()));
        Object $this$map$iv = this.annotationProcessorsMap;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = item$iv$iv = iterator2.next();
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new AnnotationProcessorData((String)it.getKey(), (Duration)it.getValue()));
        }
        $this$map$iv = finalNonIncrementalAnnotationProcessors;
        collection2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            item$iv$iv = iterator2.next();
            it = (String)((Object)item$iv$iv);
            Collection collection3 = destination$iv$iv;
            boolean bl = false;
            Duration duration2 = this.annotationProcessorsMap.get(it);
            Intrinsics.checkNotNull((Object)duration2);
            collection3.add(new AnnotationProcessorData(it, duration2));
        }
        List list2 = (List)destination$iv$iv;
        Collection<AnnotationProcessorData> collection4 = collection2;
        return new Result((List<AnnotationProcessorData>)collection4, list2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J)\u0010\f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/build/attribution/analyzers/AnnotationProcessorsAnalyzer$Result;", "Lcom/android/build/attribution/analyzers/AnalyzerResult;", "annotationProcessorsData", "", "Lcom/android/build/attribution/data/AnnotationProcessorData;", "nonIncrementalAnnotationProcessorsData", "(Ljava/util/List;Ljava/util/List;)V", "getAnnotationProcessorsData", "()Ljava/util/List;", "getNonIncrementalAnnotationProcessorsData", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "intellij.android.build-attribution"})
    public static final class Result
    implements AnalyzerResult {
        @NotNull
        private final List<AnnotationProcessorData> annotationProcessorsData;
        @NotNull
        private final List<AnnotationProcessorData> nonIncrementalAnnotationProcessorsData;

        public Result(@NotNull List<AnnotationProcessorData> annotationProcessorsData, @NotNull List<AnnotationProcessorData> nonIncrementalAnnotationProcessorsData) {
            Intrinsics.checkNotNullParameter(annotationProcessorsData, (String)"annotationProcessorsData");
            Intrinsics.checkNotNullParameter(nonIncrementalAnnotationProcessorsData, (String)"nonIncrementalAnnotationProcessorsData");
            this.annotationProcessorsData = annotationProcessorsData;
            this.nonIncrementalAnnotationProcessorsData = nonIncrementalAnnotationProcessorsData;
        }

        @NotNull
        public final List<AnnotationProcessorData> getAnnotationProcessorsData() {
            return this.annotationProcessorsData;
        }

        @NotNull
        public final List<AnnotationProcessorData> getNonIncrementalAnnotationProcessorsData() {
            return this.nonIncrementalAnnotationProcessorsData;
        }

        @NotNull
        public final List<AnnotationProcessorData> component1() {
            return this.annotationProcessorsData;
        }

        @NotNull
        public final List<AnnotationProcessorData> component2() {
            return this.nonIncrementalAnnotationProcessorsData;
        }

        @NotNull
        public final Result copy(@NotNull List<AnnotationProcessorData> annotationProcessorsData, @NotNull List<AnnotationProcessorData> nonIncrementalAnnotationProcessorsData) {
            Intrinsics.checkNotNullParameter(annotationProcessorsData, (String)"annotationProcessorsData");
            Intrinsics.checkNotNullParameter(nonIncrementalAnnotationProcessorsData, (String)"nonIncrementalAnnotationProcessorsData");
            return new Result(annotationProcessorsData, nonIncrementalAnnotationProcessorsData);
        }

        public static /* synthetic */ Result copy$default(Result result2, List list2, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = result2.annotationProcessorsData;
            }
            if ((n & 2) != 0) {
                list3 = result2.nonIncrementalAnnotationProcessorsData;
            }
            return result2.copy(list2, list3);
        }

        @NotNull
        public String toString() {
            return "Result(annotationProcessorsData=" + this.annotationProcessorsData + ", nonIncrementalAnnotationProcessorsData=" + this.nonIncrementalAnnotationProcessorsData + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.annotationProcessorsData).hashCode();
            result2 = result2 * 31 + ((Object)this.nonIncrementalAnnotationProcessorsData).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Result)) {
                return false;
            }
            Result result2 = (Result)other;
            if (!Intrinsics.areEqual(this.annotationProcessorsData, result2.annotationProcessorsData)) {
                return false;
            }
            return Intrinsics.areEqual(this.nonIncrementalAnnotationProcessorsData, result2.nonIncrementalAnnotationProcessorsData);
        }
    }
}

