/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.attribution;

import com.android.build.attribution.BuildAnalysisResults;
import com.android.build.attribution.BuildAnalyzerStorageManager;
import com.android.build.attribution.FailureResult;
import com.android.build.attribution.KnownGradlePluginsService;
import com.android.build.attribution.analytics.BuildAttributionAnalyticsManager;
import com.android.build.attribution.analyzers.BuildAnalyzersWrapper;
import com.android.build.attribution.analyzers.BuildEventsAnalyzersProxy;
import com.android.build.attribution.analyzers.CriticalPathAnalyzer;
import com.android.build.attribution.data.BuildInvocationType;
import com.android.build.attribution.data.BuildRequestHolder;
import com.android.build.attribution.data.GradlePluginsData;
import com.android.build.attribution.data.PluginContainer;
import com.android.build.attribution.data.StudioProvidedInfo;
import com.android.build.attribution.data.TaskContainer;
import com.android.build.attribution.ui.BuildAttributionUiManager;
import com.android.build.attribution.ui.BuildAttributionUiManagerKt;
import com.android.build.attribution.ui.analytics.BuildAttributionUiAnalytics;
import com.android.build.attribution.ui.controllers.ConfigurationCacheTestBuildFlowRunner;
import com.android.buildanalyzer.common.AndroidGradlePluginAttributionData;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.build.attribution.BasicBuildAttributionInfo;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionManager;
import com.android.tools.idea.gradle.project.build.attribution.BuildAttributionUtil;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.utils.FileUtils;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.Closeable;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.tooling.events.ProgressEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\fH\u0002J\u0017\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010!\u001a\u00020\"H\u0002\u00a2\u0006\u0002\u0010'J\u0010\u0010(\u001a\u00020 2\u0006\u0010$\u001a\u00020\fH\u0016J\u0010\u0010)\u001a\u00020 2\u0006\u0010$\u001a\u00020\fH\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010$\u001a\u00020\fH\u0016J\b\u0010,\u001a\u00020 H\u0016J\b\u0010-\u001a\u00020\u0012H\u0016J\u0012\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u000100H\u0016R\u0013\u0010\u0005\u001a\u00020\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\f8GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/build/attribution/BuildAttributionManagerImpl;", "Lcom/android/tools/idea/gradle/project/build/attribution/BuildAttributionManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "analyzersProxy", "Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "getAnalyzersProxy", "()Lcom/android/build/attribution/analyzers/BuildEventsAnalyzersProxy;", "analyzersWrapper", "Lcom/android/build/attribution/analyzers/BuildAnalyzersWrapper;", "currentBuildRequest", "Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;", "getCurrentBuildRequest", "()Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;", "setCurrentBuildRequest", "(Lcom/android/tools/idea/gradle/project/build/invoker/GradleBuildInvoker$Request;)V", "eventsProcessingFailedFlag", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "myCurrentBuildInvocationType", "Lcom/android/build/attribution/data/BuildInvocationType;", "pluginContainer", "Lcom/android/build/attribution/data/PluginContainer;", "getProject", "()Lcom/intellij/openapi/project/Project;", "taskContainer", "Lcom/android/build/attribution/data/TaskContainer;", "cleanup", "", "attributionFileDir", "Ljava/io/File;", "detectBuildType", "request", "getNumberOfPartialResultsGenerated", "", "(Ljava/io/File;)Ljava/lang/Integer;", "onBuildFailure", "onBuildStart", "onBuildSuccess", "Lcom/android/tools/idea/gradle/project/build/attribution/BasicBuildAttributionInfo;", "openResultsTab", "shouldShowBuildOutputLink", "statusChanged", "event", "Lorg/gradle/tooling/events/ProgressEvent;", "intellij.android.build-attribution"})
public final class BuildAttributionManagerImpl
implements BuildAttributionManager {
    @NotNull
    private final Project project;
    @NotNull
    private final TaskContainer taskContainer;
    @NotNull
    private final PluginContainer pluginContainer;
    private boolean eventsProcessingFailedFlag;
    @NotNull
    private BuildInvocationType myCurrentBuildInvocationType;
    @NotNull
    private final BuildEventsAnalyzersProxy analyzersProxy;
    public GradleBuildInvoker.Request currentBuildRequest;
    @NotNull
    private final BuildAnalyzersWrapper analyzersWrapper;

    public BuildAttributionManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.taskContainer = new TaskContainer();
        this.pluginContainer = new PluginContainer();
        this.myCurrentBuildInvocationType = BuildInvocationType.REGULAR_BUILD;
        this.analyzersProxy = new BuildEventsAnalyzersProxy(this.taskContainer, this.pluginContainer);
        this.analyzersWrapper = new BuildAnalyzersWrapper(this.analyzersProxy.getBuildAnalyzers(), this.taskContainer, this.pluginContainer);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final Logger getLog() {
        Logger logger2 = Logger.getInstance((String)"Build Analyzer");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(\"Build Analyzer\")");
        return logger2;
    }

    @VisibleForTesting
    @NotNull
    public final BuildEventsAnalyzersProxy getAnalyzersProxy() {
        return this.analyzersProxy;
    }

    @VisibleForTesting
    @NotNull
    public final GradleBuildInvoker.Request getCurrentBuildRequest() {
        GradleBuildInvoker.Request request2 = this.currentBuildRequest;
        if (request2 != null) {
            return request2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"currentBuildRequest");
        return null;
    }

    public final void setCurrentBuildRequest(@NotNull GradleBuildInvoker.Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"<set-?>");
        this.currentBuildRequest = request2;
    }

    @Override
    public void onBuildStart(@NotNull GradleBuildInvoker.Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        this.setCurrentBuildRequest(request2);
        this.eventsProcessingFailedFlag = false;
        this.myCurrentBuildInvocationType = this.detectBuildType(request2);
        this.analyzersWrapper.onBuildStart();
        ((KnownGradlePluginsService)ApplicationManager.getApplication().getService(KnownGradlePluginsService.class)).asyncRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public BasicBuildAttributionInfo onBuildSuccess(@NotNull GradleBuildInvoker.Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        long buildFinishedTimestamp = System.currentTimeMillis();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String buildSessionId = string;
        BuildRequestHolder buildRequestHolder = new BuildRequestHolder(request2);
        File attributionFileDir = BuildAttributionUtil.getAgpAttributionFileDir(request2.getData());
        Ref.ObjectRef agpVersion = new Ref.ObjectRef();
        Closeable closeable = new BuildAttributionAnalyticsManager(buildSessionId, this.project);
        Throwable throwable = null;
        try {
            BuildAttributionAnalyticsManager analyticsManager = (BuildAttributionAnalyticsManager)closeable;
            boolean bl = false;
            analyticsManager.runLoggingPerformanceStats(buildFinishedTimestamp - ((CriticalPathAnalyzer.Result)this.analyzersProxy.getCriticalPathAnalyzer().getResult()).getBuildFinishedTimestamp(), this.getNumberOfPartialResultsGenerated(attributionFileDir), (Function0<Unit>)((Function0)new Function0<Unit>(attributionFileDir, (Ref.ObjectRef<AgpVersion>)agpVersion, this, buildRequestHolder, buildSessionId, analyticsManager){
                final /* synthetic */ File $attributionFileDir;
                final /* synthetic */ Ref.ObjectRef<AgpVersion> $agpVersion;
                final /* synthetic */ BuildAttributionManagerImpl this$0;
                final /* synthetic */ BuildRequestHolder $buildRequestHolder;
                final /* synthetic */ String $buildSessionId;
                final /* synthetic */ BuildAttributionAnalyticsManager $analyticsManager;
                {
                    this.$attributionFileDir = $attributionFileDir;
                    this.$agpVersion = $agpVersion;
                    this.this$0 = $receiver;
                    this.$buildRequestHolder = $buildRequestHolder;
                    this.$buildSessionId = $buildSessionId;
                    this.$analyticsManager = $analyticsManager;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    try {
                        AgpVersion agpVersion;
                        AndroidGradlePluginAttributionData attributionData = AndroidGradlePluginAttributionData.Companion.load(this.$attributionFileDir);
                        Ref.ObjectRef<AgpVersion> objectRef = this.$agpVersion;
                        Object object = attributionData;
                        if (object != null && (object = object.getBuildInfo()) != null && (object = object.getAgpVersion()) != null) {
                            void it;
                            Object object2 = object;
                            Ref.ObjectRef<AgpVersion> objectRef2 = objectRef;
                            boolean bl = false;
                            agpVersion = AgpVersion.Companion.tryParse((String)it);
                            objectRef = objectRef2;
                        } else {
                            agpVersion = null;
                        }
                        objectRef.element = agpVersion;
                        GradlePluginsData pluginsData = ((KnownGradlePluginsService)ApplicationManager.getApplication().getService(KnownGradlePluginsService.class)).getGradlePluginsData();
                        StudioProvidedInfo studioProvidedInfo = StudioProvidedInfo.Companion.fromProject(this.this$0.getProject(), this.$buildRequestHolder, BuildAttributionManagerImpl.access$getMyCurrentBuildInvocationType$p(this.this$0));
                        if (!BuildAttributionManagerImpl.access$getEventsProcessingFailedFlag$p(this.this$0)) {
                            BuildAttributionManagerImpl.access$getAnalyzersWrapper$p(this.this$0).onBuildSuccess(attributionData, pluginsData, this.this$0.getAnalyzersProxy(), studioProvidedInfo);
                            Future<BuildAnalysisResults> analysisResults = BuildAnalyzerStorageManager.Companion.getInstance(this.this$0.getProject()).storeNewBuildResults(this.this$0.getAnalyzersProxy(), this.$buildSessionId, new BuildRequestHolder(this.this$0.getCurrentBuildRequest()));
                            BuildAnalysisResults buildAnalysisResults = analysisResults.get();
                            Intrinsics.checkNotNullExpressionValue((Object)buildAnalysisResults, (String)"analysisResults.get()");
                            this.$analyticsManager.logAnalyzersData(buildAnalysisResults);
                            this.$analyticsManager.logBuildSuccess(BuildAttributionManagerImpl.access$getMyCurrentBuildInvocationType$p(this.this$0));
                        } else {
                            this.$analyticsManager.logAnalysisFailure(BuildAttributionManagerImpl.access$getMyCurrentBuildInvocationType$p(this.this$0));
                            BuildAnalyzerStorageManager.Companion.getInstance(this.this$0.getProject()).recordNewFailure(this.$buildSessionId, FailureResult.Type.ANALYSIS_FAILURE);
                        }
                    }
                    catch (Throwable t) {
                        BuildAttributionManagerImpl.access$getLog(this.this$0).error("Error during post-build analysis", t);
                        this.$analyticsManager.logAnalysisFailure(BuildAttributionManagerImpl.access$getMyCurrentBuildInvocationType$p(this.this$0));
                        BuildAnalyzerStorageManager.Companion.getInstance(this.this$0.getProject()).recordNewFailure(this.$buildSessionId, FailureResult.Type.ANALYSIS_FAILURE);
                    }
                    finally {
                        BuildAttributionManagerImpl.access$cleanup(this.this$0, this.$attributionFileDir);
                    }
                }
            }));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new BasicBuildAttributionInfo((AgpVersion)agpVersion.element);
    }

    @Override
    public void onBuildFailure(@NotNull GradleBuildInvoker.Request request2) {
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        this.cleanup(BuildAttributionUtil.getAgpAttributionFileDir(request2.getData()));
        BuildAttributionUiManagerKt.invokeLaterIfNotDisposed(this.project, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ BuildAttributionManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                String string = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
                String buildSessionId = string;
                Closeable closeable = new BuildAttributionAnalyticsManager(buildSessionId, this.this$0.getProject());
                BuildAttributionManagerImpl buildAttributionManagerImpl = this.this$0;
                Throwable throwable = null;
                try {
                    BuildAttributionAnalyticsManager analyticsManager = (BuildAttributionAnalyticsManager)closeable;
                    boolean bl = false;
                    analyticsManager.logBuildFailure(BuildAttributionManagerImpl.access$getMyCurrentBuildInvocationType$p(buildAttributionManagerImpl));
                    BuildAttributionManagerImpl.access$getAnalyzersWrapper$p(buildAttributionManagerImpl).onBuildFailure();
                    BuildAnalyzerStorageManager.Companion.getInstance(buildAttributionManagerImpl.getProject()).recordNewFailure(buildSessionId, FailureResult.Type.BUILD_FAILURE);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }));
    }

    private final void cleanup(File attributionFileDir) {
        try {
            String[] stringArray = new String[]{"build-attribution"};
            FileUtils.deleteRecursivelyIfExists((File)FileUtils.join((File)attributionFileDir, (String[])stringArray));
        }
        catch (Throwable t) {
            this.getLog().error("Error during build attribution files cleanup", t);
        }
    }

    public void statusChanged(@Nullable ProgressEvent event) {
        if (this.eventsProcessingFailedFlag) {
            return;
        }
        try {
            if (event == null) {
                return;
            }
            this.analyzersWrapper.receiveEvent(event);
        }
        catch (Throwable t) {
            this.eventsProcessingFailedFlag = true;
            this.getLog().error("Error during build events processing", t);
        }
    }

    @Override
    public void openResultsTab() {
        BuildAttributionUiManager.Companion.getInstance(this.project).openTab(BuildAttributionUiAnalytics.TabOpenEventSource.BUILD_OUTPUT_LINK);
    }

    @Override
    public boolean shouldShowBuildOutputLink() {
        return !ConfigurationCacheTestBuildFlowRunner.Companion.getInstance(this.project).getRunningFirstConfigurationCacheBuild() && !this.eventsProcessingFailedFlag;
    }

    private final BuildInvocationType detectBuildType(GradleBuildInvoker.Request request2) {
        return ConfigurationCacheTestBuildFlowRunner.Companion.getInstance(this.project).isTestConfigurationCacheBuild(request2) ? BuildInvocationType.CONFIGURATION_CACHE_TRIAL : (request2.getGradleTasks().contains("checkJetifier") ? BuildInvocationType.CHECK_JETIFIER : BuildInvocationType.REGULAR_BUILD);
    }

    private final Integer getNumberOfPartialResultsGenerated(File attributionFileDir) {
        Comparable<Integer> comparable;
        try {
            File[] fileArray;
            File[] it = fileArray = AndroidGradlePluginAttributionData.Companion.getPartialResultsDir(attributionFileDir);
            boolean bl = false;
            comparable = it.exists() ? fileArray : null;
            comparable = comparable != null && (fileArray = ((File)comparable).listFiles()) != null ? Integer.valueOf(fileArray.length) : null;
        }
        catch (Exception e) {
            comparable = null;
        }
        return comparable;
    }

    public static final /* synthetic */ BuildInvocationType access$getMyCurrentBuildInvocationType$p(BuildAttributionManagerImpl $this) {
        return $this.myCurrentBuildInvocationType;
    }

    public static final /* synthetic */ BuildAnalyzersWrapper access$getAnalyzersWrapper$p(BuildAttributionManagerImpl $this) {
        return $this.analyzersWrapper;
    }

    public static final /* synthetic */ boolean access$getEventsProcessingFailedFlag$p(BuildAttributionManagerImpl $this) {
        return $this.eventsProcessingFailedFlag;
    }

    public static final /* synthetic */ Logger access$getLog(BuildAttributionManagerImpl $this) {
        return $this.getLog();
    }

    public static final /* synthetic */ void access$cleanup(BuildAttributionManagerImpl $this, File attributionFileDir) {
        $this.cleanup(attributionFileDir);
    }
}

