/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.view;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SyncIssues;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseBundle;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.FirebaseErrorDetails;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class FirebaseUiUtils {
    public static final String TOS_ENGLISH_LANGUAGE_TAG = "en-US";
    public static final String FIREBASE_NOTIFICATION_TITLE = FirebaseBundle.message("firebase.service.notification.title", new Object[0]);
    public static final String FIREBASE_CONFIG_JSON_FILE_NAME = "google-services.json";

    public static void showWarningBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.WARNING);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void showTrackedErrorBalloon(@NotNull Project project, @Nullable Throwable throwable, @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey, Object ... messageArguments) {
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_ERROR_PRESENTED).withProject(project).withErrorDetails(FirebaseErrorDetails.newBuilder().setErrorMessage(messageKey)).log();
        String message = FirebaseBundle.message(messageKey, messageArguments);
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.ERROR);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void logSilentError(@NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") @NotNull @PropertyKey(resourceBundle="messages.FirebaseBundle") String messageKey) {
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_SILENT_ERROR).withErrorDetails(FirebaseErrorDetails.newBuilder().setErrorMessage(messageKey)).log();
    }

    public static void showErrorBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.ERROR);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void showInfoBalloon(@NotNull Project project, @NotNull String message, @Nullable Throwable throwable) {
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.INFORMATION);
        if (throwable != null) {
            FirebaseUiUtils.getLog().warn(message, throwable);
        }
    }

    public static void showInfoBalloonWithLink(@NotNull Project project, @NotNull String message, @NotNull OpenUrlHyperlink hiperlink) {
        AndroidNotification.getInstance((Project)project).showBalloon(FIREBASE_NOTIFICATION_TITLE, message, NotificationType.INFORMATION, new NotificationHyperlink[]{hiperlink});
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseUiUtils.class);
    }

    public static void checkGradleState(@NotNull Module androidModule) throws GradleStateException {
        AndroidModuleModel androidModuleModel = AndroidModuleModel.get((Module)androidModule);
        if (androidModuleModel == null) {
            throw new GradleStateException("Android Gradle Model not found.");
        }
        if (SyncIssues.forModule((Module)androidModule).stream().anyMatch(issue -> issue.getSeverity() >= 2)) {
            throw new GradleStateException("Android Gradle sync issues are not fully resolved");
        }
        if (GradleSyncState.getInstance((Project)androidModule.getProject()).isSyncNeeded().equals((Object)ThreeState.YES)) {
            throw new GradleStateException("Gradle sync needs to be performed.");
        }
    }

    public static class GradleStateException
    extends Exception {
        GradleStateException(String message) {
            super(message);
        }
    }
}

