/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.mobilesdk;

import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.MobileSdkWrapperImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class MobileSdkUtil {
    static final String DEFAULT_PROJECT_NAME = "FirebaseProject";
    private static final String VALID_PACKAGE_NAME_REGEX = "^[a-zA-Z]{1}[a-zA-Z0-9_]*(\\.[a-zA-Z]{1}[a-zA-Z0-9_]*)+$";
    private static final String VALID_SHA1_FINGERPRINT_REGEX = "^(([0-9a-fA-F]{2}:){19}|([0-9a-fA-F]{2}){19})([0-9a-fA-F]){2}$";
    private static final String VALID_PROJECT_NAME_VALID_CHARS_REGEX = "[0-9a-zA-Z\\-'\" !]";
    private static final String VALID_PROJECT_NAME_REGEX = "^[0-9a-zA-Z\\-'\" !]{4,30}$";
    private static final String VALID_PROJECT_NAME_VALID_CHAR_REGEX_WITH_CAPTURE_GROUP = "([0-9a-zA-Z\\-'\" !]+)+";
    static final Pattern PROJECT_NAME_PATTERN_CAPTURING_VALID_CHARS = Pattern.compile("([0-9a-zA-Z\\-'\" !]+)+");
    private static final Pattern VALID_PROJECT_NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z\\-'\" !]{4,30}$");
    private static final Pattern VALID_SHA1_FINGERPRINT_PATTERN = Pattern.compile("^(([0-9a-fA-F]{2}:){19}|([0-9a-fA-F]{2}){19})([0-9a-fA-F]){2}$");
    private static final Pattern VALID_PACKAGE_NAME_PATTERN = Pattern.compile("^[a-zA-Z]{1}[a-zA-Z0-9_]*(\\.[a-zA-Z]{1}[a-zA-Z0-9_]*)+$");
    private static final int MILLIS_IN_DAY = 3600000;
    private static volatile MobileSdkWrapper ourOverrideSdkWrapper = null;

    public static boolean isValidPackageName(@NotNull String packageName) {
        return VALID_PACKAGE_NAME_PATTERN.matcher(packageName).matches();
    }

    public static boolean isValidSha1Fingerprint(@NotNull String sha1) {
        return VALID_SHA1_FINGERPRINT_PATTERN.matcher(sha1).matches();
    }

    public static boolean isValidProjectName(@NotNull String projectName) {
        return VALID_PROJECT_NAME_PATTERN.matcher(projectName).matches();
    }

    public static String getValidProjectName(@NotNull String projectName) {
        if (MobileSdkUtil.isValidProjectName(projectName)) {
            return projectName;
        }
        Matcher matcher = PROJECT_NAME_PATTERN_CAPTURING_VALID_CHARS.matcher(projectName);
        StringBuilder newString = new StringBuilder();
        if (matcher.find()) {
            do {
                newString.append(matcher.group());
            } while (matcher.find());
        } else {
            String newProjectName = DEFAULT_PROJECT_NAME;
            MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
            return newProjectName;
        }
        String newProjectName = newString.toString();
        if (MobileSdkUtil.isValidProjectName(newProjectName)) {
            MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
            return newProjectName;
        }
        newString.append(DEFAULT_PROJECT_NAME);
        newProjectName = newString.toString();
        if (MobileSdkUtil.isValidProjectName(newProjectName)) {
            MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
            return newProjectName;
        }
        newProjectName = newProjectName.substring(0, 30);
        MobileSdkUtil.getLog().warn("Project name " + projectName + " translated to: " + newProjectName);
        return newProjectName;
    }

    public static MobileSdkWrapper getNewMobileSdkWrapper(@NotNull GoogleLogin googleLogin) throws MobileSdkCommException {
        if (ourOverrideSdkWrapper != null) {
            return ourOverrideSdkWrapper;
        }
        MobileSdkWrapperImpl.Builder builder = new MobileSdkWrapperImpl.Builder(googleLogin);
        return builder.build();
    }

    static void setMobileSdkWrapperOverride(MobileSdkWrapper wrapper) {
        ourOverrideSdkWrapper = wrapper;
    }

    private static Logger getLog() {
        return Logger.getInstance(MobileSdkUtil.class);
    }

    @NotNull
    public static String getRegionCode() {
        return Locale.getDefault().getCountry();
    }

    static int getTimeZoneId(int utcOffsetInHours) {
        return 406 - utcOffsetInHours;
    }

    private static int getCurrentUTCTimeZoneOffsetMillis() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getOffset(new Date().getTime());
    }

    public static int getCurrentTimeZoneId() {
        int hourOffset = MobileSdkUtil.getCurrentUTCTimeZoneOffsetMillis() / 3600000;
        int timeZoneId = MobileSdkUtil.getTimeZoneId(hourOffset);
        MobileSdkUtil.getLog().debug("TimeZoneID returned: " + timeZoneId);
        return timeZoneId;
    }
}

