/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.logs;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.services.firebase.insights.datamodel.ConnectionMode;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import com.intellij.openapi.project.Project;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0018H\u0016J \u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\u00020\u000b2\b\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020%H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/google/services/firebase/logs/FirebaseTrackerImpl;", "Lcom/google/services/firebase/logs/FirebaseTracker;", "()V", "APP_ID_SALT", "", "generateAndroidStudioEventBuilder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "getAppId", "", "appId", "logConsoleLinkClicked", "", "project", "Lcom/intellij/openapi/project/Project;", "mode", "Lcom/google/services/firebase/insights/datamodel/ConnectionMode;", "event", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsConsoleLinkDetails;", "logCrashListDetailView", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsCrashOpenDetails;", "logCrashesFetched", "projectName", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsFetchDetails;", "logError", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsErrorDetails;", "logIssueStatusChanged", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsIssueChangedDetails;", "logMatchers", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsMatcherDetails;", "logNotesAction", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsNotesDetails;", "logOfflineTransitionAction", "packageName", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsModeTransitionDetails;", "logStacktraceClicked", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsStacktraceDetails;", "logZeroState", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsZeroStateDetails;", "firebase"})
public final class FirebaseTrackerImpl
implements FirebaseTracker {
    @NotNull
    public static final FirebaseTrackerImpl INSTANCE = new FirebaseTrackerImpl();
    private static final int APP_ID_SALT = new Random().nextInt();

    private FirebaseTrackerImpl() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logZeroState(@NotNull Project project, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails event) {
        void $this$logZeroState_u24lambda_u2d0;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.getName()");
        $this$logZeroState_u24lambda_u2d0.setAppId(INSTANCE.getAppId(string));
        $this$logZeroState_u24lambda_u2d0.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.ZERO_STATE);
        $this$logZeroState_u24lambda_u2d0.setZeroStateDetails(event);
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026ent\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder4, (Project)project));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logCrashesFetched(@NotNull String projectName, @NotNull ConnectionMode mode, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails event) {
        void $this$logCrashesFetched_u24lambda_u2d1;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        $this$logCrashesFetched_u24lambda_u2d1.setAppId(INSTANCE.getAppId(projectName));
        $this$logCrashesFetched_u24lambda_u2d1.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.CRASHES_FETCHED);
        $this$logCrashesFetched_u24lambda_u2d1.setFetchDetails(event);
        $this$logCrashesFetched_u24lambda_u2d1.setIsOffline(mode.isOfflineMode$firebase());
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026e()\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logCrashListDetailView(@NotNull Project project, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsCrashOpenDetails event) {
        void $this$logCrashListDetailView_u24lambda_u2d2;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.getName()");
        $this$logCrashListDetailView_u24lambda_u2d2.setAppId(INSTANCE.getAppId(string));
        $this$logCrashListDetailView_u24lambda_u2d2.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.CRASH_LIST_DETAILS_VIEW);
        $this$logCrashListDetailView_u24lambda_u2d2.setCrashOpenDetails(event);
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026ent\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder4, (Project)project));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logStacktraceClicked(@NotNull Project project, @NotNull ConnectionMode mode, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsStacktraceDetails event) {
        void $this$logStacktraceClicked_u24lambda_u2d3;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.getName()");
        $this$logStacktraceClicked_u24lambda_u2d3.setAppId(INSTANCE.getAppId(string));
        $this$logStacktraceClicked_u24lambda_u2d3.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.STACKTRACE_CLICKED);
        $this$logStacktraceClicked_u24lambda_u2d3.setStacktraceDetails(event);
        $this$logStacktraceClicked_u24lambda_u2d3.setIsOffline(mode.isOfflineMode$firebase());
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026e()\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder4, (Project)project));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logConsoleLinkClicked(@NotNull Project project, @NotNull ConnectionMode mode, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsConsoleLinkDetails event) {
        void $this$logConsoleLinkClicked_u24lambda_u2d4;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.getName()");
        $this$logConsoleLinkClicked_u24lambda_u2d4.setAppId(INSTANCE.getAppId(string));
        $this$logConsoleLinkClicked_u24lambda_u2d4.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.FB_CONSOLE_LINK_CLICKED);
        $this$logConsoleLinkClicked_u24lambda_u2d4.setConsoleLinkDetails(event);
        $this$logConsoleLinkClicked_u24lambda_u2d4.setIsOffline(mode.isOfflineMode$firebase());
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026e()\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder4, (Project)project));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logMatchers(@NotNull Project project, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsMatcherDetails event) {
        void $this$logMatchers_u24lambda_u2d5;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.getName()");
        $this$logMatchers_u24lambda_u2d5.setAppId(INSTANCE.getAppId(string));
        $this$logMatchers_u24lambda_u2d5.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.MATCHERS_INITIATED);
        $this$logMatchers_u24lambda_u2d5.setMatcherDetails(event);
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026ent\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder4, (Project)project));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logError(@NotNull Project project, @NotNull ConnectionMode mode, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsErrorDetails event) {
        void $this$logError_u24lambda_u2d6;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        String string = project.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.getName()");
        $this$logError_u24lambda_u2d6.setAppId(INSTANCE.getAppId(string));
        $this$logError_u24lambda_u2d6.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.ERROR);
        $this$logError_u24lambda_u2d6.setErrorDetails(event);
        $this$logError_u24lambda_u2d6.setIsOffline(mode.isOfflineMode$firebase());
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026e()\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)builder4, (Project)project));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logIssueStatusChanged(@NotNull String projectName, @NotNull ConnectionMode mode, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsIssueChangedDetails event) {
        void $this$logIssueStatusChanged_u24lambda_u2d7;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        $this$logIssueStatusChanged_u24lambda_u2d7.setAppId(INSTANCE.getAppId(projectName));
        $this$logIssueStatusChanged_u24lambda_u2d7.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.ISSUE_STATUS_CHANGED);
        $this$logIssueStatusChanged_u24lambda_u2d7.setIssueChangedDetails(event);
        $this$logIssueStatusChanged_u24lambda_u2d7.setIsOffline(mode.isOfflineMode$firebase());
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026e()\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logNotesAction(@NotNull String projectName, @NotNull ConnectionMode mode, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsNotesDetails event) {
        void $this$logNotesAction_u24lambda_u2d8;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        $this$logNotesAction_u24lambda_u2d8.setAppId(INSTANCE.getAppId(projectName));
        $this$logNotesAction_u24lambda_u2d8.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.NOTE);
        $this$logNotesAction_u24lambda_u2d8.setNotesDetails(event);
        $this$logNotesAction_u24lambda_u2d8.setIsOffline(mode.isOfflineMode$firebase());
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026e()\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logOfflineTransitionAction(@Nullable String packageName, @NotNull ConnectionMode mode, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsModeTransitionDetails event) {
        String string;
        void $this$logOfflineTransitionAction_u24lambda_u2d10;
        AppQualityInsightsUsageEvent.Builder builder;
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (mode.isOfflineMode$firebase() && event.ordinal() == AppQualityInsightsUsageEvent.AppQualityInsightsModeTransitionDetails.ONLINE_TO_OFFLINE.ordinal() || !mode.isOfflineMode$firebase() && event.ordinal() == AppQualityInsightsUsageEvent.AppQualityInsightsModeTransitionDetails.OFFLINE_TO_ONLINE.ordinal()) {
            return;
        }
        AppQualityInsightsUsageEvent.Builder builder2 = builder = AppQualityInsightsUsageEvent.newBuilder();
        AndroidStudioEvent.Builder builder3 = this.generateAndroidStudioEventBuilder();
        boolean bl = false;
        void v0 = $this$logOfflineTransitionAction_u24lambda_u2d10;
        String string2 = packageName;
        if (string2 != null) {
            void it;
            String string3 = string2;
            void var8_9 = v0;
            boolean bl2 = false;
            string = INSTANCE.getAppId((String)it);
            v0 = var8_9;
        } else {
            string = null;
        }
        v0.setAppId(string);
        $this$logOfflineTransitionAction_u24lambda_u2d10.setType(AppQualityInsightsUsageEvent.AppQualityInsightsUsageEventType.MODE_TRANSITION);
        $this$logOfflineTransitionAction_u24lambda_u2d10.setModeTransitionDetails(event);
        $this$logOfflineTransitionAction_u24lambda_u2d10.setIsOffline(mode.isOfflineMode$firebase());
        AndroidStudioEvent.Builder builder4 = builder3.setAppQualityInsightsUsageEvent(builder);
        Intrinsics.checkNotNullExpressionValue((Object)builder4, (String)"generateAndroidStudioEve\u2026e()\n          }\n        )");
        UsageTracker.log((AndroidStudioEvent.Builder)builder4);
    }

    private final AndroidStudioEvent.Builder generateAndroidStudioEventBuilder() {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.FIREBASE_ASSISTANT).setKind(AndroidStudioEvent.EventKind.APP_QUALITY_INSIGHTS_USAGE);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n      .setC\u2026P_QUALITY_INSIGHTS_USAGE)");
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    private final String getAppId(String appId) {
        void $this$fold$iv;
        String string = appId + APP_ID_SALT;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(bytes);
        Intrinsics.checkNotNullExpressionValue((Object)digest, (String)"digest");
        byte[] byArray2 = digest;
        String initial$iv = "";
        boolean $i$f$fold = false;
        Object accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var12_12 = element$iv = $this$fold$iv[i];
            String str = accumulator$iv;
            boolean bl = false;
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
            accumulator$iv = str + string3;
        }
        return accumulator$iv;
    }
}

