/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.google.services.firebase.insights.datamodel.Fatality;
import com.google.services.firebase.insights.datamodel.IssueDetails;
import com.google.services.firebase.insights.ui.AppInsightsIssuesTableCellRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.LayoutManager;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u001a*\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0015\u001a\u0006\u0010\u0019\u001a\u00020\u001a\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0016\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001f0\u001e*\u00020 \u001a\u0014\u0010!\u001a\u00020\u001f*\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u001f\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u001c\u0010\u0006\u001a\n \u0007*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0003\"\u0014\u0010\t\u001a\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006$"}, d2={"EMPTY_STATE_LINK_FORMAT", "Lcom/intellij/ui/SimpleTextAttributes;", "getEMPTY_STATE_LINK_FORMAT", "()Lcom/intellij/ui/SimpleTextAttributes;", "EMPTY_STATE_TEXT_FORMAT", "getEMPTY_STATE_TEXT_FORMAT", "EMPTY_STATE_TITLE_FORMAT", "kotlin.jvm.PlatformType", "getEMPTY_STATE_TITLE_FORMAT", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "offlineModeIcon", "Ljavax/swing/Icon;", "getOfflineModeIcon", "()Ljavax/swing/Icon;", "getFatalityIcon", "fatality", "Lcom/google/services/firebase/insights/datamodel/Fatality;", "selected", "", "foreground", "Ljava/awt/Color;", "withNote", "transparentPanel", "Ljavax/swing/JPanel;", "layout", "Ljava/awt/LayoutManager;", "getDisplayTitle", "Lkotlin/Pair;", "", "Lcom/google/services/firebase/insights/datamodel/IssueDetails;", "ifZero", "", "fallback", "firebase"})
public final class UiUtilKt {
    @NotNull
    private static final Icon offlineModeIcon;
    private static final SimpleTextAttributes EMPTY_STATE_TITLE_FORMAT;
    @NotNull
    private static final SimpleTextAttributes EMPTY_STATE_TEXT_FORMAT;
    @NotNull
    private static final SimpleTextAttributes EMPTY_STATE_LINK_FORMAT;

    @NotNull
    public static final JPanel transparentPanel() {
        JPanel jPanel;
        JPanel $this$transparentPanel_u24lambda_u2d0 = jPanel = new JPanel();
        boolean bl = false;
        $this$transparentPanel_u24lambda_u2d0.setOpaque(false);
        return jPanel;
    }

    @NotNull
    public static final JPanel transparentPanel(@NotNull LayoutManager layout) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        JPanel $this$transparentPanel_u24lambda_u2d1 = jPanel = new JPanel(layout);
        boolean bl = false;
        $this$transparentPanel_u24lambda_u2d1.setOpaque(false);
        return jPanel;
    }

    @NotNull
    public static final Pair<String, String> getDisplayTitle(@NotNull IssueDetails $this$getDisplayTitle) {
        Intrinsics.checkNotNullParameter((Object)$this$getDisplayTitle, (String)"<this>");
        Object object = new char[]{'.'};
        List splitSubtitle = StringsKt.split$default((CharSequence)$this$getDisplayTitle.getSubtitle(), (char[])object, (boolean)false, (int)0, (int)6, null);
        if (splitSubtitle.size() < 2) {
            AppInsightsIssuesTableCellRenderer.INSTANCE.getLOGGER().warn("Failed to format subtitle: " + $this$getDisplayTitle.getSubtitle());
            return TuplesKt.to((Object)$this$getDisplayTitle.getTitle(), (Object)"");
        }
        object = CollectionsKt.takeLast((List)splitSubtitle, (int)2);
        String className = (String)object.get(0);
        String methodName = (String)object.get(1);
        return TuplesKt.to((Object)className, (Object)methodName);
    }

    @Nullable
    public static final Icon getFatalityIcon(@NotNull Fatality fatality, boolean selected, @NotNull Color foreground, boolean withNote) {
        Intrinsics.checkNotNullParameter((Object)((Object)fatality), (String)"fatality");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        Icon icon = fatality.getIcon(withNote);
        return icon == null ? (Icon)null : (selected ? ColoredIconGenerator.INSTANCE.generateColoredIcon(icon, foreground) : icon);
    }

    public static /* synthetic */ Icon getFatalityIcon$default(Fatality fatality, boolean bl, Color color, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return UiUtilKt.getFatalityIcon(fatality, bl, color, bl2);
    }

    @NotNull
    public static final Icon getOfflineModeIcon() {
        return offlineModeIcon;
    }

    @NotNull
    public static final String ifZero(@Nullable Object $this$ifZero, @NotNull String fallback) {
        String string;
        Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
        String it = string = String.valueOf($this$ifZero);
        boolean bl = false;
        String string2 = !Intrinsics.areEqual((Object)it, (Object)"0") ? string : null;
        if (string2 == null) {
            string2 = fallback;
        }
        return string2;
    }

    @NotNull
    public static final DateTimeFormatter getDateFormatter() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("MMM d, yyyy, hh:mm:ss a").withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(\"MMM d, yyyy, \u2026e(ZoneId.systemDefault())");
        return dateTimeFormatter;
    }

    public static final SimpleTextAttributes getEMPTY_STATE_TITLE_FORMAT() {
        return EMPTY_STATE_TITLE_FORMAT;
    }

    @NotNull
    public static final SimpleTextAttributes getEMPTY_STATE_TEXT_FORMAT() {
        return EMPTY_STATE_TEXT_FORMAT;
    }

    @NotNull
    public static final SimpleTextAttributes getEMPTY_STATE_LINK_FORMAT() {
        return EMPTY_STATE_LINK_FORMAT;
    }

    static {
        Icon icon = AllIcons.Actions.OfflineMode;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"OfflineMode");
        Color color = UIUtil.getErrorForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getErrorForeground()");
        offlineModeIcon = ColoredIconGenerator.INSTANCE.generateColoredIcon(icon, color);
        EMPTY_STATE_TITLE_FORMAT = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
        EMPTY_STATE_TEXT_FORMAT = new SimpleTextAttributes(128, UIUtil.getInactiveTextColor());
        EMPTY_STATE_LINK_FORMAT = new SimpleTextAttributes(0x80 | SimpleTextAttributes.LINK_ATTRIBUTES.getStyle(), SimpleTextAttributes.LINK_ATTRIBUTES.getFgColor());
    }
}

