/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.google.services.firebase.insights.ui.TimestampState;
import com.intellij.util.text.DateFormatUtil;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u001f\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u000e\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014J\t\u0010\u001a\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/google/services/firebase/insights/ui/Timestamp;", "", "time", "Ljava/time/Instant;", "state", "Lcom/google/services/firebase/insights/ui/TimestampState;", "(Ljava/time/Instant;Lcom/google/services/firebase/insights/ui/TimestampState;)V", "getState", "()Lcom/google/services/firebase/insights/ui/TimestampState;", "getTime", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "getHowLongAgo", "", "timeMs", "", "nowMs", "(Ljava/lang/Long;J)Ljava/lang/String;", "hashCode", "", "toDisplayString", "toString", "Companion", "firebase"})
public final class Timestamp {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Instant time;
    @NotNull
    private final TimestampState state;
    @NotNull
    private static final String TEXT_NEVER = "never";
    @NotNull
    private static final String TEXT_REFRESHING = "Refreshing...";
    @NotNull
    private static final Timestamp UNINITIALIZED = new Timestamp(null, TimestampState.UNINITIALIZED);

    public Timestamp(@Nullable Instant time, @NotNull TimestampState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.time = time;
        this.state = state;
    }

    @Nullable
    public final Instant getTime() {
        return this.time;
    }

    @NotNull
    public final TimestampState getState() {
        return this.state;
    }

    @NotNull
    public final String toDisplayString(long nowMs) {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                object = TEXT_REFRESHING;
                break;
            }
            case 2: {
                Instant instant = this.time;
                object = "Currently offline. Last refreshed: " + this.getHowLongAgo(instant != null ? Long.valueOf(instant.toEpochMilli()) : null, nowMs);
                break;
            }
            default: {
                Instant instant = this.time;
                object = "Last refreshed: " + this.getHowLongAgo(instant != null ? Long.valueOf(instant.toEpochMilli()) : null, nowMs);
            }
        }
        return object;
    }

    private final String getHowLongAgo(Long timeMs, long nowMs) {
        String string;
        String string2;
        Long l = timeMs;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            string2 = DateFormatUtil.formatBetweenDates((long)it, (long)nowMs);
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = TEXT_NEVER;
        }
        return string;
    }

    @Nullable
    public final Instant component1() {
        return this.time;
    }

    @NotNull
    public final TimestampState component2() {
        return this.state;
    }

    @NotNull
    public final Timestamp copy(@Nullable Instant time, @NotNull TimestampState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new Timestamp(time, state);
    }

    public static /* synthetic */ Timestamp copy$default(Timestamp timestamp, Instant instant, TimestampState timestampState, int n, Object object) {
        if ((n & 1) != 0) {
            instant = timestamp.time;
        }
        if ((n & 2) != 0) {
            timestampState = timestamp.state;
        }
        return timestamp.copy(instant, timestampState);
    }

    @NotNull
    public String toString() {
        return "Timestamp(time=" + this.time + ", state=" + this.state + ")";
    }

    public int hashCode() {
        int result2 = this.time == null ? 0 : this.time.hashCode();
        result2 = result2 * 31 + this.state.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Timestamp)) {
            return false;
        }
        Timestamp timestamp = (Timestamp)other;
        if (!Intrinsics.areEqual((Object)this.time, (Object)timestamp.time)) {
            return false;
        }
        return this.state == timestamp.state;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/google/services/firebase/insights/ui/Timestamp$Companion;", "", "()V", "TEXT_NEVER", "", "TEXT_REFRESHING", "UNINITIALIZED", "Lcom/google/services/firebase/insights/ui/Timestamp;", "getUNINITIALIZED", "()Lcom/google/services/firebase/insights/ui/Timestamp;", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Timestamp getUNINITIALIZED() {
            return UNINITIALIZED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampState.values().length];
            nArray[TimestampState.UNAVAILABLE.ordinal()] = 1;
            nArray[TimestampState.OFFLINE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

