/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.adtui.TabularLayout;
import com.google.services.firebase.insights.datamodel.IssueStats;
import com.google.services.firebase.insights.datamodel.StatsGroup;
import com.google.services.firebase.insights.ui.DistributionPanel;
import com.intellij.ide.HelpTooltip;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/google/services/firebase/insights/ui/DistributionPanel;", "Ljavax/swing/JPanel;", "()V", "updateDistribution", "", "stats", "Lcom/google/services/firebase/insights/datamodel/IssueStats;", "", "category", "", "firebase"})
public final class DistributionPanel
extends JPanel {
    public DistributionPanel() {
        super((LayoutManager)new TabularLayout("Fit,Fit,*,Fit"));
        this.setOpaque(false);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateDistribution(@NotNull IssueStats<Double> stats, @NotNull String category) {
        void $this$updateDistribution_u24lambda_u2d5;
        boolean bl;
        DistributionPanel distributionPanel;
        JLabel jLabel;
        Intrinsics.checkNotNullParameter(stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)4, (int)4, (int)4, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(4, 4, 4, 4)");
        JBEmptyBorder emptyBorder = jBEmptyBorder;
        if (stats.getGroups().isEmpty()) {
            void $this$updateDistribution_u24lambda_u2d0;
            JLabel jLabel2 = jLabel = new JLabel("No data available");
            distributionPanel = this;
            bl = false;
            $this$updateDistribution_u24lambda_u2d0.setBorder((Border)emptyBorder);
            distributionPanel.add((Component)jLabel, new TabularLayout.Constraint(stats.getGroups().size(), 0, 4));
        }
        Iterable $this$forEachIndexed$iv = stats.getGroups();
        boolean $i$f$forEachIndexed232 = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d3;
            JLabel jLabel2;
            void group;
            JLabel jLabel3;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            StatsGroup statsGroup = (StatsGroup)item$iv;
            int index = n;
            boolean bl2 = false;
            JLabel $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d1 = jLabel3 = new JLabel(group.getGroupName());
            boolean bl3 = false;
            $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d1.setBorder((Border)emptyBorder);
            JLabel nameLabel = jLabel3;
            this.add((Component)nameLabel, new TabularLayout.Constraint(index, 0, 0, 4, null));
            int percent = MathKt.roundToInt((double)((Number)group.getPercentage()).doubleValue());
            JComponent $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d2 = jLabel2 = new JLabel(percent + "%");
            boolean bl32 = false;
            $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d2.setBorder((Border)emptyBorder);
            JLabel percentLabel = jLabel2;
            this.add((Component)percentLabel, new TabularLayout.Constraint(index, 1, 0, 4, null));
            JProgressBar jProgressBar = new JProgressBar(0, 100);
            $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d2 = jProgressBar;
            DistributionPanel distributionPanel2 = this;
            boolean bl4 = false;
            $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d3.setValue(percent);
            $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d3.setOpaque(false);
            $this$updateDistribution_u24lambda_u2d4_u24lambda_u2d3.setBorder((Border)emptyBorder);
            distributionPanel2.add((Component)jProgressBar, new TabularLayout.Constraint(index, 2, 0, 4, null));
            JLabel jLabel4 = new JLabel(StudioIcons.Common.INFO);
            if (group.getBreakdown().size() <= 1) continue;
            this.add((Component)jLabel4, new TabularLayout.Constraint(index, 3, 0, 4, null));
            HelpTooltip tooltip = new HelpTooltip();
            tooltip.setTitle(group.getGroupName() + " (" + MathKt.roundToInt((double)((Number)group.getPercentage()).doubleValue()) + ")");
            tooltip.setDescription(CollectionsKt.joinToString$default((Iterable)group.getBreakdown(), (CharSequence)"<br>", (CharSequence)"<html>", (CharSequence)"</html>", (int)0, null, (Function1)updateDistribution.2.2.INSTANCE, (int)24, null));
            tooltip.installOn((JComponent)jLabel4);
        }
        JLabel $i$f$forEachIndexed232 = jLabel = new JLabel("Most affected " + category + ": " + stats.getTopValue());
        distributionPanel = this;
        bl = false;
        $this$updateDistribution_u24lambda_u2d5.setBorder((Border)emptyBorder);
        distributionPanel.add((Component)jLabel, new TabularLayout.Constraint(stats.getGroups().size(), 0, 4));
        this.revalidate();
    }
}

