/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.adtui.common.StudioColorsKt;
import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.datamodel.DetailedIssueStats;
import com.google.services.firebase.insights.ui.AppInsightsStatusText;
import com.google.services.firebase.insights.ui.DistributionPanel;
import com.google.services.firebase.insights.ui.UiUtilKt;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0012\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/google/services/firebase/insights/ui/DetailsPanel;", "Ljavax/swing/JPanel;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "insightsState", "Lkotlinx/coroutines/flow/Flow;", "Lcom/google/services/firebase/insights/AppInsightsState;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/flow/Flow;)V", "deviceDistributionPanel", "Lcom/google/services/firebase/insights/ui/DistributionPanel;", "emptyText", "Lcom/google/services/firebase/insights/ui/AppInsightsStatusText;", "getEmptyText", "()Lcom/google/services/firebase/insights/ui/AppInsightsStatusText;", "value", "", "isDataAvailable", "setDataAvailable", "(Z)V", "osDistributionPanel", "paint", "", "g", "Ljava/awt/Graphics;", "setEmptyText", "updateDistributions", "stats", "Lcom/google/services/firebase/insights/datamodel/DetailedIssueStats;", "updateUI", "firebase"})
public final class DetailsPanel
extends JPanel {
    @NotNull
    private final DistributionPanel deviceDistributionPanel;
    @NotNull
    private final DistributionPanel osDistributionPanel;
    private boolean isDataAvailable;
    @VisibleForTesting
    @NotNull
    private final AppInsightsStatusText emptyText;

    public DetailsPanel(@NotNull CoroutineScope scope, @NotNull Flow<AppInsightsState> insightsState) {
        JPanel jPanel;
        JPanel $this$emptyText_u24lambda_u2d2;
        Object $this$osDistributionPanel_u24lambda_u2d1;
        DistributionPanel $this$deviceDistributionPanel_u24lambda_u2d0;
        Object object;
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(insightsState, (String)"insightsState");
        super(new CardLayout());
        DistributionPanel distributionPanel = object = new DistributionPanel();
        DetailsPanel detailsPanel = this;
        boolean bl = false;
        $this$deviceDistributionPanel_u24lambda_u2d0.setBorder(BorderFactory.createCompoundBorder((Border)JBUI.Borders.emptyLeft((int)9), $this$deviceDistributionPanel_u24lambda_u2d0.getBorder()));
        detailsPanel.deviceDistributionPanel = object;
        $this$deviceDistributionPanel_u24lambda_u2d0 = object = new DistributionPanel();
        detailsPanel = this;
        boolean bl2 = false;
        $this$osDistributionPanel_u24lambda_u2d1.setBorder(BorderFactory.createCompoundBorder((Border)JBUI.Borders.emptyLeft((int)9), $this$osDistributionPanel_u24lambda_u2d1.getBorder()));
        detailsPanel.osDistributionPanel = object;
        $this$osDistributionPanel_u24lambda_u2d1 = object = new AppInsightsStatusText(this, (Function0<Boolean>)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ DetailsPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return !DetailsPanel.access$isDataAvailable$p(this.this$0);
            }
        }));
        detailsPanel = this;
        boolean bl3 = false;
        $this$emptyText_u24lambda_u2d2.appendLine("Select an issue.");
        detailsPanel.emptyText = object;
        this.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        JPanel $this$_init__u24lambda_u2d4 = $this$emptyText_u24lambda_u2d2 = new JPanel();
        boolean bl4 = false;
        $this$_init__u24lambda_u2d4.setBackground(null);
        $this$_init__u24lambda_u2d4.setLayout(new BoxLayout($this$_init__u24lambda_u2d4, 1));
        $this$_init__u24lambda_u2d4.setBorder((Border)JBUI.Borders.empty((int)0, (int)8, (int)0, (int)0));
        $this$_init__u24lambda_u2d4.add((Component)new TitledSeparator("Devices"));
        $this$_init__u24lambda_u2d4.add(this.deviceDistributionPanel);
        $this$_init__u24lambda_u2d4.add((Component)new TitledSeparator("Android Versions"));
        $this$_init__u24lambda_u2d4.add(this.osDistributionPanel);
        $this$_init__u24lambda_u2d4.add(Box.createGlue());
        Component[] componentArray = $this$_init__u24lambda_u2d4.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"components");
        Object[] objectArray = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : objectArray) {
            Component it = (Component)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type javax.swing.JComponent");
            ((JComponent)it).setAlignmentX(0.0f);
        }
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(insightsState, this, null){
            int label;
            final /* synthetic */ Flow<AppInsightsState> $insightsState;
            final /* synthetic */ DetailsPanel this$0;
            {
                this.$insightsState = $insightsState;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Ref.ObjectRef currentStats = new Ref.ObjectRef();
                        Flow<AppInsightsState> flow = this.$insightsState;
                        DetailsPanel detailsPanel = this.this$0;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<AppInsightsState>(detailsPanel, currentStats){
                            final /* synthetic */ DetailsPanel this$0;
                            final /* synthetic */ Ref.ObjectRef $currentStats$inlined;
                            {
                                this.this$0 = detailsPanel;
                                this.$currentStats$inlined = objectRef;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             */
                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                Continuation continuation = $completion;
                                AppInsightsState state = (AppInsightsState)value;
                                boolean bl = false;
                                LoadingState<DetailedIssueStats> stats = state.getCurrentIssueDetails();
                                if (stats instanceof LoadingState.Loading) {
                                    DetailsPanel.access$setDataAvailable(this.this$0, false);
                                    this.this$0.getEmptyText().setText("Loading...");
                                } else if (stats instanceof LoadingState.Ready) {
                                    if (((LoadingState.Ready)stats).getValue() == null) {
                                        DetailsPanel.access$setDataAvailable(this.this$0, false);
                                        DetailsPanel.access$setEmptyText(this.this$0);
                                    } else {
                                        DetailsPanel.access$setDataAvailable(this.this$0, true);
                                        if (!Intrinsics.areEqual((Object)this.$currentStats$inlined.element, ((LoadingState.Ready)stats).getValue())) {
                                            this.$currentStats$inlined.element = ((LoadingState.Ready)stats).getValue();
                                            DetailsPanel.access$updateDistributions(this.this$0, (DetailedIssueStats)((LoadingState.Ready)stats).getValue());
                                        }
                                    }
                                } else if (stats instanceof LoadingState.Failure) {
                                    DetailsPanel.access$setDataAvailable(this.this$0, false);
                                    AppInsightsStatusText appInsightsStatusText = this.this$0.getEmptyText();
                                    String string = ((LoadingState.Failure)stats).getMessage();
                                    if (string == null) {
                                        string = "Unknown failure";
                                    }
                                    appInsightsStatusText.setText(string);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        JPanel headerPanel2 = $this$emptyText_u24lambda_u2d2;
        JPanel mainPanel2 = new JPanel(new BorderLayout());
        mainPanel2.setBackground((Color)StudioColorsKt.getPrimaryContentBackground());
        mainPanel2.add((Component)headerPanel2, "North");
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)mainPanel2, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(mainPanel, SideBorder.NONE)");
        JScrollPane scrollPane2 = jScrollPane;
        scrollPane2.setFocusable(true);
        this.add((Component)scrollPane2, "main");
        JPanel jPanel2 = jPanel = new JPanel();
        detailsPanel = this;
        boolean bl6 = false;
        jPanel2.setOpaque(false);
        detailsPanel.add((Component)jPanel, "empty");
        LayoutManager layoutManager = this.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
        ((CardLayout)layoutManager).show(this, "empty");
    }

    private final void setDataAvailable(boolean value) {
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (value != this.isDataAvailable) {
            LayoutManager layoutManager = this.getLayout();
            Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.CardLayout");
            ((CardLayout)layoutManager).show(this, value ? "main" : "empty");
            this.isDataAvailable = value;
        }
    }

    @NotNull
    public final AppInsightsStatusText getEmptyText() {
        return this.emptyText;
    }

    private final void updateDistributions(DetailedIssueStats stats) {
        this.deviceDistributionPanel.removeAll();
        this.osDistributionPanel.removeAll();
        if (stats == null) {
            return;
        }
        this.deviceDistributionPanel.updateDistribution(stats.getDeviceStats(), "device");
        this.osDistributionPanel.updateDistribution(stats.getOsStats(), "Android version");
    }

    private final void setEmptyText() {
        this.emptyText.clear();
        this.emptyText.appendText("Select an issue.", UiUtilKt.getEMPTY_STATE_TITLE_FORMAT());
        this.emptyText.appendSecondaryText("Select an issue to view the details.", UiUtilKt.getEMPTY_STATE_TEXT_FORMAT(), null);
    }

    @Override
    public void updateUI() {
        block0: {
            super.updateUI();
            AppInsightsStatusText appInsightsStatusText = this.emptyText;
            if (appInsightsStatusText == null) break block0;
            appInsightsStatusText.setFont(StartupUiUtil.getLabelFont());
        }
    }

    @Override
    public void paint(@Nullable Graphics g) {
        super.paint(g);
        this.emptyText.paint(this, g);
    }

    public static final /* synthetic */ boolean access$isDataAvailable$p(DetailsPanel $this) {
        return $this.isDataAvailable;
    }

    public static final /* synthetic */ void access$setDataAvailable(DetailsPanel $this, boolean value) {
        $this.setDataAvailable(value);
    }

    public static final /* synthetic */ void access$setEmptyText(DetailsPanel $this) {
        $this.setEmptyText();
    }

    public static final /* synthetic */ void access$updateDistributions(DetailsPanel $this, DetailedIssueStats stats) {
        $this.updateDistributions(stats);
    }
}

