/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.concurrency.AndroidDispatchers;
import com.android.tools.idea.concurrency.CoroutinesUtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.google.services.firebase.insights.AppInsightsModel;
import com.google.services.firebase.insights.AppInsightsService;
import com.google.services.firebase.insights.FirebaseApp;
import com.google.services.firebase.insights.ui.AppInsightsTabPanel;
import com.google.services.firebase.insights.ui.AppInsightsToolWindowFactory;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.services.firebase.logs.FirebaseTrackerImpl;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowBalloonShowOptions;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.ui.StatusText;
import icons.FirebaseIcons;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002JR\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00100\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001e"}, d2={"Lcom/google/services/firebase/insights/ui/AppInsightsToolWindowFactory;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "()V", "createToolWindowContent", "", "project", "Lcom/intellij/openapi/project/Project;", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "init", "isApplicable", "", "loggedOutErrorStateComponent", "Lcom/intellij/ui/content/Content;", "contentFactory", "Lcom/intellij/ui/content/ContentFactory;", "placeholderContent", "populateTabs", "firebaseApps", "", "Lcom/google/services/firebase/insights/FirebaseApp;", "tabsByModuleName", "", "", "insightsService", "Lcom/google/services/firebase/insights/AppInsightsService;", "Companion", "firebase"})
public final class AppInsightsToolWindowFactory
implements DumbAware,
ToolWindowFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = StudioFlags.APP_INSIGHTS_ENABLED.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"APP_INSIGHTS_ENABLED.get()");
        return (Boolean)object != false && IdeInfo.getInstance().isAndroidStudio();
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        PropertiesComponent.getInstance((Project)project).setValue("com.google.services.firebase.aqiPopupShown", true);
        this.createToolWindowContent(project, toolWindow, FirebaseTrackerImpl.INSTANCE);
    }

    @VisibleForTesting
    public final void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow, @NotNull FirebaseTracker tracker) {
        Content content;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        AppInsightsService insightsService = (AppInsightsService)$this$service$iv.getService(AppInsightsService.class);
        ContentFactory contentFactory = ContentFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)contentFactory, (String)"contentFactory");
        Content it = content = this.placeholderContent(contentFactory);
        boolean bl = false;
        toolWindow.getContentManager().addContent(it);
        Content placeholderContent2 = content;
        Disposable disposable = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"toolWindow.disposable");
        BuildersKt.launch$default((CoroutineScope)CoroutinesUtilsKt.AndroidCoroutineScope$default((Disposable)disposable, null, (int)2, null), (CoroutineContext)((CoroutineContext)AndroidDispatchers.INSTANCE.getUiThread()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(insightsService, placeholderContent2, toolWindow, this, contentFactory, tracker, project, null){
            int label;
            final /* synthetic */ AppInsightsService $insightsService;
            final /* synthetic */ Content $placeholderContent;
            final /* synthetic */ ToolWindow $toolWindow;
            final /* synthetic */ AppInsightsToolWindowFactory this$0;
            final /* synthetic */ ContentFactory $contentFactory;
            final /* synthetic */ FirebaseTracker $tracker;
            final /* synthetic */ Project $project;
            {
                this.$insightsService = $insightsService;
                this.$placeholderContent = $placeholderContent;
                this.$toolWindow = $toolWindow;
                this.this$0 = $receiver;
                this.$contentFactory = $contentFactory;
                this.$tracker = $tracker;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$collect$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Map tabsByModuleName = new LinkedHashMap<K, V>();
                        Ref.BooleanRef isLoggedIn = new Ref.BooleanRef();
                        isLoggedIn.element = true;
                        Flow<AppInsightsModel> flow = this.$insightsService.getConfiguration();
                        Content content = this.$placeholderContent;
                        ToolWindow toolWindow = this.$toolWindow;
                        AppInsightsToolWindowFactory appInsightsToolWindowFactory = this.this$0;
                        ContentFactory contentFactory = this.$contentFactory;
                        FirebaseTracker firebaseTracker = this.$tracker;
                        Project project = this.$project;
                        AppInsightsService appInsightsService = this.$insightsService;
                        boolean $i$f$collect = false;
                        this.label = 1;
                        Object object3 = $this$collect$iv.collect((FlowCollector)new FlowCollector<AppInsightsModel>(content, isLoggedIn, toolWindow, tabsByModuleName, appInsightsToolWindowFactory, contentFactory, firebaseTracker, project, appInsightsService){
                            final /* synthetic */ Content $placeholderContent$inlined;
                            final /* synthetic */ Ref.BooleanRef $isLoggedIn$inlined;
                            final /* synthetic */ ToolWindow $toolWindow$inlined;
                            final /* synthetic */ Map $tabsByModuleName$inlined;
                            final /* synthetic */ AppInsightsToolWindowFactory this$0;
                            final /* synthetic */ ContentFactory $contentFactory$inlined;
                            final /* synthetic */ FirebaseTracker $tracker$inlined;
                            final /* synthetic */ Project $project$inlined;
                            final /* synthetic */ AppInsightsService $insightsService$inlined;
                            {
                                this.$placeholderContent$inlined = content;
                                this.$isLoggedIn$inlined = booleanRef;
                                this.$toolWindow$inlined = toolWindow;
                                this.$tabsByModuleName$inlined = map2;
                                this.this$0 = appInsightsToolWindowFactory;
                                this.$contentFactory$inlined = contentFactory;
                                this.$tracker$inlined = firebaseTracker;
                                this.$project$inlined = project;
                                this.$insightsService$inlined = appInsightsService;
                            }

                            /*
                             * Ignored method signature, as it can't be verified against descriptor
                             * WARNING - void declaration
                             */
                            @Nullable
                            public Object emit(Object value, @NotNull Continuation $completion) {
                                AppInsightsModel appInsightsModel;
                                Continuation continuation = $completion;
                                AppInsightsModel appInsightsModel2 = (AppInsightsModel)value;
                                boolean bl = false;
                                if (this.$placeholderContent$inlined.isValid()) {
                                    ContentManager contentManager = this.$placeholderContent$inlined.getManager();
                                    if (contentManager != null) {
                                        Boxing.boxBoolean((boolean)contentManager.removeContent(this.$placeholderContent$inlined, true));
                                    }
                                }
                                if (Intrinsics.areEqual((Object)(appInsightsModel = appInsightsModel2), (Object)AppInsightsModel.Unauthenticated.INSTANCE)) {
                                    if (this.$isLoggedIn$inlined.element) {
                                        void $this$invokeSuspend_u24lambda_u2d1_u24lambda_u2d0;
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.Builder builder;
                                        this.$toolWindow$inlined.getContentManager().removeAllContents(true);
                                        this.$tabsByModuleName$inlined.clear();
                                        ContentManager contentManager = this.$toolWindow$inlined.getContentManager();
                                        Intrinsics.checkNotNullExpressionValue((Object)this.$contentFactory$inlined, (String)"contentFactory");
                                        contentManager.addContent(AppInsightsToolWindowFactory.access$loggedOutErrorStateComponent(this.this$0, this.$contentFactory$inlined));
                                        this.$isLoggedIn$inlined.element = false;
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.Builder builder2 = builder = AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.newBuilder();
                                        Project project = this.$project$inlined;
                                        FirebaseTracker firebaseTracker = this.$tracker$inlined;
                                        boolean bl2 = false;
                                        $this$invokeSuspend_u24lambda_u2d1_u24lambda_u2d0.setEmptyState(AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails.EmptyState.NO_LOGIN);
                                        Unit unit = Unit.INSTANCE;
                                        AppQualityInsightsUsageEvent.AppQualityInsightsZeroStateDetails appQualityInsightsZeroStateDetails = builder.build();
                                        Intrinsics.checkNotNullExpressionValue((Object)appQualityInsightsZeroStateDetails, (String)"newBuilder()\n           \u2026                 .build()");
                                        firebaseTracker.logZeroState(project, appQualityInsightsZeroStateDetails);
                                    }
                                } else if (appInsightsModel instanceof AppInsightsModel.AppConfiguration) {
                                    if (!this.$isLoggedIn$inlined.element) {
                                        this.$toolWindow$inlined.getContentManager().removeAllContents(true);
                                        this.$isLoggedIn$inlined.element = true;
                                    }
                                    List<FirebaseApp> list = ((AppInsightsModel.AppConfiguration)appInsightsModel2).getAvailableApps();
                                    Intrinsics.checkNotNullExpressionValue((Object)this.$contentFactory$inlined, (String)"contentFactory");
                                    AppInsightsToolWindowFactory.access$populateTabs(this.this$0, list, this.$tabsByModuleName$inlined, this.$toolWindow$inlined, this.$contentFactory$inlined, this.$insightsService$inlined, this.$project$inlined, this.$tracker$inlined);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$collect = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        toolWindow.setDefaultContentUiType(ToolWindowContentUiType.COMBO);
        toolWindow.show();
        toolWindow.setStripeTitle("App Quality Insights");
    }

    public static /* synthetic */ void createToolWindowContent$default(AppInsightsToolWindowFactory appInsightsToolWindowFactory, Project project, ToolWindow toolWindow, FirebaseTracker firebaseTracker, int n, Object object) {
        if ((n & 4) != 0) {
            firebaseTracker = FirebaseTrackerImpl.INSTANCE;
        }
        appInsightsToolWindowFactory.createToolWindowContent(project, toolWindow, firebaseTracker);
    }

    /*
     * WARNING - void declaration
     */
    private final void populateTabs(List<FirebaseApp> firebaseApps, Map<String, Content> tabsByModuleName, ToolWindow toolWindow, ContentFactory contentFactory, AppInsightsService insightsService, Project project, FirebaseTracker tracker) {
        void $this$filterTo$iv$iv;
        Object firebaseApp;
        Object it;
        boolean bl;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = firebaseApps;
        boolean bl2 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Object object = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            FirebaseApp firebaseApp2 = (FirebaseApp)element$iv$iv;
            Map map2 = destination$iv$iv;
            bl = false;
            map2.put(((FirebaseApp)it).getModule().getName(), element$iv$iv);
        }
        Map latestAppsByModuleName = destination$iv$iv;
        for (Map.Entry entry : latestAppsByModuleName.entrySet()) {
            Content tabContent;
            String moduleName = (String)entry.getKey();
            firebaseApp = (FirebaseApp)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)moduleName, (String)"moduleName");
            if (tabsByModuleName.containsKey(moduleName)) continue;
            AppInsightsTabPanel tabPanel = new AppInsightsTabPanel(insightsService.getController((FirebaseApp)firebaseApp), project, tracker, null, 8, null);
            Intrinsics.checkNotNullExpressionValue((Object)contentFactory.createContent((JComponent)tabPanel, moduleName, false), (String)"contentFactory.createCon\u2026Panel, moduleName, false)");
            tabContent.setDisposer((Disposable)tabPanel);
            tabsByModuleName.put(moduleName, tabContent);
            toolWindow.getContentManager().addContent(tabContent);
        }
        Set removedAppsKeys = CollectionsKt.subtract((Iterable)tabsByModuleName.keySet(), (Iterable)latestAppsByModuleName.keySet());
        Map map3 = tabsByModuleName;
        boolean $i$f$filter = false;
        firebaseApp = map3;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            bl = false;
            if (!removedAppsKeys.contains(it.getKey())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map map4 = destination$iv$iv;
        boolean $i$f$forEach = false;
        object = map4.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl3 = false;
            String name = (String)entry.getKey();
            Content removedApp = (Content)entry.getValue();
            toolWindow.getContentManager().removeContent(removedApp, true);
            tabsByModuleName.remove(name);
        }
    }

    private final Content placeholderContent(ContentFactory contentFactory) {
        Content content = contentFactory.createContent((JComponent)new JPanel(){
            @NotNull
            private final placeholderContent.text.1 text;
            {
                void it;
                StatusText statusText;
                StatusText statusText2 = statusText = new StatusText(){

                    protected boolean isStatusVisible() {
                        return true;
                    }
                };
                var var4_3 = this;
                boolean bl = false;
                it.appendLine("Waiting for initial sync...", SimpleTextAttributes.GRAYED_ATTRIBUTES, null);
                it.attachTo((Component)this);
                var4_3.text = statusText;
            }

            public void paint(@Nullable Graphics g) {
                super.paint(g);
                this.text.paint(this, g);
            }
        }, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"contentFactory.createCon\u2026  null,\n      false\n    )");
        return content;
    }

    private final Content loggedOutErrorStateComponent(ContentFactory contentFactory) {
        StatusText statusText;
        StatusText $this$loggedOutErrorStateComponent_u24lambda_u2d4 = statusText = new StatusText(){

            protected boolean isStatusVisible() {
                return true;
            }
        };
        boolean bl = false;
        $this$loggedOutErrorStateComponent_u24lambda_u2d4.appendLine(FirebaseIcons.FIREBASE_LOGO, "", SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
        $this$loggedOutErrorStateComponent_u24lambda_u2d4.appendLine("See real-world app quality insights here", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, null);
        $this$loggedOutErrorStateComponent_u24lambda_u2d4.appendLine("Log in", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)loggedOutErrorStateComponent.loggedOutText.2.1.INSTANCE);
        $this$loggedOutErrorStateComponent_u24lambda_u2d4.appendText(" to Android Studio to connect to your Firebase Account");
        $this$loggedOutErrorStateComponent_u24lambda_u2d4.appendLine("");
        $this$loggedOutErrorStateComponent_u24lambda_u2d4.appendLine(AllIcons.General.ContextHelp, "More Info", SimpleTextAttributes.LINK_ATTRIBUTES, (ActionListener)loggedOutErrorStateComponent.loggedOutText.2.2.INSTANCE);
        StatusText loggedOutText2 = statusText;
        Content content = contentFactory.createContent((JComponent)new JPanel(loggedOutText2){
            final /* synthetic */ loggedOutErrorStateComponent.loggedOutText.1 $loggedOutText;
            {
                this.$loggedOutText = $loggedOutText;
                $loggedOutText.attachTo(this);
            }

            public void paint(@Nullable Graphics g) {
                super.paint(g);
                this.$loggedOutText.paint(this, g);
            }
        }, null, false);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"val loggedOutText =\n    \u2026  null,\n      false\n    )");
        return content;
    }

    public void init(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        toolWindow.setToHideOnEmptyContent(false);
        try {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(toolWindow){
                final /* synthetic */ ToolWindow $toolWindow$inlined;
                {
                    this.$toolWindow$inlined = toolWindow;
                }

                public final void run() {
                    boolean bl = false;
                    if (!this.$toolWindow$inlined.getProject().isDisposed()) {
                        Project project = this.$toolWindow$inlined.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"toolWindow.project");
                        AppInsightsService.Companion.getInstance(project);
                    }
                }
            });
        }
        catch (AlreadyDisposedException alreadyDisposedException) {
            // empty catch block
        }
    }

    public static final /* synthetic */ Content access$loggedOutErrorStateComponent(AppInsightsToolWindowFactory $this, ContentFactory contentFactory) {
        return $this.loggedOutErrorStateComponent(contentFactory);
    }

    public static final /* synthetic */ void access$populateTabs(AppInsightsToolWindowFactory $this, List firebaseApps, Map tabsByModuleName, ToolWindow toolWindow, ContentFactory contentFactory, AppInsightsService insightsService, Project project, FirebaseTracker tracker) {
        $this.populateTabs(firebaseApps, tabsByModuleName, toolWindow, contentFactory, insightsService, project, tracker);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ!\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\"\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/google/services/firebase/insights/ui/AppInsightsToolWindowFactory$Companion;", "", "()V", "maybeShowAqiBalloon", "", "project", "Lcom/intellij/openapi/project/Project;", "setActiveTabFromModule", "module", "Lcom/intellij/openapi/module/Module;", "show", "callback", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Runnable;)Lkotlin/Unit;", "showErrorBalloon", "htmlMsg", "", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        public final void setActiveTabFromModule(@NotNull Module module) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                Project project = module.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("App Quality Insights");
                ToolWindow toolWindow2 = toolWindow;
                if (toolWindow2 == null || (toolWindow2 = toolWindow2.getContentManager()) == null) break block0;
                toolWindow2.setSelectedContent(toolWindow.getContentManager().findContent(module.getName()));
            }
        }

        @Nullable
        public final Unit show(@NotNull Project project, @Nullable Runnable callback) {
            Unit unit;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManagerEx.Companion.getInstanceEx(project).getToolWindow("App Quality Insights");
            if (toolWindow != null) {
                toolWindow.show(callback);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return unit;
        }

        public static /* synthetic */ Unit show$default(Companion companion, Project project, Runnable runnable, int n, Object object) {
            if ((n & 2) != 0) {
                runnable = null;
            }
            return companion.show(project, runnable);
        }

        public final void maybeShowAqiBalloon(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (PropertiesComponent.getInstance((Project)project).getBoolean("com.google.services.firebase.aqiPopupShown")) {
                return;
            }
            try {
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(project){
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$project$inlined = project;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!this.$project$inlined.isDisposed()) {
                            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.$project$inlined);
                            MessageType messageType = MessageType.INFO;
                            Icon icon = StudioIcons.AppQualityInsights.ISSUE;
                            HyperlinkListener hyperlinkListener = new HyperlinkListener(this.$project$inlined){
                                final /* synthetic */ Project $project;
                                {
                                    this.$project = $project;
                                }

                                public final void hyperlinkUpdate(HyperlinkEvent e) {
                                    if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                                        PropertiesComponent.getInstance((Project)this.$project).setValue("com.google.services.firebase.aqiPopupShown", true);
                                    }
                                }
                            };
                            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
                            toolWindowManager.notifyByBalloon(new ToolWindowBalloonShowOptions("App Quality Insights", messageType, "Click to see your Crashlytics issues here.<br/><a href=\"\">Don't show again</a>", icon, hyperlinkListener, null, 32, null));
                        }
                    }
                });
            }
            catch (AlreadyDisposedException alreadyDisposedException) {
                // empty catch block
            }
        }

        public final void showErrorBalloon(@NotNull Project project, @NotNull String htmlMsg, @Nullable HyperlinkListener hyperlinkListener) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)htmlMsg, (String)"htmlMsg");
            try {
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(project, htmlMsg, hyperlinkListener){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ String $htmlMsg$inlined;
                    final /* synthetic */ HyperlinkListener $hyperlinkListener$inlined;
                    {
                        this.$project$inlined = project;
                        this.$htmlMsg$inlined = string;
                        this.$hyperlinkListener$inlined = hyperlinkListener;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (!this.$project$inlined.isDisposed()) {
                            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.$project$inlined);
                            MessageType messageType = MessageType.ERROR;
                            Icon icon = StudioIcons.AppQualityInsights.ISSUE;
                            Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"ERROR");
                            toolWindowManager.notifyByBalloon(new ToolWindowBalloonShowOptions("App Quality Insights", messageType, this.$htmlMsg$inlined, icon, this.$hyperlinkListener$inlined, null, 32, null));
                        }
                    }
                });
            }
            catch (AlreadyDisposedException alreadyDisposedException) {
                // empty catch block
            }
        }

        public static /* synthetic */ void showErrorBalloon$default(Companion companion, Project project, String string, HyperlinkListener hyperlinkListener, int n, Object object) {
            if ((n & 4) != 0) {
                hyperlinkListener = null;
            }
            companion.showErrorBalloon(project, string, hyperlinkListener);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

