/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.adtui.common.AdtUiUtils;
import com.google.services.firebase.insights.datamodel.Fatality;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.IssueState;
import com.google.services.firebase.insights.datamodel.SignalType;
import com.google.services.firebase.insights.ui.UiUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J8\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002J\u0006\u0010%\u001a\u00020 R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/google/services/firebase/insights/ui/AppInsightsIssuesTableCellRenderer;", "Ljavax/swing/table/TableCellRenderer;", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOGGER", "()Lcom/intellij/openapi/diagnostic/Logger;", "leftPanel", "Ljavax/swing/JPanel;", "pendingRequestIcon", "Lcom/intellij/ui/SimpleColoredComponent;", "renderer", "rendererPanel", "signalPanel", "convertToSearchText", "", "issue", "Lcom/google/services/firebase/insights/datamodel/Issue;", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "focused", "viewRowIndex", "", "viewColumnIndex", "renderClassText", "", "className", "style", "availableWidth", "", "updateUI", "firebase"})
public final class AppInsightsIssuesTableCellRenderer
implements TableCellRenderer {
    @NotNull
    public static final AppInsightsIssuesTableCellRenderer INSTANCE = new AppInsightsIssuesTableCellRenderer();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final SimpleColoredComponent pendingRequestIcon;
    @NotNull
    private static final SimpleColoredComponent renderer;
    @NotNull
    private static final JPanel leftPanel;
    @NotNull
    private static final JPanel signalPanel;
    @NotNull
    private static final JPanel rendererPanel;

    private AppInsightsIssuesTableCellRenderer() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    @NotNull
    public final String convertToSearchText(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Pair<String, String> pair = UiUtilKt.getDisplayTitle(issue.getIssueDetails());
        String className = (String)pair.component1();
        String methodName = (String)pair.component2();
        return ((CharSequence)methodName).length() == 0 ? className : className + "." + methodName;
    }

    public final void updateUI() {
        renderer.setFont(StartupUiUtil.getLabelFont());
    }

    @Override
    @NotNull
    public Component getTableCellRendererComponent(@NotNull JTable table, @NotNull Object value, boolean selected, boolean focused, int viewRowIndex, int viewColumnIndex) {
        int n;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Issue issue = (Issue)value;
        renderer.removeAll();
        renderer.clear();
        Color foreground = selected ? table.getSelectionForeground() : table.getForeground();
        Fatality fatality = issue.getIssueDetails().getFatality();
        Intrinsics.checkNotNullExpressionValue((Object)foreground, (String)"foreground");
        renderer.setIcon(UiUtilKt.getFatalityIcon(fatality, selected, foreground, issue.getIssueDetails().getNotesCount() > 0L));
        float availableWidth = 0.0f;
        availableWidth = (float)table.getColumnModel().getColumn(0).getWidth() - (float)JBUI.scale((int)24);
        signalPanel.removeAll();
        Iterable $this$forEach$iv = issue.getIssueDetails().getSignals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SimpleColoredComponent simpleColoredComponent;
            SignalType it = (SignalType)((Object)element$iv);
            boolean bl = false;
            SimpleColoredComponent $this$getTableCellRendererComponent_u24lambda_u2d6_u24lambda_u2d5 = simpleColoredComponent = new SimpleColoredComponent();
            boolean bl2 = false;
            $this$getTableCellRendererComponent_u24lambda_u2d6_u24lambda_u2d5.setIcon(it.getIcon());
            $this$getTableCellRendererComponent_u24lambda_u2d6_u24lambda_u2d5.setIconTextGap(0);
            $this$getTableCellRendererComponent_u24lambda_u2d6_u24lambda_u2d5.setBorder((Border)JBUI.Borders.empty());
            $this$getTableCellRendererComponent_u24lambda_u2d6_u24lambda_u2d5.setOpaque(false);
            SimpleColoredComponent iconLabel = simpleColoredComponent;
            signalPanel.add((Component)iconLabel);
            availableWidth -= (float)JBUIScale.scale((int)20);
        }
        pendingRequestIcon.setVisible(issue.getHasPendingRequests());
        Pair<String, String> pair = UiUtilKt.getDisplayTitle(issue.getIssueDetails());
        String className = (String)pair.component1();
        String methodName = (String)pair.component2();
        renderer.setForeground(foreground);
        switch (WhenMappings.$EnumSwitchMapping$0[issue.getState().ordinal()]) {
            case 1: 
            case 2: {
                n = 0;
                break;
            }
            case 3: 
            case 4: {
                n = 4;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        int style = n;
        if (((CharSequence)methodName).length() == 0) {
            this.renderClassText(className, style, availableWidth);
        } else {
            SimpleTextAttributes methodAttrs = new SimpleTextAttributes(style | 1, null);
            Font methodFont = renderer.getFont().deriveFont(methodAttrs.getStyle());
            FontMetrics methodFontMetrics = rendererPanel.getFontMetrics(methodFont);
            Intrinsics.checkNotNullExpressionValue((Object)methodFontMetrics, (String)"methodFontMetrics");
            String methodText = AdtUiUtils.shrinkToFit((String)methodName, (FontMetrics)methodFontMetrics, (float)availableWidth, (AdtUiUtils.ShrinkDirection)AdtUiUtils.ShrinkDirection.TRUNCATE_START);
            availableWidth -= (float)methodFontMetrics.stringWidth(methodText);
            if (Intrinsics.areEqual((Object)methodText, (Object)methodName)) {
                this.renderClassText(className, style, availableWidth);
            }
            renderer.append(methodText, methodAttrs);
        }
        rendererPanel.setToolTipText("<html>" + issue.getIssueDetails().getTitle() + "<br>" + issue.getIssueDetails().getSubtitle() + "</html>");
        rendererPanel.setBackground(selected ? table.getSelectionBackground() : table.getBackground());
        renderer.setBorder((Border)JBUI.Borders.empty());
        return rendererPanel;
    }

    private final void renderClassText(String className, int style, float availableWidth) {
        SimpleTextAttributes classAttrs = new SimpleTextAttributes(style, null);
        Font classFont = renderer.getFont().deriveFont(classAttrs.getStyle());
        String classText = className + ".";
        FontMetrics fontMetrics = rendererPanel.getFontMetrics(classFont);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"rendererPanel.getFontMetrics(classFont)");
        renderer.append(AdtUiUtils.shrinkToFit((String)classText, (FontMetrics)fontMetrics, (float)availableWidth, (AdtUiUtils.ShrinkDirection)AdtUiUtils.ShrinkDirection.TRUNCATE_START), classAttrs);
    }

    static {
        Logger logger = Logger.getInstance(AppInsightsIssuesTableCellRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(AppInsightsI\u2026CellRenderer::class.java)");
        LOGGER = logger;
        Object object = new SimpleColoredComponent();
        SimpleColoredComponent $this$pendingRequestIcon_u24lambda_u2d0 = object;
        boolean bl = false;
        $this$pendingRequestIcon_u24lambda_u2d0.setIcon(UiUtilKt.getOfflineModeIcon());
        $this$pendingRequestIcon_u24lambda_u2d0.setIconTextGap(0);
        $this$pendingRequestIcon_u24lambda_u2d0.setBorder((Border)JBUI.Borders.empty());
        $this$pendingRequestIcon_u24lambda_u2d0.setOpaque(false);
        $this$pendingRequestIcon_u24lambda_u2d0.setVisible(false);
        pendingRequestIcon = object;
        object = new SimpleColoredComponent();
        SimpleColoredComponent $this$renderer_u24lambda_u2d1 = object;
        boolean bl2 = false;
        $this$renderer_u24lambda_u2d1.setOpaque(false);
        renderer = object;
        Object $this$leftPanel_u24lambda_u2d2 = object = new JPanel(new FlowLayout(1, 0, 0));
        boolean bl3 = false;
        ((JComponent)$this$leftPanel_u24lambda_u2d2).setOpaque(false);
        ((JComponent)$this$leftPanel_u24lambda_u2d2).setBorder((Border)JBUI.Borders.empty());
        ((Container)$this$leftPanel_u24lambda_u2d2).add((Component)pendingRequestIcon);
        ((Container)$this$leftPanel_u24lambda_u2d2).add((Component)renderer);
        leftPanel = object;
        Object $this$signalPanel_u24lambda_u2d3 = object = new JPanel(new FlowLayout(1, 0, 0));
        boolean bl4 = false;
        ((JComponent)$this$signalPanel_u24lambda_u2d3).setOpaque(false);
        ((JComponent)$this$signalPanel_u24lambda_u2d3).setBorder((Border)JBUI.Borders.empty());
        signalPanel = object;
        Object $this$rendererPanel_u24lambda_u2d4 = object = new JPanel(new BorderLayout());
        boolean bl5 = false;
        ((JComponent)$this$rendererPanel_u24lambda_u2d4).setBorder((Border)JBUI.Borders.empty());
        ((Container)$this$rendererPanel_u24lambda_u2d4).add((Component)leftPanel, "West");
        ((Container)$this$rendererPanel_u24lambda_u2d4).add((Component)signalPanel, "East");
        rendererPanel = object;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IssueState.values().length];
            nArray[IssueState.OPEN.ordinal()] = 1;
            nArray[IssueState.CLOSING.ordinal()] = 2;
            nArray[IssueState.CLOSED.ordinal()] = 3;
            nArray[IssueState.OPENING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

