/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.google.services.firebase.insights.CrashlyticsInsight;
import com.google.services.firebase.insights.ui.AppInsightsGutterIconAction;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import icons.StudioIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\t\u0010\u001c\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lcom/google/services/firebase/insights/ui/AppInsightsGutterRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "insights", "", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getInsights", "()Ljava/util/List;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "copy", "equals", "", "other", "", "getClickAction", "Lcom/google/services/firebase/insights/ui/AppInsightsGutterIconAction;", "getIcon", "Ljavax/swing/Icon;", "getTooltipText", "", "hashCode", "", "isNavigateAction", "toString", "firebase"})
public final class AppInsightsGutterRenderer
extends GutterIconRenderer {
    @NotNull
    private final Project project;
    @NotNull
    private final List<CrashlyticsInsight> insights;

    public AppInsightsGutterRenderer(@NotNull Project project, @NotNull List<CrashlyticsInsight> insights) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        this.project = project;
        this.insights = insights;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<CrashlyticsInsight> getInsights() {
        return this.insights;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = StudioIcons.AppQualityInsights.ISSUE;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ISSUE");
        return icon;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getTooltipText() {
        Iterable iterable = this.insights;
        long l = 0L;
        for (Object t : iterable) {
            void it;
            CrashlyticsInsight crashlyticsInsight = (CrashlyticsInsight)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.getIssue().getIssueDetails().getEventsCount();
            l = l2 + l3;
        }
        long eventsCount = l;
        int issuesCount = this.insights.size();
        String eventsString = eventsCount == 1L ? "event" : "events";
        String issuesString = issuesCount == 1 ? "issue" : "issues";
        return "App Quality Insights found " + eventsCount + " " + eventsString + " caused by " + issuesCount + " " + issuesString;
    }

    public boolean isNavigateAction() {
        return true;
    }

    @NotNull
    public AppInsightsGutterIconAction getClickAction() {
        return new AppInsightsGutterIconAction(this.project, this.insights);
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final List<CrashlyticsInsight> component2() {
        return this.insights;
    }

    @NotNull
    public final AppInsightsGutterRenderer copy(@NotNull Project project, @NotNull List<CrashlyticsInsight> insights) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        return new AppInsightsGutterRenderer(project, insights);
    }

    public static /* synthetic */ AppInsightsGutterRenderer copy$default(AppInsightsGutterRenderer appInsightsGutterRenderer, Project project, List list, int n, Object object) {
        if ((n & 1) != 0) {
            project = appInsightsGutterRenderer.project;
        }
        if ((n & 2) != 0) {
            list = appInsightsGutterRenderer.insights;
        }
        return appInsightsGutterRenderer.copy(project, list);
    }

    @NotNull
    public String toString() {
        return "AppInsightsGutterRenderer(project=" + this.project + ", insights=" + this.insights + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + ((Object)this.insights).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AppInsightsGutterRenderer)) {
            return false;
        }
        AppInsightsGutterRenderer appInsightsGutterRenderer = (AppInsightsGutterRenderer)((Object)other);
        if (!Intrinsics.areEqual((Object)this.project, (Object)appInsightsGutterRenderer.project)) {
            return false;
        }
        return Intrinsics.areEqual(this.insights, appInsightsGutterRenderer.insights);
    }
}

