/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.google.services.firebase.insights.CrashlyticsInsight;
import com.google.services.firebase.insights.datamodel.Fatality;
import com.google.services.firebase.insights.ui.JListSimpleColoredComponent;
import com.google.services.firebase.insights.ui.UiUtilKt;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/google/services/firebase/insights/ui/AppInsightsGutterListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "()V", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "firebase"})
final class AppInsightsGutterListCellRenderer
implements ListCellRenderer<CrashlyticsInsight> {
    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends CrashlyticsInsight> list, @NotNull CrashlyticsInsight value, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel jPanel;
        JListSimpleColoredComponent<? extends CrashlyticsInsight> jListSimpleColoredComponent;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JPanel renderer = new JPanel(new BorderLayout());
        renderer.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        Pair<String, String> pair = UiUtilKt.getDisplayTitle(value.getIssue().getIssueDetails());
        String className = (String)pair.component1();
        String methodName = (String)pair.component2();
        JListSimpleColoredComponent<? extends CrashlyticsInsight> $this$getListCellRendererComponent_u24lambda_u2d0 = jListSimpleColoredComponent = new JListSimpleColoredComponent<CrashlyticsInsight>(Fatality.getIcon$default(value.getIssue().getIssueDetails().getFatality(), false, 1, null), list, cellHasFocus);
        boolean bl = false;
        $this$getListCellRendererComponent_u24lambda_u2d0.setToolTipText(value.getIssue().getIssueDetails().getSubtitle());
        $this$getListCellRendererComponent_u24lambda_u2d0.append(className, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (((CharSequence)methodName).length() > 0) {
            $this$getListCellRendererComponent_u24lambda_u2d0.append(".", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            $this$getListCellRendererComponent_u24lambda_u2d0.append(methodName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        JListSimpleColoredComponent<? extends CrashlyticsInsight> leftComponent = jListSimpleColoredComponent;
        renderer.add((Component)((Object)leftComponent), "West");
        JListSimpleColoredComponent<? extends CrashlyticsInsight> $this$getListCellRendererComponent_u24lambda_u2d1 = $this$getListCellRendererComponent_u24lambda_u2d0 = new JListSimpleColoredComponent<CrashlyticsInsight>(StudioIcons.AppQualityInsights.ISSUE, list, cellHasFocus);
        boolean bl2 = false;
        $this$getListCellRendererComponent_u24lambda_u2d1.append(UiUtilKt.ifZero(value.getIssue().getIssueDetails().getEventsCount(), "-"), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        JListSimpleColoredComponent<? extends CrashlyticsInsight> eventsComponent = $this$getListCellRendererComponent_u24lambda_u2d0;
        JListSimpleColoredComponent<? extends CrashlyticsInsight> $this$getListCellRendererComponent_u24lambda_u2d2 = $this$getListCellRendererComponent_u24lambda_u2d1 = new JListSimpleColoredComponent<CrashlyticsInsight>(StudioIcons.LayoutEditor.Palette.QUICK_CONTACT_BADGE, list, cellHasFocus);
        boolean bl3 = false;
        $this$getListCellRendererComponent_u24lambda_u2d2.append(UiUtilKt.ifZero(value.getIssue().getIssueDetails().getImpactedDevicesCount(), "-"), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        JListSimpleColoredComponent<? extends CrashlyticsInsight> usersComponent = $this$getListCellRendererComponent_u24lambda_u2d1;
        JPanel $this$getListCellRendererComponent_u24lambda_u2d3 = jPanel = new JPanel();
        boolean bl4 = false;
        $this$getListCellRendererComponent_u24lambda_u2d3.setOpaque(false);
        $this$getListCellRendererComponent_u24lambda_u2d3.setBorder((Border)JBUI.Borders.emptyLeft((int)15));
        $this$getListCellRendererComponent_u24lambda_u2d3.add((Component)((Object)eventsComponent));
        $this$getListCellRendererComponent_u24lambda_u2d3.add((Component)((Object)usersComponent));
        JPanel countsPanel = jPanel;
        renderer.add((Component)countsPanel, "East");
        renderer.setForeground(cellHasFocus ? list.getSelectionForeground() : list.getForeground());
        renderer.setBackground(cellHasFocus ? list.getSelectionBackground() : list.getBackground());
        return renderer;
    }
}

