/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.ui;

import com.android.tools.adtui.common.ColoredIconGenerator;
import com.google.services.firebase.insights.CrashlyticsInsight;
import com.google.services.firebase.insights.ui.AppInsightsGutterListCellRenderer;
import com.google.services.firebase.insights.ui.AppInsightsToolWindowFactory;
import com.google.services.firebase.insights.ui.ResizedSimpleColoredComponent;
import com.google.services.firebase.insights.ui.UiUtilKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/services/firebase/insights/ui/AppInsightsGutterIconAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "insights", "", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "firebase"})
public final class AppInsightsGutterIconAction
extends AnAction {
    @NotNull
    private final Project project;
    @NotNull
    private final List<CrashlyticsInsight> insights;

    public AppInsightsGutterIconAction(@NotNull Project project, @NotNull List<CrashlyticsInsight> insights) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        this.project = project;
        this.insights = insights;
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(javaClass)");
        return logger;
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        block5: {
            Unit unit;
            JPanel jPanel;
            long l;
            long l2;
            ResizedSimpleColoredComponent resizedSimpleColoredComponent;
            PopupChooserBuilder popupChooserBuilder;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.insights.isEmpty()) {
                return;
            }
            Object $this$actionPerformed_u24lambda_u2d6 = popupChooserBuilder = new PopupChooserBuilder((JList)new JBList((ListModel)new CollectionListModel(this.insights)));
            boolean bl = false;
            $this$actionPerformed_u24lambda_u2d6.setTitle("App Quality Insights");
            $this$actionPerformed_u24lambda_u2d6.setSelectionMode(0);
            $this$actionPerformed_u24lambda_u2d6.setMovable(true);
            $this$actionPerformed_u24lambda_u2d6.setRenderer((ListCellRenderer)new AppInsightsGutterListCellRenderer());
            $this$actionPerformed_u24lambda_u2d6.setItemChosenCallback(new Consumer(this){
                final /* synthetic */ AppInsightsGutterIconAction this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void consume(CrashlyticsInsight chosenInsight) {
                    AppInsightsGutterIconAction.access$getLogger(this.this$0).debug("Gutter icon click for issue " + chosenInsight);
                    AppInsightsToolWindowFactory.Companion.show(AppInsightsGutterIconAction.access$getProject$p(this.this$0), new Runnable(chosenInsight){
                        final /* synthetic */ CrashlyticsInsight $chosenInsight;
                        {
                            this.$chosenInsight = $chosenInsight;
                        }

                        public final void run() {
                            this.$chosenInsight.markAsSelected();
                        }
                    });
                }
            });
            JPanel panel = new JPanel(new BorderLayout());
            panel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
            ResizedSimpleColoredComponent $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d0 = resizedSimpleColoredComponent = new ResizedSimpleColoredComponent();
            boolean bl2 = false;
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d0.append("Select an issue to see details", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d0.setForeground(UIUtil.getLabelDisabledForeground());
            ResizedSimpleColoredComponent hintText = resizedSimpleColoredComponent;
            panel.add((Component)((Object)hintText), "West");
            Iterable iterable = this.insights;
            long l3 = 0L;
            Object object = iterable.iterator();
            while (object.hasNext()) {
                Iterator it;
                Object t = object.next();
                CrashlyticsInsight crashlyticsInsight = (CrashlyticsInsight)t;
                l2 = l3;
                boolean bl3 = false;
                l = ((CrashlyticsInsight)((Object)it)).getIssue().getIssueDetails().getEventsCount();
                l3 = l2 + l;
            }
            long eventsTotal = l3;
            Iterable iterable2 = this.insights;
            long l4 = 0L;
            for (Object bl3 : iterable2) {
                void it;
                CrashlyticsInsight crashlyticsInsight = (CrashlyticsInsight)bl3;
                l2 = l4;
                boolean bl4 = false;
                l = it.getIssue().getIssueDetails().getImpactedDevicesCount();
                l4 = l2 + l;
            }
            long usersTotal = l4;
            Object $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d3 = object = new ResizedSimpleColoredComponent();
            boolean bl5 = false;
            Icon icon = StudioIcons.AppQualityInsights.ISSUE;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ISSUE");
            Color color = UIUtil.getLabelDisabledForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelDisabledForeground()");
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d3.setIcon(ColoredIconGenerator.INSTANCE.generateColoredIcon(icon, color));
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d3.append(UiUtilKt.ifZero(eventsTotal, "-"), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Object eventsComponent = object;
            Object $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d4 = $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d3 = new ResizedSimpleColoredComponent();
            boolean bl6 = false;
            Icon icon2 = StudioIcons.LayoutEditor.Palette.QUICK_CONTACT_BADGE;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"QUICK_CONTACT_BADGE");
            Color color2 = UIUtil.getLabelDisabledForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getLabelDisabledForeground()");
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d4.setIcon(ColoredIconGenerator.INSTANCE.generateColoredIcon(icon2, color2));
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d4.append(UiUtilKt.ifZero(usersTotal, "-"), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            Object usersComponent = $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d3;
            JPanel $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d5 = jPanel = new JPanel();
            boolean bl7 = false;
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d5.setOpaque(false);
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d5.add((Component)eventsComponent);
            $this$actionPerformed_u24lambda_u2d6_u24lambda_u2d5.add((Component)usersComponent);
            JPanel countsPanel = jPanel;
            panel.add((Component)countsPanel, "East");
            $this$actionPerformed_u24lambda_u2d6.setSouthComponent((JComponent)panel);
            JBPopup jBPopup = popupChooserBuilder.createPopup();
            Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"PopupChooserBuilder(JBLi\u2026 }\n        .createPopup()");
            JBPopup popup2 = jBPopup;
            $this$actionPerformed_u24lambda_u2d6 = e.getInputEvent();
            MouseEvent mouseEvent = $this$actionPerformed_u24lambda_u2d6 instanceof MouseEvent ? (MouseEvent)$this$actionPerformed_u24lambda_u2d6 : null;
            if (mouseEvent != null) {
                MouseEvent mouseEvent2 = mouseEvent;
                boolean bl8 = false;
                popup2.show(new RelativePoint(mouseEvent2));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block5;
            AppInsightsGutterIconAction $this$actionPerformed_u24lambda_u2d8 = this;
            boolean bl9 = false;
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    public static final /* synthetic */ Logger access$getLogger(AppInsightsGutterIconAction $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ Project access$getProject$p(AppInsightsGutterIconAction $this) {
        return $this.project;
    }
}

