/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.inspection;

import com.android.tools.idea.flags.StudioFlags;
import com.google.services.firebase.insights.AppInsightsService;
import com.google.services.firebase.insights.CrashlyticsInsight;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.ui.AppInsightsGutterRenderer;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import icons.StudioIcons;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0012\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/google/services/firebase/insights/inspection/CrashlyticsExternalAnnotator;", "Lcom/intellij/lang/annotation/ExternalAnnotator;", "Lcom/google/services/firebase/insights/inspection/CrashlyticsExternalAnnotator$InitialInfo;", "Lcom/google/services/firebase/insights/inspection/CrashlyticsExternalAnnotator$AnnotationResult;", "()V", "lineMarkerProvider", "Lcom/google/services/firebase/insights/inspection/CrashlyticsExternalAnnotator$LineMarkerProvider;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "apply", "", "file", "Lcom/intellij/psi/PsiFile;", "annotationResult", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "collectInformation", "dedupCrashByLine", "", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "crashes", "doAnnotate", "collectedInfo", "AnnotationResult", "InitialInfo", "LineMarkerProvider", "firebase"})
public final class CrashlyticsExternalAnnotator
extends ExternalAnnotator<InitialInfo, AnnotationResult> {
    @NotNull
    private final Logger logger;
    @NotNull
    private final LineMarkerProvider lineMarkerProvider;

    public CrashlyticsExternalAnnotator() {
        Logger logger = Logger.getInstance(((Object)((Object)this)).getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(javaClass)");
        this.logger = logger;
        this.lineMarkerProvider = new LineMarkerProvider();
    }

    @Nullable
    public InitialInfo collectInformation(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!(LineMarkerSettings.getSettings().isEnabled((GutterIconDescriptor)this.lineMarkerProvider) && ((Boolean)StudioFlags.APP_INSIGHTS_ENABLED.get()).booleanValue() && ((Boolean)StudioFlags.APP_INSIGHTS_GUTTER_SUPPORT.get()).booleanValue())) {
            return null;
        }
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        AppInsightsService appInsightsService = (AppInsightsService)$this$service$iv.getService(AppInsightsService.class);
        List<CrashlyticsInsight> issues2 = appInsightsService.analyzeFile(file);
        if (issues2.isEmpty()) {
            this.logger.debug("No Insights found in `" + file + "`");
            return null;
        }
        this.logger.debug("Found " + issues2.size() + " Insights in `" + file.getName() + "`");
        return new InitialInfo(issues2, PsiLinesUtilsKt.getLineCount((PsiElement)((PsiElement)file)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnnotationResult doAnnotate(@Nullable InitialInfo collectedInfo) {
        Map map2;
        List<CrashlyticsInsight> list;
        if (collectedInfo != null && (list = collectedInfo.getInsights()) != null) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            void $this$filterKeys$iv;
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = list;
            boolean $i$f$groupBy22 = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo22 = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                CrashlyticsInsight it = (CrashlyticsInsight)element$iv$iv;
                boolean bl = false;
                Integer key$iv$iv = (int)it.getStackFrame().getLine() - 1;
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            Map $i$f$groupBy22 = destination$iv$iv;
            boolean $i$f$filterKeys22 = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                int it = ((Number)entry$iv.getKey()).intValue();
                boolean bl = false;
                boolean bl3 = 0 <= it ? it <= collectedInfo.getFileLineCount() : false;
                if (!bl3) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $i$f$filterKeys22 = result$iv;
            boolean $i$f$mapValues = false;
            Iterator $i$f$groupByTo22 = $this$mapValues$iv;
            Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv2;
                boolean bl = false;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl4 = false;
                List<CrashlyticsInsight> list2 = this.dedupCrashByLine((List)it.getValue());
                map4.put(k, list2);
            }
            map2 = destination$iv$iv2;
        } else {
            map2 = MapsKt.emptyMap();
        }
        Map map5 = map2;
        return new AnnotationResult(map5);
    }

    public void apply(@NotNull PsiFile file, @Nullable AnnotationResult annotationResult, @NotNull AnnotationHolder holder) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            if (document == null) {
                return;
            }
            Document doc = document;
            Object object = annotationResult;
            if (object == null || (object = ((AnnotationResult)object).getAnnotationByLine()) == null) break block2;
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                int line = ((Number)entry.getKey()).intValue();
                List crashes = (List)entry.getValue();
                int startLineOffset = doc.getLineStartOffset(line);
                AnnotationBuilder annotationBuilder = holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(new TextRange(startLineOffset, startLineOffset));
                Project project = file.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
                annotationBuilder.gutterIconRenderer((GutterIconRenderer)new AppInsightsGutterRenderer(project, crashes)).create();
            }
        }
    }

    private final List<CrashlyticsInsight> dedupCrashByLine(List<CrashlyticsInsight> crashes) {
        Iterable $this$distinctBy$iv = crashes;
        boolean $i$f$distinctBy = false;
        HashSet<Issue> set$iv = new HashSet<Issue>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            CrashlyticsInsight it = (CrashlyticsInsight)e$iv;
            boolean bl = false;
            Issue key$iv = it.getIssue();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/google/services/firebase/insights/inspection/CrashlyticsExternalAnnotator$InitialInfo;", "", "insights", "", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "fileLineCount", "", "(Ljava/util/List;I)V", "getFileLineCount", "()I", "getInsights", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "firebase"})
    public static final class InitialInfo {
        @NotNull
        private final List<CrashlyticsInsight> insights;
        private final int fileLineCount;

        public InitialInfo(@NotNull List<CrashlyticsInsight> insights, int fileLineCount) {
            Intrinsics.checkNotNullParameter(insights, (String)"insights");
            this.insights = insights;
            this.fileLineCount = fileLineCount;
        }

        @NotNull
        public final List<CrashlyticsInsight> getInsights() {
            return this.insights;
        }

        public final int getFileLineCount() {
            return this.fileLineCount;
        }

        @NotNull
        public final List<CrashlyticsInsight> component1() {
            return this.insights;
        }

        public final int component2() {
            return this.fileLineCount;
        }

        @NotNull
        public final InitialInfo copy(@NotNull List<CrashlyticsInsight> insights, int fileLineCount) {
            Intrinsics.checkNotNullParameter(insights, (String)"insights");
            return new InitialInfo(insights, fileLineCount);
        }

        public static /* synthetic */ InitialInfo copy$default(InitialInfo initialInfo, List list, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = initialInfo.insights;
            }
            if ((n2 & 2) != 0) {
                n = initialInfo.fileLineCount;
            }
            return initialInfo.copy(list, n);
        }

        @NotNull
        public String toString() {
            return "InitialInfo(insights=" + this.insights + ", fileLineCount=" + this.fileLineCount + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.insights).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.fileLineCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InitialInfo)) {
                return false;
            }
            InitialInfo initialInfo = (InitialInfo)other;
            if (!Intrinsics.areEqual(this.insights, initialInfo.insights)) {
                return false;
            }
            return this.fileLineCount == initialInfo.fileLineCount;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0003J%\u0010\u000b\u001a\u00020\u00002\u001a\b\u0002\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/google/services/firebase/insights/inspection/CrashlyticsExternalAnnotator$AnnotationResult;", "", "annotationByLine", "", "", "", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "(Ljava/util/Map;)V", "getAnnotationByLine", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "", "firebase"})
    public static final class AnnotationResult {
        @NotNull
        private final Map<Integer, List<CrashlyticsInsight>> annotationByLine;

        public AnnotationResult(@NotNull Map<Integer, ? extends List<CrashlyticsInsight>> annotationByLine) {
            Intrinsics.checkNotNullParameter(annotationByLine, (String)"annotationByLine");
            this.annotationByLine = annotationByLine;
        }

        @NotNull
        public final Map<Integer, List<CrashlyticsInsight>> getAnnotationByLine() {
            return this.annotationByLine;
        }

        @NotNull
        public final Map<Integer, List<CrashlyticsInsight>> component1() {
            return this.annotationByLine;
        }

        @NotNull
        public final AnnotationResult copy(@NotNull Map<Integer, ? extends List<CrashlyticsInsight>> annotationByLine) {
            Intrinsics.checkNotNullParameter(annotationByLine, (String)"annotationByLine");
            return new AnnotationResult(annotationByLine);
        }

        public static /* synthetic */ AnnotationResult copy$default(AnnotationResult annotationResult, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = annotationResult.annotationByLine;
            }
            return annotationResult.copy(map2);
        }

        @NotNull
        public String toString() {
            return "AnnotationResult(annotationByLine=" + this.annotationByLine + ")";
        }

        public int hashCode() {
            return ((Object)this.annotationByLine).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationResult)) {
                return false;
            }
            AnnotationResult annotationResult = (AnnotationResult)other;
            return Intrinsics.areEqual(this.annotationByLine, annotationResult.annotationByLine);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/google/services/firebase/insights/inspection/CrashlyticsExternalAnnotator$LineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "getIcon", "Ljavax/swing/Icon;", "getLineMarkerInfo", "", "element", "Lcom/intellij/psi/PsiElement;", "getName", "", "firebase"})
    public static final class LineMarkerProvider
    extends LineMarkerProviderDescriptor {
        @NotNull
        public String getName() {
            return "App quality insights";
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = StudioIcons.Shell.ToolWindows.APP_QUALITY_INSIGHTS;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"APP_QUALITY_INSIGHTS");
            return icon;
        }

        @Nullable
        public Void getLineMarkerInfo(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return null;
        }
    }
}

