/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.inspection;

import com.google.services.firebase.insights.CrashlyticsInsight;
import com.google.services.firebase.insights.IssueInFrame;
import com.google.services.firebase.insights.datamodel.Issue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BB\u0012'\u0010\u0002\u001a#\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0003\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0003\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\b2\u0006\u0010\u0007\u001a\u00020\u0004R/\u0010\u0002\u001a#\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/google/services/firebase/insights/inspection/CrashToLineNaiveMapper;", "", "issueSupplier", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiFile;", "Lkotlin/ParameterName;", "name", "file", "", "Lcom/google/services/firebase/insights/IssueInFrame;", "onIssueClick", "Lcom/google/services/firebase/insights/datamodel/Issue;", "", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "logIssues", "issues", "retrieve", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "firebase"})
public final class CrashToLineNaiveMapper {
    @NotNull
    private final Function1<PsiFile, List<IssueInFrame>> issueSupplier;
    @NotNull
    private final Function1<Issue, Unit> onIssueClick;
    @NotNull
    private final Logger logger;

    public CrashToLineNaiveMapper(@NotNull Function1<? super PsiFile, ? extends List<IssueInFrame>> issueSupplier, @NotNull Function1<? super Issue, Unit> onIssueClick) {
        Intrinsics.checkNotNullParameter(issueSupplier, (String)"issueSupplier");
        Intrinsics.checkNotNullParameter(onIssueClick, (String)"onIssueClick");
        this.issueSupplier = issueSupplier;
        this.onIssueClick = onIssueClick;
        Logger logger = Logger.getInstance(CrashToLineNaiveMapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(CrashToLineNaiveMapper::class.java)");
        this.logger = logger;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CrashlyticsInsight> retrieve(@NotNull PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Object object = this.issueSupplier.invoke((Object)file);
        List it = (List)object;
        boolean $i$a$-also-CrashToLineNaiveMapper$retrieve$22 = false;
        this.logIssues(it, file);
        Iterable $this$mapNotNull$iv = (Iterable)object;
        boolean $i$f$mapNotNull = false;
        Iterable $i$a$-also-CrashToLineNaiveMapper$retrieve$22 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CrashlyticsInsight it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            IssueInFrame issueInFrame = (IssueInFrame)element$iv$iv;
            boolean bl2 = false;
            int line = (int)issueInFrame.getCrashFrame().getFrame().getLine() - 1;
            if ((PsiLinesUtilsKt.getLineCount((PsiElement)((PsiElement)file)) > line && line >= 0 ? new CrashlyticsInsight(line, issueInFrame.getIssue(), issueInFrame.getCrashFrame().getFrame(), issueInFrame.getCrashFrame().getCause(), this.onIssueClick) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void logIssues(List<IssueInFrame> issues2, PsiFile file) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        if (issues2.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = issues2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            CharSequence charSequence;
            void it;
            IssueInFrame issueInFrame = (IssueInFrame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence2 = it.getIssue().getIssueDetails().getSubtitle();
            if (charSequence2.length() == 0) {
                boolean bl2 = false;
                charSequence = "<missingSubtitle>";
            } else {
                charSequence = charSequence2;
            }
            collection.add((String)charSequence);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void value;
            String $i$f$mapTo2 = (String)iterator$iv.next();
            String acc = (String)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc + "\n" + (String)value;
        }
        String formattedIssues = (String)accumulator$iv;
        this.logger.debug("Found " + issues2.size() + " issues related to " + file.getName() + " [\n" + formattedIssues + "], analyzing...");
    }
}

