/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.datamodel.Note;
import com.google.services.firebase.insights.datamodel.NoteId;
import com.google.services.firebase.insights.datamodel.NoteState;
import com.google.services.firebase.insights.datamodel.Permission;
import com.google.services.firebase.insights.events.AddNoteKt;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J.\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e*\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f0\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010!\u001a\u00020\"*\u00020\"2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Lcom/google/services/firebase/insights/events/RollbackDeleteNoteRequest;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "id", "Lcom/google/services/firebase/insights/datamodel/NoteId;", "cause", "Lcom/google/services/firebase/insights/LoadingState$Failure;", "(Lcom/google/services/firebase/insights/datamodel/NoteId;Lcom/google/services/firebase/insights/LoadingState$Failure;)V", "getCause", "()Lcom/google/services/firebase/insights/LoadingState$Failure;", "getId", "()Lcom/google/services/firebase/insights/datamodel/NoteId;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "revertMarkDeletePending", "Lcom/google/services/firebase/insights/LoadingState;", "", "Lcom/google/services/firebase/insights/datamodel/Note;", "updatePermissionIfApplicable", "Lcom/google/services/firebase/insights/datamodel/Permission;", "firebase"})
public final class RollbackDeleteNoteRequest
implements ChangeEvent {
    @NotNull
    private final NoteId id;
    @NotNull
    private final LoadingState.Failure cause;

    public RollbackDeleteNoteRequest(@NotNull NoteId id, @NotNull LoadingState.Failure cause) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.id = id;
        this.cause = cause;
    }

    @NotNull
    public final NoteId getId() {
        return this.id;
    }

    @NotNull
    public final LoadingState.Failure getCause() {
        return this.cause;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        return new StateTransition<Action>(AppInsightsState.copy$default(state, null, null, AddNoteKt.markNotPending-vmXWUts(state.getIssues(), this.id.getIssueId-s7_ZKiI()), null, this.revertMarkDeletePending(state.getCurrentNotes(), this.id), this.updatePermissionIfApplicable(state.getPermission(), this.cause), null, 75, null), Action.Companion.getNONE());
    }

    private final LoadingState<List<Note>> revertMarkDeletePending(LoadingState<? extends List<Note>> $this$revertMarkDeletePending, NoteId id) {
        return $this$revertMarkDeletePending.map((Function1)new Function1<List<? extends Note>, List<? extends Note>>(id){
            final /* synthetic */ NoteId $id;
            {
                this.$id = $id;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Note> invoke(@Nullable List<Note> it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (it == null) {
                    boolean $i$a$-checkNotNull-RollbackDeleteNoteRequest$revertMarkDeletePending$1$22 = false;
                    String $i$a$-checkNotNull-RollbackDeleteNoteRequest$revertMarkDeletePending$1$22 = "No prior notes fetched, thus deleting any note is not allowed.";
                    throw new IllegalStateException($i$a$-checkNotNull-RollbackDeleteNoteRequest$revertMarkDeletePending$1$22.toString());
                }
                Iterable $i$a$-checkNotNull-RollbackDeleteNoteRequest$revertMarkDeletePending$1$22 = it;
                NoteId noteId = this.$id;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void note;
                    Note note2 = (Note)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Intrinsics.areEqual((Object)note.getId(), (Object)noteId) ? Note.copy$default((Note)note, null, null, null, null, NoteState.CREATED, 15, null) : note);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    private final Permission updatePermissionIfApplicable(Permission $this$updatePermissionIfApplicable, LoadingState.Failure cause) {
        return cause instanceof LoadingState.PermissionDenied ? Permission.READ_ONLY : $this$updatePermissionIfApplicable;
    }

    @NotNull
    public final NoteId component1() {
        return this.id;
    }

    @NotNull
    public final LoadingState.Failure component2() {
        return this.cause;
    }

    @NotNull
    public final RollbackDeleteNoteRequest copy(@NotNull NoteId id, @NotNull LoadingState.Failure cause) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        return new RollbackDeleteNoteRequest(id, cause);
    }

    public static /* synthetic */ RollbackDeleteNoteRequest copy$default(RollbackDeleteNoteRequest rollbackDeleteNoteRequest, NoteId noteId, LoadingState.Failure failure, int n, Object object) {
        if ((n & 1) != 0) {
            noteId = rollbackDeleteNoteRequest.id;
        }
        if ((n & 2) != 0) {
            failure = rollbackDeleteNoteRequest.cause;
        }
        return rollbackDeleteNoteRequest.copy(noteId, failure);
    }

    @NotNull
    public String toString() {
        return "RollbackDeleteNoteRequest(id=" + this.id + ", cause=" + this.cause + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.cause.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RollbackDeleteNoteRequest)) {
            return false;
        }
        RollbackDeleteNoteRequest rollbackDeleteNoteRequest = (RollbackDeleteNoteRequest)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)rollbackDeleteNoteRequest.id)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cause, (Object)rollbackDeleteNoteRequest.cause);
    }
}

