/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.Selection;
import com.google.services.firebase.insights.Timed;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.Note;
import com.google.services.firebase.insights.datamodel.NoteId;
import com.google.services.firebase.insights.datamodel.NoteState;
import com.google.services.firebase.insights.datamodel.Permission;
import com.google.services.firebase.insights.events.AddNoteKt;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J.\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001e*\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f0\u001e2\u0006\u0010!\u001a\u00020\u0015H\u0002J\u0014\u0010\"\u001a\u00020#*\u00020#2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"Lcom/google/services/firebase/insights/events/RollbackAddNoteRequest;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "noteId", "Lcom/google/services/firebase/insights/datamodel/NoteId;", "cause", "Lcom/google/services/firebase/insights/LoadingState$Failure;", "(Lcom/google/services/firebase/insights/datamodel/NoteId;Lcom/google/services/firebase/insights/LoadingState$Failure;)V", "getCause", "()Lcom/google/services/firebase/insights/LoadingState$Failure;", "getNoteId", "()Lcom/google/services/firebase/insights/datamodel/NoteId;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "deleteDraft", "Lcom/google/services/firebase/insights/LoadingState;", "", "Lcom/google/services/firebase/insights/datamodel/Note;", "sessionId", "updatePermissionIfApplicable", "Lcom/google/services/firebase/insights/datamodel/Permission;", "firebase"})
public final class RollbackAddNoteRequest
implements ChangeEvent {
    @NotNull
    private final NoteId noteId;
    @NotNull
    private final LoadingState.Failure cause;

    public RollbackAddNoteRequest(@NotNull NoteId noteId, @NotNull LoadingState.Failure cause) {
        Intrinsics.checkNotNullParameter((Object)noteId, (String)"noteId");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.noteId = noteId;
        this.cause = cause;
    }

    @NotNull
    public final NoteId getNoteId() {
        return this.noteId;
    }

    @NotNull
    public final LoadingState.Failure getCause() {
        return this.cause;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        LoadingState<Timed<Selection<Issue>>> loadingState = AddNoteKt.markNotPending-vmXWUts(state.getIssues(), this.noteId.getIssueId-s7_ZKiI());
        LoadingState<List<Note>> loadingState2 = state.getCurrentNotes();
        String string = this.noteId.getSessionId();
        Intrinsics.checkNotNull((Object)string);
        return new StateTransition<Action>(AppInsightsState.copy$default(state, null, null, loadingState, null, this.deleteDraft(loadingState2, string), this.updatePermissionIfApplicable(state.getPermission(), this.cause), null, 75, null), Action.Companion.getNONE());
    }

    private final LoadingState<List<Note>> deleteDraft(LoadingState<? extends List<Note>> $this$deleteDraft, String sessionId) {
        return $this$deleteDraft.map((Function1)new Function1<List<? extends Note>, List<? extends Note>>(sessionId){
            final /* synthetic */ String $sessionId;
            {
                this.$sessionId = $sessionId;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Note> invoke(@Nullable List<Note> it) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                if (it == null) {
                    boolean $i$a$-checkNotNull-RollbackAddNoteRequest$deleteDraft$1$22 = false;
                    String $i$a$-checkNotNull-RollbackAddNoteRequest$deleteDraft$1$22 = "No prior notes fetched, thus deleting any note is not allowed.";
                    throw new IllegalStateException($i$a$-checkNotNull-RollbackAddNoteRequest$deleteDraft$1$22.toString());
                }
                Iterable $i$a$-checkNotNull-RollbackAddNoteRequest$deleteDraft$1$22 = it;
                String string = this.$sessionId;
                boolean $i$f$filterNot = false;
                void var5_7 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    Note note = (Note)element$iv$iv;
                    boolean bl = false;
                    if (note.getState() == NoteState.CREATING && Intrinsics.areEqual((Object)note.getId().getSessionId(), (Object)string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    private final Permission updatePermissionIfApplicable(Permission $this$updatePermissionIfApplicable, LoadingState.Failure cause) {
        return cause instanceof LoadingState.PermissionDenied ? Permission.READ_ONLY : $this$updatePermissionIfApplicable;
    }

    @NotNull
    public final NoteId component1() {
        return this.noteId;
    }

    @NotNull
    public final LoadingState.Failure component2() {
        return this.cause;
    }

    @NotNull
    public final RollbackAddNoteRequest copy(@NotNull NoteId noteId, @NotNull LoadingState.Failure cause) {
        Intrinsics.checkNotNullParameter((Object)noteId, (String)"noteId");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        return new RollbackAddNoteRequest(noteId, cause);
    }

    public static /* synthetic */ RollbackAddNoteRequest copy$default(RollbackAddNoteRequest rollbackAddNoteRequest, NoteId noteId, LoadingState.Failure failure, int n, Object object) {
        if ((n & 1) != 0) {
            noteId = rollbackAddNoteRequest.noteId;
        }
        if ((n & 2) != 0) {
            failure = rollbackAddNoteRequest.cause;
        }
        return rollbackAddNoteRequest.copy(noteId, failure);
    }

    @NotNull
    public String toString() {
        return "RollbackAddNoteRequest(noteId=" + this.noteId + ", cause=" + this.cause + ")";
    }

    public int hashCode() {
        int result2 = this.noteId.hashCode();
        result2 = result2 * 31 + this.cause.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RollbackAddNoteRequest)) {
            return false;
        }
        RollbackAddNoteRequest rollbackAddNoteRequest = (RollbackAddNoteRequest)other;
        if (!Intrinsics.areEqual((Object)this.noteId, (Object)rollbackAddNoteRequest.noteId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.cause, (Object)rollbackAddNoteRequest.cause);
    }
}

