/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.IssueId;
import com.google.services.firebase.insights.datamodel.Note;
import com.google.services.firebase.insights.datamodel.NoteState;
import com.google.services.firebase.insights.events.AddNoteKt;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J6\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0\u001d*\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006 "}, d2={"Lcom/google/services/firebase/insights/events/NoteAdded;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "note", "Lcom/google/services/firebase/insights/datamodel/Note;", "sessionId", "", "(Lcom/google/services/firebase/insights/datamodel/Note;Ljava/lang/String;)V", "getNote", "()Lcom/google/services/firebase/insights/datamodel/Note;", "getSessionId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "markDraftDone", "Lcom/google/services/firebase/insights/LoadingState;", "", "newNote", "firebase"})
public final class NoteAdded
implements ChangeEvent {
    @NotNull
    private final Note note;
    @NotNull
    private final String sessionId;

    public NoteAdded(@NotNull Note note, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        this.note = note;
        this.sessionId = sessionId;
    }

    @NotNull
    public final Note getNote() {
        return this.note;
    }

    @NotNull
    public final String getSessionId() {
        return this.sessionId;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Issue issue = state.getSelectedIssue();
        String string = issue != null ? issue.getId-s7_ZKiI() : null;
        String string2 = this.note.getId().getIssueId-s7_ZKiI();
        String string3 = string;
        return new StateTransition<Action>(AppInsightsState.copy$default(state, null, null, AddNoteKt.incrementNotesCount-vmXWUts(AddNoteKt.markNotPending-vmXWUts(state.getIssues(), this.note.getId().getIssueId-s7_ZKiI()), this.note.getId().getIssueId-s7_ZKiI()), null, (string3 == null ? false : IssueId.equals-impl0(string3, string2)) ? this.markDraftDone(state.getCurrentNotes(), this.note, this.sessionId) : state.getCurrentNotes(), null, null, 107, null), Action.Companion.getNONE());
    }

    private final LoadingState<List<Note>> markDraftDone(LoadingState<? extends List<Note>> $this$markDraftDone, Note newNote, String sessionId) {
        return $this$markDraftDone.map((Function1)new Function1<List<? extends Note>, List<? extends Note>>(sessionId, newNote){
            final /* synthetic */ String $sessionId;
            final /* synthetic */ Note $newNote;
            {
                this.$sessionId = $sessionId;
                this.$newNote = $newNote;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Note> invoke(@Nullable List<Note> it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (it == null) {
                    boolean $i$a$-checkNotNull-NoteAdded$markDraftDone$1$22 = false;
                    String $i$a$-checkNotNull-NoteAdded$markDraftDone$1$22 = "No prior notes fetched, thus adding on new note is not allowed.";
                    throw new IllegalStateException($i$a$-checkNotNull-NoteAdded$markDraftDone$1$22.toString());
                }
                Iterable $i$a$-checkNotNull-NoteAdded$markDraftDone$1$22 = it;
                String string = this.$sessionId;
                Note note = this.$newNote;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void note2;
                    Note note3 = (Note)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(note2.getState() == NoteState.CREATING && Intrinsics.areEqual((Object)note2.getId().getSessionId(), (Object)string) ? note : note2);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    @NotNull
    public final Note component1() {
        return this.note;
    }

    @NotNull
    public final String component2() {
        return this.sessionId;
    }

    @NotNull
    public final NoteAdded copy(@NotNull Note note, @NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        return new NoteAdded(note, sessionId);
    }

    public static /* synthetic */ NoteAdded copy$default(NoteAdded noteAdded, Note note, String string, int n, Object object) {
        if ((n & 1) != 0) {
            note = noteAdded.note;
        }
        if ((n & 2) != 0) {
            string = noteAdded.sessionId;
        }
        return noteAdded.copy(note, string);
    }

    @NotNull
    public String toString() {
        return "NoteAdded(note=" + this.note + ", sessionId=" + this.sessionId + ")";
    }

    public int hashCode() {
        int result2 = this.note.hashCode();
        result2 = result2 * 31 + this.sessionId.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NoteAdded)) {
            return false;
        }
        NoteAdded noteAdded = (NoteAdded)other;
        if (!Intrinsics.areEqual((Object)this.note, (Object)noteAdded.note)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sessionId, (Object)noteAdded.sessionId);
    }
}

