/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.Filters;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.MultiSelection;
import com.google.services.firebase.insights.Selection;
import com.google.services.firebase.insights.Timed;
import com.google.services.firebase.insights.client.IssueResponse;
import com.google.services.firebase.insights.datamodel.Device;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.IssueId;
import com.google.services.firebase.insights.datamodel.OperatingSystemInfo;
import com.google.services.firebase.insights.datamodel.Permission;
import com.google.services.firebase.insights.datamodel.Version;
import com.google.services.firebase.insights.datamodel.WithCount;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import java.time.Clock;
import java.time.Instant;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c2\u0003J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\bH\u00c2\u0003J/\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/google/services/firebase/insights/events/IssuesChanged;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "issues", "Lcom/google/services/firebase/insights/LoadingState$Done;", "Lcom/google/services/firebase/insights/client/IssueResponse;", "clock", "Ljava/time/Clock;", "previousGoodState", "Lcom/google/services/firebase/insights/AppInsightsState;", "(Lcom/google/services/firebase/insights/LoadingState$Done;Ljava/time/Clock;Lcom/google/services/firebase/insights/AppInsightsState;)V", "getIssues", "()Lcom/google/services/firebase/insights/LoadingState$Done;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "firebase"})
public final class IssuesChanged
implements ChangeEvent {
    @NotNull
    private final LoadingState.Done<IssueResponse> issues;
    @NotNull
    private final Clock clock;
    @Nullable
    private final AppInsightsState previousGoodState;

    public IssuesChanged(@NotNull LoadingState.Done<IssueResponse> issues2, @NotNull Clock clock, @Nullable AppInsightsState previousGoodState) {
        Intrinsics.checkNotNullParameter(issues2, (String)"issues");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.issues = issues2;
        this.clock = clock;
        this.previousGoodState = previousGoodState;
    }

    @NotNull
    public final LoadingState.Done<IssueResponse> getIssues() {
        return this.issues;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Action action2;
        Issue issue;
        Object object;
        Object $this$firstOrNull$iv;
        Issue currentlySelectedIssue;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (this.issues instanceof LoadingState.Failure) {
            return new StateTransition<Action>(AppInsightsState.copy$default(state, null, null, this.issues, new LoadingState.Ready<Object>(null), new LoadingState.Ready<Object>(null), null, null, 99, null), Action.Companion.getNONE());
        }
        MultiSelection<WithCount<Version>> currentVersions = state.getFilters().getVersions();
        MultiSelection<WithCount<Device>> currentDevices = state.getFilters().getDevices();
        MultiSelection<WithCount<OperatingSystemInfo>> currentOses = state.getFilters().getOperatingSystems();
        AppInsightsState appInsightsState = this.previousGoodState;
        LoadingState<Timed<Selection<Issue>>> loadingState = appInsightsState != null ? appInsightsState.getIssues() : null;
        Object object2 = loadingState instanceof LoadingState.Ready ? (LoadingState.Ready)loadingState : null;
        Issue issue2 = object2 != null && (object2 = (Timed)((LoadingState.Ready)object2).getValue()) != null && (object2 = (Selection)((Timed)object2).getValue()) != null ? (Issue)((Selection)object2).getSelected() : (currentlySelectedIssue = null);
        if (this.issues instanceof LoadingState.Ready) {
            Object v5;
            block8: {
                $this$firstOrNull$iv = ((IssueResponse)((LoadingState.Ready)this.issues).getValue()).getIssues();
                boolean $i$f$firstOrNull = false;
                object = $this$firstOrNull$iv.iterator();
                while (object.hasNext()) {
                    Object element$iv = object.next();
                    Issue it = (Issue)element$iv;
                    boolean bl = false;
                    String string = it.getId-s7_ZKiI();
                    Issue issue3 = currentlySelectedIssue;
                    String string2 = issue3 != null ? issue3.getId-s7_ZKiI() : null;
                    if (!(string2 == null ? false : IssueId.equals-impl0(string, string2))) continue;
                    v5 = element$iv;
                    break block8;
                }
                v5 = null;
            }
            if ((issue = (Issue)v5) == null) {
                issue = (Issue)CollectionsKt.firstOrNull(((IssueResponse)((LoadingState.Ready)this.issues).getValue()).getIssues());
            }
        } else {
            issue = null;
        }
        Issue newSelectedIssue = issue;
        loadingState = this.issues.map((Function1)new Function1<IssueResponse, Timed<? extends Selection<Issue>>>(newSelectedIssue, this){
            final /* synthetic */ Issue $newSelectedIssue;
            final /* synthetic */ IssuesChanged this$0;
            {
                this.$newSelectedIssue = $newSelectedIssue;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Timed<Selection<Issue>> invoke(@NotNull IssueResponse it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Selection<Issue> selection = new Selection<Issue>(this.$newSelectedIssue, it.getIssues());
                Instant instant = IssuesChanged.access$getClock$p(this.this$0).instant();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"clock.instant()");
                return new Timed<Selection<Issue>>(selection, instant);
            }
        });
        $this$firstOrNull$iv = Filters.copy$default(state.getFilters(), this.issues instanceof LoadingState.Ready ? new MultiSelection<WithCount<Version>>(SetsKt.emptySet(), ((IssueResponse)((LoadingState.Ready)this.issues).getValue()).getVersions()).selectMatching((Function1<WithCount<Version>, Boolean>)((Function1)new Function1<WithCount<Version>, Boolean>(currentVersions){
            final /* synthetic */ MultiSelection<WithCount<Version>> $currentVersions;
            {
                this.$currentVersions = $currentVersions;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull WithCount<Version> it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (!this.$currentVersions.allSelected()) {
                    boolean bl2;
                    block5: {
                        Iterable $this$any$iv = this.$currentVersions.getSelected();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                WithCount current = (WithCount)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getValue(), current.getValue())) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        })) : state.getFilters().getVersions(), null, null, this.issues instanceof LoadingState.Ready ? new MultiSelection<WithCount<Device>>(SetsKt.emptySet(), ((IssueResponse)((LoadingState.Ready)this.issues).getValue()).getDevices()).selectMatching((Function1<WithCount<Device>, Boolean>)((Function1)new Function1<WithCount<Device>, Boolean>(currentDevices){
            final /* synthetic */ MultiSelection<WithCount<Device>> $currentDevices;
            {
                this.$currentDevices = $currentDevices;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull WithCount<Device> it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (!this.$currentDevices.allSelected()) {
                    boolean bl2;
                    block5: {
                        Iterable $this$any$iv = this.$currentDevices.getSelected();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                WithCount current = (WithCount)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getValue(), current.getValue())) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        })) : state.getFilters().getDevices(), this.issues instanceof LoadingState.Ready ? new MultiSelection<WithCount<OperatingSystemInfo>>(SetsKt.emptySet(), ((IssueResponse)((LoadingState.Ready)this.issues).getValue()).getOperatingSystems()).selectMatching((Function1<WithCount<OperatingSystemInfo>, Boolean>)((Function1)new Function1<WithCount<OperatingSystemInfo>, Boolean>(currentOses){
            final /* synthetic */ MultiSelection<WithCount<OperatingSystemInfo>> $currentOses;
            {
                this.$currentOses = $currentOses;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull WithCount<OperatingSystemInfo> it) {
                boolean bl;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                if (!this.$currentOses.allSelected()) {
                    boolean bl2;
                    block5: {
                        Iterable $this$any$iv = this.$currentOses.getSelected();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                WithCount current = (WithCount)element$iv;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getValue(), current.getValue())) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        })) : state.getFilters().getOperatingSystems(), null, 38, null);
        LoadingState $i$f$firstOrNull = this.issues instanceof LoadingState.Ready && newSelectedIssue != null ? (LoadingState)LoadingState.Loading.INSTANCE : (LoadingState)new LoadingState.Ready<Object>(null);
        object = this.issues instanceof LoadingState.Ready && newSelectedIssue != null ? (LoadingState)LoadingState.Loading.INSTANCE : (LoadingState)new LoadingState.Ready<Object>(null);
        LoadingState.Done<IssueResponse> done = this.issues;
        Object object3 = done instanceof LoadingState.Ready ? (LoadingState.Ready)done : null;
        if (object3 == null || (object3 = (IssueResponse)((LoadingState.Ready)object3).getValue()) == null || (object3 = ((IssueResponse)object3).getPermission()) == null) {
            object3 = state.getPermission();
        }
        Object object4 = object3;
        AppInsightsState appInsightsState2 = AppInsightsState.copy$default(state, null, (Filters)$this$firstOrNull$iv, loadingState, $i$f$firstOrNull, (LoadingState)object, (Permission)((Object)object4), null, 65, null);
        if (this.issues instanceof LoadingState.Ready && newSelectedIssue != null) {
            void it;
            $this$firstOrNull$iv = newSelectedIssue.getId-s7_ZKiI();
            AppInsightsState appInsightsState3 = appInsightsState2;
            boolean bl = false;
            action2 = new Action.FetchDetails((String)it, null).and(new Action.FetchNotes((String)it, null));
            appInsightsState2 = appInsightsState3;
        } else {
            action2 = Action.Companion.getNONE();
        }
        Action action3 = action2;
        AppInsightsState appInsightsState4 = appInsightsState2;
        return new StateTransition<Action>(appInsightsState4, action3);
    }

    @NotNull
    public final LoadingState.Done<IssueResponse> component1() {
        return this.issues;
    }

    private final Clock component2() {
        return this.clock;
    }

    private final AppInsightsState component3() {
        return this.previousGoodState;
    }

    @NotNull
    public final IssuesChanged copy(@NotNull LoadingState.Done<IssueResponse> issues2, @NotNull Clock clock, @Nullable AppInsightsState previousGoodState) {
        Intrinsics.checkNotNullParameter(issues2, (String)"issues");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        return new IssuesChanged(issues2, clock, previousGoodState);
    }

    public static /* synthetic */ IssuesChanged copy$default(IssuesChanged issuesChanged, LoadingState.Done done, Clock clock, AppInsightsState appInsightsState, int n, Object object) {
        if ((n & 1) != 0) {
            done = issuesChanged.issues;
        }
        if ((n & 2) != 0) {
            clock = issuesChanged.clock;
        }
        if ((n & 4) != 0) {
            appInsightsState = issuesChanged.previousGoodState;
        }
        return issuesChanged.copy(done, clock, appInsightsState);
    }

    @NotNull
    public String toString() {
        return "IssuesChanged(issues=" + this.issues + ", clock=" + this.clock + ", previousGoodState=" + this.previousGoodState + ")";
    }

    public int hashCode() {
        int result2 = this.issues.hashCode();
        result2 = result2 * 31 + this.clock.hashCode();
        result2 = result2 * 31 + (this.previousGoodState == null ? 0 : this.previousGoodState.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IssuesChanged)) {
            return false;
        }
        IssuesChanged issuesChanged = (IssuesChanged)other;
        if (!Intrinsics.areEqual(this.issues, issuesChanged.issues)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.clock, (Object)issuesChanged.clock)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.previousGoodState, (Object)issuesChanged.previousGoodState);
    }

    public static final /* synthetic */ Clock access$getClock$p(IssuesChanged $this) {
        return $this.clock;
    }
}

