/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.datamodel.TimeIntervalFilter;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/google/services/firebase/insights/events/IntervalChanged;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "interval", "Lcom/google/services/firebase/insights/datamodel/TimeIntervalFilter;", "(Lcom/google/services/firebase/insights/datamodel/TimeIntervalFilter;)V", "getInterval", "()Lcom/google/services/firebase/insights/datamodel/TimeIntervalFilter;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "firebase"})
public final class IntervalChanged
implements ChangeEvent {
    @NotNull
    private final TimeIntervalFilter interval;

    public IntervalChanged(@NotNull TimeIntervalFilter interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        this.interval = interval;
    }

    @NotNull
    public final TimeIntervalFilter getInterval() {
        return this.interval;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        AppInsightsState newState2 = state.selectTimeInterval(this.interval);
        if (Intrinsics.areEqual((Object)newState2, (Object)state)) {
            return new StateTransition<Action>(newState2, Action.Companion.getNONE());
        }
        return new StateTransition<Action>(AppInsightsState.copy$default(newState2, null, null, LoadingState.Loading.INSTANCE, new LoadingState.Ready<Object>(null), new LoadingState.Ready<Object>(null), null, null, 99, null), new Action.Fetch(AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.FetchSource.FILTER));
    }

    @NotNull
    public final TimeIntervalFilter component1() {
        return this.interval;
    }

    @NotNull
    public final IntervalChanged copy(@NotNull TimeIntervalFilter interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        return new IntervalChanged(interval);
    }

    public static /* synthetic */ IntervalChanged copy$default(IntervalChanged intervalChanged, TimeIntervalFilter timeIntervalFilter, int n, Object object) {
        if ((n & 1) != 0) {
            timeIntervalFilter = intervalChanged.interval;
        }
        return intervalChanged.copy(timeIntervalFilter);
    }

    @NotNull
    public String toString() {
        return "IntervalChanged(interval=" + this.interval + ")";
    }

    public int hashCode() {
        return this.interval.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IntervalChanged)) {
            return false;
        }
        IntervalChanged intervalChanged = (IntervalChanged)other;
        return this.interval == intervalChanged.interval;
    }
}

