/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.datamodel.Device;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/google/services/firebase/insights/events/DevicesChanged;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "devices", "", "Lcom/google/services/firebase/insights/datamodel/Device;", "(Ljava/util/Set;)V", "getDevices", "()Ljava/util/Set;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "firebase"})
public final class DevicesChanged
implements ChangeEvent {
    @NotNull
    private final Set<Device> devices;

    public DevicesChanged(@NotNull Set<Device> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        this.devices = devices2;
    }

    @NotNull
    public final Set<Device> getDevices() {
        return this.devices;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        AppInsightsState newState2 = state.selectDevices(this.devices);
        if (Intrinsics.areEqual((Object)newState2, (Object)state)) {
            return new StateTransition<Action>(newState2, Action.Companion.getNONE());
        }
        return new StateTransition<Action>(AppInsightsState.copy$default(newState2, null, null, LoadingState.Loading.INSTANCE, new LoadingState.Ready<Object>(null), new LoadingState.Ready<Object>(null), null, null, 99, null), new Action.Fetch(AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.FetchSource.FILTER));
    }

    @NotNull
    public final Set<Device> component1() {
        return this.devices;
    }

    @NotNull
    public final DevicesChanged copy(@NotNull Set<Device> devices2) {
        Intrinsics.checkNotNullParameter(devices2, (String)"devices");
        return new DevicesChanged(devices2);
    }

    public static /* synthetic */ DevicesChanged copy$default(DevicesChanged devicesChanged, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = devicesChanged.devices;
        }
        return devicesChanged.copy(set);
    }

    @NotNull
    public String toString() {
        return "DevicesChanged(devices=" + this.devices + ")";
    }

    public int hashCode() {
        return ((Object)this.devices).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DevicesChanged)) {
            return false;
        }
        DevicesChanged devicesChanged = (DevicesChanged)other;
        return Intrinsics.areEqual(this.devices, devicesChanged.devices);
    }
}

