/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.datamodel.Note;
import com.google.services.firebase.insights.datamodel.NoteId;
import com.google.services.firebase.insights.datamodel.NoteState;
import com.google.services.firebase.insights.events.AddNoteKt;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\b\u0010\u000f\u001a\u00020\nH\u0002J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J.\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b0\u001a*\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b0\u001a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/google/services/firebase/insights/events/DeleteNoteRequested;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "id", "Lcom/google/services/firebase/insights/datamodel/NoteId;", "(Lcom/google/services/firebase/insights/datamodel/NoteId;)V", "getId", "()Lcom/google/services/firebase/insights/datamodel/NoteId;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "isCreatingNoteInProgress", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "markDeletePending", "Lcom/google/services/firebase/insights/LoadingState;", "", "Lcom/google/services/firebase/insights/datamodel/Note;", "firebase"})
public final class DeleteNoteRequested
implements ChangeEvent {
    @NotNull
    private final NoteId id;

    public DeleteNoteRequested(@NotNull NoteId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
    }

    @NotNull
    public final NoteId getId() {
        return this.id;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        if (!(!this.isCreatingNoteInProgress())) {
            boolean bl = false;
            String string = "Deleting on \"creating in progress\" note is not allowed.";
            throw new IllegalStateException(string.toString());
        }
        return new StateTransition<Action>(AppInsightsState.copy$default(state, null, null, AddNoteKt.markPending-vmXWUts(state.getIssues(), this.id.getIssueId-s7_ZKiI()), null, this.markDeletePending(state.getCurrentNotes(), this.id), null, null, 107, null), new Action.DeleteNote(this.id));
    }

    private final boolean isCreatingNoteInProgress() {
        return ((CharSequence)this.id.getNoteId()).length() == 0 && this.id.getSessionId() != null;
    }

    private final LoadingState<List<Note>> markDeletePending(LoadingState<? extends List<Note>> $this$markDeletePending, NoteId id) {
        return $this$markDeletePending.map((Function1)new Function1<List<? extends Note>, List<? extends Note>>(id){
            final /* synthetic */ NoteId $id;
            {
                this.$id = $id;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Note> invoke(@Nullable List<Note> it) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (it == null) {
                    boolean $i$a$-checkNotNull-DeleteNoteRequested$markDeletePending$1$22 = false;
                    String $i$a$-checkNotNull-DeleteNoteRequested$markDeletePending$1$22 = "No prior notes fetched, thus deleting any note is not allowed.";
                    throw new IllegalStateException($i$a$-checkNotNull-DeleteNoteRequested$markDeletePending$1$22.toString());
                }
                Iterable $i$a$-checkNotNull-DeleteNoteRequested$markDeletePending$1$22 = it;
                NoteId noteId = this.$id;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void note;
                    Note note2 = (Note)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Intrinsics.areEqual((Object)note.getId(), (Object)noteId) ? Note.copy$default((Note)note, null, null, null, null, NoteState.DELETING, 15, null) : note);
                }
                return (List)destination$iv$iv;
            }
        });
    }

    @NotNull
    public final NoteId component1() {
        return this.id;
    }

    @NotNull
    public final DeleteNoteRequested copy(@NotNull NoteId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new DeleteNoteRequested(id);
    }

    public static /* synthetic */ DeleteNoteRequested copy$default(DeleteNoteRequested deleteNoteRequested, NoteId noteId, int n, Object object) {
        if ((n & 1) != 0) {
            noteId = deleteNoteRequested.id;
        }
        return deleteNoteRequested.copy(noteId);
    }

    @NotNull
    public String toString() {
        return "DeleteNoteRequested(id=" + this.id + ")";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DeleteNoteRequested)) {
            return false;
        }
        DeleteNoteRequested deleteNoteRequested = (DeleteNoteRequested)other;
        return Intrinsics.areEqual((Object)this.id, (Object)deleteNoteRequested.id);
    }
}

