/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.Filters;
import com.google.services.firebase.insights.FirebaseApp;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.ModuleUtilKt;
import com.google.services.firebase.insights.MultiSelection;
import com.google.services.firebase.insights.Selection;
import com.google.services.firebase.insights.VariantConnection;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\n\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0002J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/google/services/firebase/insights/events/ConnectionsChanged;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "firebaseApp", "Lcom/google/services/firebase/insights/FirebaseApp;", "(Lcom/google/services/firebase/insights/FirebaseApp;)V", "getFirebaseApp", "()Lcom/google/services/firebase/insights/FirebaseApp;", "component1", "copy", "equals", "", "other", "", "findActiveConnection", "Lcom/google/services/firebase/insights/VariantConnection;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "hashCode", "", "inferActiveConnectionFromSelectedVariant", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "firebase"})
public final class ConnectionsChanged
implements ChangeEvent {
    @NotNull
    private final FirebaseApp firebaseApp;

    public ConnectionsChanged(@NotNull FirebaseApp firebaseApp) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        this.firebaseApp = firebaseApp;
    }

    @NotNull
    public final FirebaseApp getFirebaseApp() {
        return this.firebaseApp;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        StateTransition<Action.Fetch> stateTransition;
        boolean activeConnectionChanged;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        VariantConnection activeConnection = this.findActiveConnection(state);
        boolean bl = activeConnectionChanged = !Intrinsics.areEqual((Object)activeConnection, (Object)state.getConnections().getSelected());
        if (activeConnectionChanged) {
            Selection<VariantConnection> selection = new Selection<VariantConnection>(activeConnection, this.firebaseApp.getConnections());
            LoadingState.Loading loading = LoadingState.Loading.INSTANCE;
            LoadingState.Ready<Object> ready = new LoadingState.Ready<Object>(null);
            LoadingState.Ready<Object> ready2 = new LoadingState.Ready<Object>(null);
            Filters filters = Filters.copy$default(state.getFilters(), MultiSelection.Companion.emptySelection(), null, null, null, null, null, 62, null);
            StateTransition<Action.Fetch> stateTransition2 = new StateTransition<Action.Fetch>(AppInsightsState.copy$default(state, selection, filters, loading, ready, ready2, null, null, 96, null), new Action.Fetch(AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.FetchSource.PROJECT_SELECTION));
            stateTransition = stateTransition2;
        } else {
            stateTransition = new StateTransition<Action>(AppInsightsState.copy$default(state, new Selection<VariantConnection>(activeConnection, this.firebaseApp.getConnections()), null, null, null, null, null, null, 126, null), Action.Companion.getNONE());
        }
        return stateTransition;
    }

    private final VariantConnection inferActiveConnectionFromSelectedVariant() {
        Object v2;
        block3: {
            String string = ModuleUtilKt.getAndroidAppId(this.firebaseApp.getModule());
            if (string == null) {
                return null;
            }
            String appId = string;
            Object object = GradleAndroidModel.Companion.get(this.firebaseApp.getModule());
            if (object == null || (object = object.getSelectedVariant()) == null || (object = object.getDisplayName()) == null) {
                return null;
            }
            Object variantName = object;
            Iterable $this$firstOrNull$iv = this.firebaseApp.getConnections();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VariantConnection it = (VariantConnection)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getConnection().getAppId(), (Object)appId) && Intrinsics.areEqual((Object)it.getVariantName(), (Object)variantName))) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        return v2;
    }

    private final VariantConnection findActiveConnection(AppInsightsState state) {
        VariantConnection currentSelection = state.getConnections().getSelected();
        if (CollectionsKt.contains((Iterable)this.firebaseApp.getConnections(), (Object)currentSelection)) {
            return currentSelection;
        }
        VariantConnection variantConnection = this.inferActiveConnectionFromSelectedVariant();
        if (variantConnection == null) {
            variantConnection = (VariantConnection)CollectionsKt.firstOrNull(this.firebaseApp.getConnections());
        }
        return variantConnection;
    }

    @NotNull
    public final FirebaseApp component1() {
        return this.firebaseApp;
    }

    @NotNull
    public final ConnectionsChanged copy(@NotNull FirebaseApp firebaseApp) {
        Intrinsics.checkNotNullParameter((Object)firebaseApp, (String)"firebaseApp");
        return new ConnectionsChanged(firebaseApp);
    }

    public static /* synthetic */ ConnectionsChanged copy$default(ConnectionsChanged connectionsChanged, FirebaseApp firebaseApp, int n, Object object) {
        if ((n & 1) != 0) {
            firebaseApp = connectionsChanged.firebaseApp;
        }
        return connectionsChanged.copy(firebaseApp);
    }

    @NotNull
    public String toString() {
        return "ConnectionsChanged(firebaseApp=" + this.firebaseApp + ")";
    }

    public int hashCode() {
        return this.firebaseApp.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConnectionsChanged)) {
            return false;
        }
        ConnectionsChanged connectionsChanged = (ConnectionsChanged)other;
        return Intrinsics.areEqual((Object)this.firebaseApp, (Object)connectionsChanged.firebaseApp);
    }
}

