/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.events;

import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.Filters;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.MultiSelection;
import com.google.services.firebase.insights.VariantConnection;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/google/services/firebase/insights/events/ActiveConnectionChanged;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "connection", "Lcom/google/services/firebase/insights/VariantConnection;", "(Lcom/google/services/firebase/insights/VariantConnection;)V", "getConnection", "()Lcom/google/services/firebase/insights/VariantConnection;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "transition", "Lcom/google/services/firebase/insights/events/StateTransition;", "Lcom/google/services/firebase/insights/events/actions/Action;", "state", "Lcom/google/services/firebase/insights/AppInsightsState;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "firebase"})
public final class ActiveConnectionChanged
implements ChangeEvent {
    @NotNull
    private final VariantConnection connection;

    public ActiveConnectionChanged(@NotNull VariantConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.connection = connection;
    }

    @NotNull
    public final VariantConnection getConnection() {
        return this.connection;
    }

    @Override
    @NotNull
    public StateTransition<Action> transition(@NotNull AppInsightsState state, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        AppInsightsState newState2 = state.selectConnection(this.connection);
        if (Intrinsics.areEqual((Object)newState2, (Object)state)) {
            return new StateTransition<Action>(state, Action.Companion.getNONE());
        }
        LoadingState.Loading loading = LoadingState.Loading.INSTANCE;
        LoadingState.Ready<Object> ready = new LoadingState.Ready<Object>(null);
        LoadingState.Ready<Object> ready2 = new LoadingState.Ready<Object>(null);
        Filters filters = Filters.copy$default(state.getFilters(), MultiSelection.Companion.emptySelection(), null, null, null, null, null, 62, null);
        return new StateTransition<Action>(AppInsightsState.copy$default(newState2, null, filters, loading, ready, ready2, null, null, 97, null), new Action.Fetch(AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.FetchSource.PROJECT_SELECTION));
    }

    @NotNull
    public final VariantConnection component1() {
        return this.connection;
    }

    @NotNull
    public final ActiveConnectionChanged copy(@NotNull VariantConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        return new ActiveConnectionChanged(connection);
    }

    public static /* synthetic */ ActiveConnectionChanged copy$default(ActiveConnectionChanged activeConnectionChanged, VariantConnection variantConnection, int n, Object object) {
        if ((n & 1) != 0) {
            variantConnection = activeConnectionChanged.connection;
        }
        return activeConnectionChanged.copy(variantConnection);
    }

    @NotNull
    public String toString() {
        return "ActiveConnectionChanged(connection=" + this.connection + ")";
    }

    public int hashCode() {
        return this.connection.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActiveConnectionChanged)) {
            return false;
        }
        ActiveConnectionChanged activeConnectionChanged = (ActiveConnectionChanged)other;
        return Intrinsics.areEqual((Object)this.connection, (Object)activeConnectionChanged.connection);
    }
}

